/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoGenerator;
import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

public class IEMinasGeraisValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("(((\\d{3})\\.){2}\\d{3}/\\d{4})|(\\d{9}\\.\\d{2}-\\d{2})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{13})");

    public IEMinasGeraisValidator() {
        super(true);
    }

    public IEMinasGeraisValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEMinasGeraisValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 2);
        String digitos = unformattedIE.substring(unformattedIE.length() - 2);
        String digitosCalculados = this.calculaDigitos(iESemDigito);
        return digitos.equals(digitosCalculados);
    }

    private String calculaDigitos(String iESemDigito) {
        String ieComZero = iESemDigito.substring(0, 3) + "0" + iESemDigito.substring(3);
        String digito1 = new DigitoPara(ieComZero).complementarAoModulo().comMultiplicadores(2, 1).somandoIndividualmente().mod(10).trocandoPorSeEncontrar("0", 10).calcula();
        String digito2 = new DigitoPara(iESemDigito + digito1).complementarAoModulo().comMultiplicadoresDeAte(2, 11).trocandoPorSeEncontrar("0", 10, 11).calcula();
        return digito1 + digito2;
    }

    @Override
    public String generateRandomValid() {
        String ieSemDigitos = new DigitoGenerator().generate(11);
        String ieComDigitos = ieSemDigitos + this.calculaDigitos(ieSemDigitos);
        if (this.isFormatted) {
            return super.format(ieComDigitos, "###.###.###/####");
        }
        return ieComDigitos;
    }
}

