/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoGenerator;
import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

public class IETocantinsValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("\\d{2}(.\\d{2}.)?(\\.)?\\d{3}\\.\\d{3}\\-\\d{1}");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{9}|\\d{11})");

    public IETocantinsValidator() {
        super(true);
    }

    public IETocantinsValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IETocantinsValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 1);
        String digito = unformattedIE.substring(unformattedIE.length() - 1);
        if (iESemDigito.length() == 10) {
            iESemDigito = this.removeCaracteresIgnorados(iESemDigito);
        }
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return digito.equals(digitoCalculado);
    }

    private String removeCaracteresIgnorados(String iESemDigito) {
        return iESemDigito.substring(0, 2) + iESemDigito.substring(4);
    }

    private String calculaDigito(String iESemDigito) {
        return new DigitoPara(iESemDigito).complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).calcula();
    }

    @Override
    public String generateRandomValid() {
        String ieSemDigito = new DigitoGenerator().generate(8);
        String ieComDigito = ieSemDigito + this.calculaDigito(ieSemDigito);
        if (this.isFormatted) {
            return this.format(ieComDigito, "##.###.###-#");
        }
        return ieComDigito;
    }
}

