/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.parts.subreport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.parts.subreport.SubreportPartComponent;

public class StandardSubreportPartComponent
implements Serializable,
SubreportPartComponent,
JRChangeEventsSupport {
    private static final long serialVersionUID = 1L;
    protected Boolean usingCache;
    protected Map<String, JRSubreportParameter> parametersMap = new LinkedHashMap<String, JRSubreportParameter>();
    protected List<JRSubreportReturnValue> returnValues = new ArrayList<JRSubreportReturnValue>();
    protected JRExpression parametersMapExpression;
    protected JRExpression expression;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardSubreportPartComponent() {
    }

    public StandardSubreportPartComponent(SubreportPartComponent subreport, JRBaseObjectFactory factory) {
        JRSubreportReturnValue[] subrepReturnValues;
        this.usingCache = subreport.getUsingCache();
        this.parametersMapExpression = factory.getExpression(subreport.getParametersMapExpression());
        this.expression = factory.getExpression(subreport.getExpression());
        JRSubreportParameter[] jrSubreportParameters = subreport.getParameters();
        if (jrSubreportParameters != null && jrSubreportParameters.length > 0) {
            this.parametersMap = new HashMap<String, JRSubreportParameter>(jrSubreportParameters.length);
            for (JRSubreportParameter jrSubreportParameter : jrSubreportParameters) {
                this.parametersMap.put(jrSubreportParameter.getName(), factory.getSubreportParameter(jrSubreportParameter));
            }
        }
        if ((subrepReturnValues = subreport.getReturnValues()) != null && subrepReturnValues.length > 0) {
            this.returnValues = new ArrayList<JRSubreportReturnValue>(subrepReturnValues.length);
            for (int i = 0; i < subrepReturnValues.length; ++i) {
                this.returnValues.add(factory.getSubreportReturnValue(subrepReturnValues[i]));
            }
        }
    }

    @Override
    public Boolean getUsingCache() {
        return this.usingCache;
    }

    @Override
    public void setUsingCache(Boolean usingCache) {
        Boolean old = this.usingCache;
        this.usingCache = usingCache;
        this.getEventSupport().firePropertyChange("isUsingCache", old, this.usingCache);
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void setParametersMapExpression(JRExpression parametersMapExpression) {
        JRExpression old = this.parametersMapExpression;
        this.parametersMapExpression = parametersMapExpression;
        this.getEventSupport().firePropertyChange("parametersMapExpression", old, this.parametersMapExpression);
    }

    @Override
    public JRSubreportParameter[] getParameters() {
        JRSubreportParameter[] parametersArray = new JRSubreportParameter[this.parametersMap.size()];
        this.parametersMap.values().toArray(parametersArray);
        return parametersArray;
    }

    public Map<String, JRSubreportParameter> getParametersMap() {
        return this.parametersMap;
    }

    public void addParameter(JRSubreportParameter subreportParameter) throws JRException {
        if (this.parametersMap.containsKey(subreportParameter.getName())) {
            throw new JRException("design.subreport.duplicate.parameter", new Object[]{subreportParameter.getName()});
        }
        this.parametersMap.put(subreportParameter.getName(), subreportParameter);
        this.getEventSupport().fireCollectionElementAddedEvent("parameters", subreportParameter, this.parametersMap.size() - 1);
    }

    public JRSubreportParameter removeParameter(String name) {
        JRSubreportParameter removed = this.parametersMap.remove(name);
        if (removed != null) {
            this.getEventSupport().fireCollectionElementRemovedEvent("parameters", removed, -1);
        }
        return removed;
    }

    public void addReturnValue(JRSubreportReturnValue returnValue) {
        this.returnValues.add(returnValue);
        this.getEventSupport().fireCollectionElementAddedEvent("returnValues", returnValue, this.returnValues.size() - 1);
    }

    @Override
    public JRSubreportReturnValue[] getReturnValues() {
        JRSubreportReturnValue[] returnValuesArray = new JRSubreportReturnValue[this.returnValues.size()];
        this.returnValues.toArray(returnValuesArray);
        return returnValuesArray;
    }

    public List<JRSubreportReturnValue> getReturnValuesList() {
        return this.returnValues;
    }

    public boolean removeReturnValue(JRSubreportReturnValue returnValue) {
        int idx = this.returnValues.indexOf(returnValue);
        if (idx >= 0) {
            this.returnValues.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("returnValues", returnValue, idx);
            return true;
        }
        return false;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    public void setExpression(JRExpression expression) {
        JRExpression old = this.expression;
        this.expression = expression;
        this.getEventSupport().firePropertyChange("expression", old, this.expression);
    }

    @Override
    public Object clone() {
        StandardSubreportPartComponent clone = null;
        try {
            clone = (StandardSubreportPartComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        if (this.parametersMap != null) {
            clone.parametersMap = new LinkedHashMap<String, JRSubreportParameter>();
            for (String name : this.parametersMap.keySet()) {
                clone.parametersMap.put(name, (JRSubreportParameter)JRCloneUtils.nullSafeClone((JRCloneable)this.parametersMap.get(name)));
            }
        }
        clone.returnValues = JRCloneUtils.cloneList(this.returnValues);
        clone.parametersMapExpression = JRCloneUtils.nullSafeClone(this.parametersMapExpression);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardSubreportPartComponent standardSubreportPartComponent = this;
        synchronized (standardSubreportPartComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

