/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.clientreport;

import io.sentry.DataCategory;
import io.sentry.clientreport.ClientReportKey;
import io.sentry.clientreport.DiscardReason;
import io.sentry.clientreport.DiscardedEvent;
import io.sentry.clientreport.IClientReportStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class AtomicClientReportStorage
implements IClientReportStorage {
    @NotNull
    private final Map<ClientReportKey, AtomicLong> lostEventCounts;

    public AtomicClientReportStorage() {
        ConcurrentHashMap<ClientReportKey, AtomicLong> modifyableEventCountsForInit = new ConcurrentHashMap<ClientReportKey, AtomicLong>();
        for (DiscardReason discardReason : DiscardReason.values()) {
            for (DataCategory category : DataCategory.values()) {
                modifyableEventCountsForInit.put(new ClientReportKey(discardReason.getReason(), category.getCategory()), new AtomicLong(0L));
            }
        }
        this.lostEventCounts = Collections.unmodifiableMap(modifyableEventCountsForInit);
    }

    @Override
    public void addCount(ClientReportKey key, Long count) {
        @Nullable AtomicLong quantity = this.lostEventCounts.get(key);
        if (quantity != null) {
            quantity.addAndGet(count);
        }
    }

    @Override
    public List<DiscardedEvent> resetCountsAndGet() {
        ArrayList<DiscardedEvent> discardedEvents = new ArrayList<DiscardedEvent>();
        for (Map.Entry<ClientReportKey, AtomicLong> entry : this.lostEventCounts.entrySet()) {
            Long quantity = entry.getValue().getAndSet(0L);
            if (quantity <= 0L) continue;
            discardedEvents.add(new DiscardedEvent(entry.getKey().getReason(), entry.getKey().getCategory(), quantity));
        }
        return discardedEvents;
    }
}

