/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.evento.inutilizacao;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="infInut")
public class CTEventoInutilizacaoDados
extends DFBase {
    private static final long serialVersionUID = -5481681546706524562L;
    @Attribute(name="Id", required=true)
    private String identificador;
    @Element(name="tpAmb", required=true)
    private DFAmbiente ambiente;
    @Element(name="xServ", required=true)
    private String nomeServico;
    @Element(name="cUF", required=true)
    private DFUnidadeFederativa uf;
    @Element(name="ano", required=true)
    private Integer ano;
    @Element(name="CNPJ", required=true)
    private String cnpj;
    @Element(name="mod", required=true)
    private String modeloDocumentoFiscal;
    @Element(name="serie", required=true)
    private String serie;
    @Element(name="nCTIni", required=true)
    private String numeroCTInicial;
    @Element(name="nCTFin", required=true)
    private String numeroCTFinal;
    @Element(name="xJust", required=true)
    private String justificativa;

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String string) {
        DFStringValidador.identificadorCTe(string);
        this.identificador = string;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public String getNomeServico() {
        return this.nomeServico;
    }

    public void setNomeServico(String string) {
        if (!string.equals("INUTILIZAR")) {
            throw new IllegalStateException("Nome de servico invalido");
        }
        this.nomeServico = string;
    }

    public DFUnidadeFederativa getUf() {
        return this.uf;
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa;
    }

    public int getAno() {
        return this.ano;
    }

    public void setAno(Integer n) {
        DFIntegerValidador.exatamente2(n, "Ano");
        this.ano = n;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getModeloDocumentoFiscal() {
        return this.modeloDocumentoFiscal;
    }

    public void setModeloDocumentoFiscal(String string) {
        this.modeloDocumentoFiscal = string;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String string) {
        DFStringValidador.tamanho3N(string, "Serie");
        this.serie = string;
    }

    public String getNumeroCTInicial() {
        return this.numeroCTInicial;
    }

    public void setNumeroCTInicial(String string) {
        DFStringValidador.tamanho9N(string, "Numero CT Inicial");
        this.numeroCTInicial = string;
    }

    public String getNumeroCTFinal() {
        return this.numeroCTFinal;
    }

    public void setNumeroCTFinal(String string) {
        DFStringValidador.tamanho9N(string, "Numero CT Final");
        this.numeroCTFinal = string;
    }

    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String string) {
        DFStringValidador.tamanho15a255(string, "Justificativa");
        this.justificativa = string;
    }
}

