/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte300.classes.evento.desacordo.CTeEnviaEventoPrestacaoEmDesacordo;
import com.fincatto.documentofiscal.cte300.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSPrestacaoEmDesacordo
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Prestacao do Servico em Desacordo";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("3.00");
    private static final String EVENTO_SERVICO_EM_DESACORDO = "610110";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE, DFModelo.CTeOS);

    WSPrestacaoEmDesacordo(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno prestacaoEmDesacordoAssinada(String string, String string2) throws Exception {
        OMElement oMElement = super.efetuaEvento(string2, string, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno prestacaoEmDesacordo(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.getXmlAssinado(string, string2, string3, n);
        return this.prestacaoEmDesacordoAssinada(string, string4);
    }

    String getXmlAssinado(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.gerarDadosPrestacaoEmDesacordo(string, string2, string3, n).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string4);
    }

    private CTeEvento gerarDadosPrestacaoEmDesacordo(String string, String string2, String string3, int n) throws Exception {
        CTeEnviaEventoPrestacaoEmDesacordo cTeEnviaEventoPrestacaoEmDesacordo = new CTeEnviaEventoPrestacaoEmDesacordo();
        cTeEnviaEventoPrestacaoEmDesacordo.setDescricaoEvento(DESCRICAO_EVENTO);
        cTeEnviaEventoPrestacaoEmDesacordo.setIndicadorPrestacaoEmDesacordo(1);
        cTeEnviaEventoPrestacaoEmDesacordo.setObservacao(string2.trim());
        DFXMLValidador.validaEventoPrestacaoEmDesacordoCTe300(cTeEnviaEventoPrestacaoEmDesacordo.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoPrestacaoEmDesacordo, EVENTO_SERVICO_EM_DESACORDO, string3, n);
    }
}

