/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.utils;

import com.fincatto.documentofiscal.cte400.classes.nota.CTeNota;
import com.fincatto.documentofiscal.cte400.classes.os.CTeOS;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class CTeGeraChave {
    private final CTeNota nota;
    private final CTeOS cteOS;

    public CTeGeraChave(CTeNota cTeNota) {
        this.nota = cTeNota;
        this.cteOS = null;
    }

    public CTeGeraChave(CTeOS cTeOS) {
        this.nota = null;
        this.cteOS = cTeOS;
    }

    public String geraCodigoRandomico() {
        long l = this.nota != null ? this.nota.getCteNotaInfo().getIdentificacao().getDataEmissao().toInstant().toEpochMilli() : this.cteOS.getInfo().getIdentificacao().getDataEmissao().toInstant().toEpochMilli();
        Random random = new Random(l);
        return StringUtils.leftPad((String)String.valueOf(random.nextInt(100000000)), (int)8, (String)"0");
    }

    public String getChaveAcesso() {
        return String.format("%s%s", this.geraChaveAcessoSemDV(), this.getDV());
    }

    public Integer getDV() {
        int n;
        char[] cArray = this.geraChaveAcessoSemDV().toCharArray();
        int[] nArray = new int[]{2, 3, 4, 5, 6, 7, 8, 9};
        int n2 = 0;
        int n3 = 0;
        for (n = cArray.length; n > 0; --n) {
            if (n2 >= nArray.length) {
                n2 = 0;
            }
            int n4 = Integer.parseInt(String.valueOf(cArray[n - 1]));
            int n5 = nArray[n2++];
            n3 += n4 * n5;
        }
        n = 11 - n3 % 11;
        return n == 11 || n == 10 ? 0 : n;
    }

    private String geraChaveAcessoSemDV() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        ZonedDateTime zonedDateTime;
        String string7;
        if (this.nota != null) {
            string7 = this.nota.getCteNotaInfo().getIdentificacao().getCodigoUF().getCodigoIbge();
            zonedDateTime = this.nota.getCteNotaInfo().getIdentificacao().getDataEmissao();
            string6 = this.nota.getCteNotaInfo().getEmitente().getCnpj();
            string5 = this.nota.getCteNotaInfo().getIdentificacao().getModelo().getCodigo();
            string4 = this.nota.getCteNotaInfo().getIdentificacao().getSerie().toString();
            string3 = this.nota.getCteNotaInfo().getIdentificacao().getNumero().toString();
            string2 = this.nota.getCteNotaInfo().getIdentificacao().getTipoEmissao().getCodigo();
            string = this.nota.getCteNotaInfo().getIdentificacao().getCodigoNumerico();
        } else {
            string7 = this.cteOS.getInfo().getIdentificacao().getCodigoUF().getCodigoIbge();
            zonedDateTime = this.cteOS.getInfo().getIdentificacao().getDataEmissao();
            string6 = this.cteOS.getInfo().getEmitente().getCnpj();
            string5 = this.cteOS.getInfo().getIdentificacao().getModelo().getCodigo();
            string4 = this.cteOS.getInfo().getIdentificacao().getSerie().toString();
            string3 = this.cteOS.getInfo().getIdentificacao().getNumero().toString();
            string2 = this.cteOS.getInfo().getIdentificacao().getTipoEmissao().getCodigo();
            string = this.cteOS.getInfo().getIdentificacao().getCodigoNumerico();
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalStateException("Codigo numerico deve estar presente para gerar a chave de acesso");
        }
        return StringUtils.leftPad((String)string7, (int)2, (String)"0") + StringUtils.leftPad((String)DateTimeFormatter.ofPattern("yyMM").format(zonedDateTime), (int)4, (String)"0") + StringUtils.leftPad((String)string6, (int)14, (String)"0") + StringUtils.leftPad((String)string5, (int)2, (String)"0") + StringUtils.leftPad((String)string4, (int)3, (String)"0") + StringUtils.leftPad((String)string3, (int)9, (String)"0") + StringUtils.leftPad((String)string2, (int)1, (String)"0") + StringUtils.leftPad((String)string, (int)8, (String)"0");
    }
}

