/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoSituacaoTributariaIPI;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoIPITributado
extends DFBase {
    private static final long serialVersionUID = 8601910032276263880L;
    @Element(name="CST")
    private NFNotaInfoSituacaoTributariaIPI situacaoTributaria = null;
    @Element(name="vBC", required=false)
    private String valorBaseCalculo = null;
    @Element(name="pIPI", required=false)
    private String percentualAliquota = null;
    @Element(name="qUnid", required=false)
    private String quantidade = null;
    @Element(name="vUnid", required=false)
    private String valorUnidadeTributavel = null;
    @Element(name="vIPI")
    private String valorTributo = null;

    public void setSituacaoTributaria(NFNotaInfoSituacaoTributariaIPI nFNotaInfoSituacaoTributariaIPI) {
        if (!(nFNotaInfoSituacaoTributariaIPI.equals((Object)NFNotaInfoSituacaoTributariaIPI.ENTRADA_RECUPERACAO_CREDITO) || nFNotaInfoSituacaoTributariaIPI.equals((Object)NFNotaInfoSituacaoTributariaIPI.OUTRAS_ENTRADAS) || nFNotaInfoSituacaoTributariaIPI.equals((Object)NFNotaInfoSituacaoTributariaIPI.SAIDA_TRIBUTADA) || nFNotaInfoSituacaoTributariaIPI.equals((Object)NFNotaInfoSituacaoTributariaIPI.OUTRAS_SAIDAS))) {
            throw new IllegalStateException("Situacao tributaria:" + nFNotaInfoSituacaoTributariaIPI.getCodigo() + " invalido no item IPI tributado.");
        }
        this.situacaoTributaria = nFNotaInfoSituacaoTributariaIPI;
    }

    public void setValorBaseCalculo(BigDecimal bigDecimal) {
        if (this.quantidade != null || this.valorUnidadeTributavel != null) {
            throw new IllegalStateException("Nao pode setar valor base calculo se quantidade ou valor unidade tributavel esta setado");
        }
        this.valorBaseCalculo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC IPI Tributado");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        if (this.quantidade != null || this.valorUnidadeTributavel != null) {
            throw new IllegalStateException("Nao pode setar percentual aliquota se quantidade ou valor unidade tributavel esta setado");
        }
        this.percentualAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota IPI Tributado");
    }

    public void setQuantidade(BigDecimal bigDecimal) {
        if (this.valorBaseCalculo != null || this.percentualAliquota != null) {
            throw new IllegalStateException("Nao pode setar quantidade se valorBaseCalculo ou PercentualAliquota esta setado");
        }
        this.quantidade = DFBigDecimalValidador.tamanho16ComAte4CasasDecimais(bigDecimal, "Quantidade IPI Tributado");
    }

    public void setValorUnidadeTributavel(BigDecimal bigDecimal) {
        if (this.valorBaseCalculo != null || this.percentualAliquota != null) {
            throw new IllegalStateException("Nao pode setar valor unidade tributavel se valorBaseCalculo ou PercentualAliquota esta setado");
        }
        this.valorUnidadeTributavel = DFBigDecimalValidador.tamanho15comAte4CasasDecimais(bigDecimal, "Valor Unitario IPI Tributado");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo IPI Tributado");
    }

    public NFNotaInfoSituacaoTributariaIPI getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getQuantidade() {
        return this.quantidade;
    }

    public String getValorUnidadeTributavel() {
        return this.valorUnidadeTributavel;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }
}

