/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFPais;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;

public class NFEndereco
extends DFBase {
    private static final long serialVersionUID = 417768837786948754L;
    @Element(name="xLgr")
    private String logradouro;
    @Element(name="nro")
    private String numero;
    @Element(name="xCpl", required=false)
    private String complemento;
    @Element(name="xBairro")
    private String bairro;
    @Element(name="cMun")
    private String codigoMunicipio;
    @Element(name="xMun")
    private String descricaoMunicipio;
    @Element(name="UF")
    private String uf;
    @Element(name="CEP", required=false)
    private String cep;
    @Element(name="cPais", required=false)
    private DFPais codigoPais;
    @Element(name="xPais", required=false)
    private String descricaoPais;
    @Element(name="fone", required=false)
    private String telefone;

    public void setLogradouro(String string) {
        DFStringValidador.tamanho60(string, "Logradouro");
        this.logradouro = string;
    }

    public void setNumero(String string) {
        DFStringValidador.tamanho60(string, "Numero do Endereco");
        this.numero = string;
    }

    public void setComplemento(String string) {
        DFStringValidador.tamanho60(string, "Complemento");
        this.complemento = string;
    }

    public void setBairro(String string) {
        DFStringValidador.tamanho2ate60(string, "Bairro");
        this.bairro = string;
    }

    public void setCodigoMunicipio(String string) {
        DFStringValidador.exatamente7(string, "Codigo do Municipio");
        this.codigoMunicipio = string;
    }

    public void setDescricaoMunicipio(String string) {
        DFStringValidador.tamanho60(string, "Descricao do Municipio");
        this.descricaoMunicipio = string;
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        if (this.codigoPais != null && this.codigoPais.equals((Object)DFPais.BRASIL) && dFUnidadeFederativa.equals((Object)DFUnidadeFederativa.EX)) {
            throw new IllegalStateException(String.format("Opera\u00e7\u00e3o com Exterior(%s) e pa\u00eds de destino igual a Brasil", dFUnidadeFederativa.getCodigo()));
        }
        if (this.codigoPais != null && !this.codigoPais.equals((Object)DFPais.BRASIL) && !dFUnidadeFederativa.equals((Object)DFUnidadeFederativa.EX)) {
            throw new IllegalStateException(String.format("Opera\u00e7\u00e3o com Exterior(%s) e UF de destino interna(%s)", this.codigoPais.getDescricao(), dFUnidadeFederativa.getCodigo()));
        }
        this.uf = dFUnidadeFederativa.getCodigo();
    }

    public void setCep(String string) {
        DFStringValidador.exatamente8(string, "CEP");
        this.cep = string;
    }

    public void setCodigoPais(String string) {
        DFStringValidador.tamanho2a4(string, "Codigo do pais");
        DFPais dFPais = DFPais.valueOfCodigo(string);
        this.verificaDestinoOperacao(dFPais);
        this.codigoPais = dFPais;
    }

    public void setCodigoPais(DFPais dFPais) {
        this.verificaDestinoOperacao(dFPais);
        this.codigoPais = dFPais;
    }

    private void verificaDestinoOperacao(DFPais dFPais) {
        if (this.uf != null && this.uf.equals(DFUnidadeFederativa.EX.getCodigo()) && dFPais.equals((Object)DFPais.BRASIL)) {
            throw new IllegalStateException("Opera\u00e7\u00e3o com Exterior e pa\u00eds de destino igual a Brasil");
        }
        if (this.uf != null && !this.uf.equals(DFUnidadeFederativa.EX.getCodigo()) && !dFPais.equals((Object)DFPais.BRASIL)) {
            throw new IllegalStateException(String.format("Opera\u00e7\u00e3o com Exterior(%s) e UF de destino interna(%s)", dFPais.getDescricao(), this.uf));
        }
    }

    public void setDescricaoPais(String string) {
        DFStringValidador.tamanho60(string, "Descricao do pais");
        this.descricaoPais = string;
    }

    public void setTelefone(String string) {
        DFStringValidador.telefone(string);
        this.telefone = string;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public String getDescricaoMunicipio() {
        return this.descricaoMunicipio;
    }

    public String getUf() {
        return this.uf;
    }

    public String getCep() {
        return this.cep;
    }

    public DFPais getCodigoPais() {
        return this.codigoPais;
    }

    public String getDescricaoPais() {
        return this.descricaoPais;
    }

    public String getTelefone() {
        return this.telefone;
    }
}

