/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFRetornoStatus;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class NFProtocoloInfo
extends DFBase {
    private static final long serialVersionUID = -7256753142051587115L;
    @Attribute(name="Id", required=false)
    private String identificador;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="verAplic")
    private String versaoAplicacao;
    @Element(name="chNFe")
    private String chave;
    @Element(name="dhRecbto")
    private String dataRecebimento;
    @Element(name="nProt", required=false)
    private String numeroProtocolo;
    @Element(name="digVal", required=false)
    private String validador;
    @Element(name="cStat")
    private String status;
    @Element(name="xMotivo", required=false)
    private String motivo;
    @Element(name="cMsg", required=false)
    private String codigoMessage;
    @Element(name="xMsg", required=false)
    private String mensagem;

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public void setVersaoAplicacao(String string) {
        this.versaoAplicacao = string;
    }

    public void setChave(String string) {
        this.chave = string;
    }

    public void setDataRecebimento(String string) {
        this.dataRecebimento = string;
    }

    public void setNumeroProtocolo(String string) {
        this.numeroProtocolo = string;
    }

    public void setValidador(String string) {
        this.validador = string;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public void setMotivo(String string) {
        this.motivo = string;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public String getVersaoAplicacao() {
        return this.versaoAplicacao;
    }

    public String getChave() {
        return this.chave;
    }

    public LocalDateTime getDataRecebimento() {
        try {
            return LocalDateTime.parse(this.dataRecebimento, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        }
        catch (Exception exception) {
            return LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX").parse(this.dataRecebimento));
        }
    }

    public String getNumeroProtocolo() {
        return this.numeroProtocolo;
    }

    public String getValidador() {
        return this.validador;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMotivo() {
        if (StringUtils.isBlank((CharSequence)this.motivo)) {
            return ((NFRetornoStatus)((Object)ObjectUtils.defaultIfNull((Object)((Object)NFRetornoStatus.valueOfCodigo(this.status)), (Object)((Object)NFRetornoStatus.CODIGO_999)))).getMotivo();
        }
        return this.motivo;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String string) {
        this.identificador = string;
    }

    public String getCodigoMessage() {
        return this.codigoMessage;
    }

    public void setCodigoMessage(String string) {
        this.codigoMessage = string;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public void setMensagem(String string) {
        this.mensagem = string;
    }
}

