/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.evento;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class NFTipoEvento
extends DFBase {
    private static final long serialVersionUID = 172979194017130488L;
    @Attribute(name="versao")
    private String versao;
    @Element(name="descEvento")
    private String descricaoEvento;
    @Element(name="xCorrecao", required=false)
    private String textoCorrecao;
    @Element(name="xCondUso", required=false)
    private String condicaoUso;

    public void setVersao(BigDecimal bigDecimal) {
        this.versao = DFBigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Versao");
    }

    public void setDescricaoEvento(String string) {
        DFStringValidador.tamanho4a60(string, "Descricao do Evento");
        this.descricaoEvento = string;
    }

    public String getDescricaoEvento() {
        return this.descricaoEvento;
    }

    public String getVersao() {
        return this.versao;
    }

    public void setCondicaoUso(String string) {
        this.condicaoUso = string;
    }

    public void setTextoCorrecao(String string) {
        this.textoCorrecao = string;
    }

    public String getCondicaoUso() {
        return this.condicaoUso;
    }

    public String getTextoCorrecao() {
        return this.textoCorrecao;
    }
}

