/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFCredito;
import com.fincatto.documentofiscal.nfe400.classes.NFDebito;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFProcessoEmissor;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.NFTipoImpressao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIdentificadorLocalDestinoOperacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorIntermediador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorPresencaComprador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoIdentificacaoCompraGov;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoIdentificacaoPagAntecipado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperacaoConsumidorFinal;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class NFNotaInfoIdentificacao
extends DFBase {
    private static final long serialVersionUID = -2568396066960865875L;
    @Element(name="cUF")
    private DFUnidadeFederativa uf;
    @Element(name="cNF")
    private String codigoRandomico;
    @Element(name="natOp")
    private String naturezaOperacao;
    @Element(name="mod")
    private DFModelo modelo;
    @Element(name="serie")
    private String serie;
    @Element(name="nNF")
    private String numeroNota;
    @Element(name="dhEmi")
    private ZonedDateTime dataHoraEmissao;
    @Element(name="dhSaiEnt", required=false)
    private ZonedDateTime dataHoraSaidaOuEntrada;
    @Element(name="tpNF")
    private NFTipo tipo;
    @Element(name="idDest")
    private NFIdentificadorLocalDestinoOperacao identificadorLocalDestinoOperacao;
    @Element(name="cMunFG")
    private String codigoMunicipio;
    @Element(required=false)
    private String cMunFGIBS;
    @Element(name="tpImp")
    private NFTipoImpressao tipoImpressao;
    @Element(name="tpEmis")
    private NFTipoEmissao tipoEmissao;
    @Element(name="cDV")
    private Integer digitoVerificador;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="finNFe")
    private NFFinalidade finalidade;
    @Element(required=false)
    private NFDebito tpNFDebito;
    @Element(required=false)
    private NFCredito tpNFCredito;
    @Element(name="indFinal")
    private NFOperacaoConsumidorFinal operacaoConsumidorFinal;
    @Element(name="indPres")
    private NFIndicadorPresencaComprador indicadorPresencaComprador;
    @Element(name="indIntermed", required=false)
    private NFIndicadorIntermediador indIntermed;
    @Element(name="procEmi")
    private NFProcessoEmissor programaEmissor;
    @Element(name="verProc")
    private String versaoEmissor;
    @Element(name="dhCont", required=false)
    private ZonedDateTime dataHoraContigencia;
    @Element(name="xJust", required=false)
    private String justificativaEntradaContingencia;
    @ElementList(entry="NFref", inline=true, required=false)
    private List<NFInfoReferenciada> referenciadas;
    @Element(name="gCompraGov", required=false)
    private NFNotaInfoIdentificacaoCompraGov gCompraGov;
    @Element(name="gPagAntecipado", required=false)
    private NFNotaInfoIdentificacaoPagAntecipado gPagAntecipado;

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa;
    }

    public void setCodigoRandomico(String string) {
        DFStringValidador.exatamente8(string, "Codigo Randomico");
        DFStringValidador.validaCodigoRandomico(string, "Codigo Randomico");
        if (StringUtils.isNotBlank((CharSequence)this.numeroNota) && StringUtils.equals((CharSequence)this.numeroNota.substring(1), (CharSequence)string)) {
            throw new IllegalStateException(String.format("N\u00famero da nota(%s) e c\u00f3digo(%s) n\u00e3o podem ser iguais", this.numeroNota.substring(1), string));
        }
        this.codigoRandomico = string;
    }

    public void setNaturezaOperacao(String string) {
        DFStringValidador.tamanho60(string, "Natureza da Operacao");
        this.naturezaOperacao = string;
    }

    public void setModelo(DFModelo dFModelo) {
        this.modelo = dFModelo;
    }

    public void setSerie(String string) {
        DFStringValidador.validador(string, "Serie", 3, false, true);
        this.serie = string;
    }

    public void setNumeroNota(String string) {
        DFStringValidador.tamanho9(string, "Numero da Nota");
        if (StringUtils.isNotBlank((CharSequence)this.codigoRandomico) && StringUtils.equals((CharSequence)string.substring(1), (CharSequence)this.codigoRandomico)) {
            throw new IllegalStateException(String.format("N\u00famero da nota(%s) e c\u00f3digo(%s) n\u00e3o podem ser iguais", string.substring(1), this.codigoRandomico));
        }
        this.numeroNota = string;
    }

    public void setDataHoraEmissao(ZonedDateTime zonedDateTime) {
        this.dataHoraEmissao = zonedDateTime;
    }

    public void setDataHoraSaidaOuEntrada(ZonedDateTime zonedDateTime) {
        this.dataHoraSaidaOuEntrada = zonedDateTime;
    }

    public void setTipo(NFTipo nFTipo) {
        this.tipo = nFTipo;
    }

    public void setCodigoMunicipio(String string) {
        DFStringValidador.exatamente7N(string, "Codigo Municipio");
        this.codigoMunicipio = string;
    }

    public void setCMunFGIBS(String string) {
        this.cMunFGIBS = string;
    }

    public void setReferenciadas(List<NFInfoReferenciada> list) {
        DFListValidador.tamanho500(list, "Referenciadas");
        this.referenciadas = list;
    }

    public NFNotaInfoIdentificacaoCompraGov getGCompraGov() {
        return this.gCompraGov;
    }

    public NFNotaInfoIdentificacaoPagAntecipado getGPagAntecipado() {
        return this.gPagAntecipado;
    }

    public void setTipoImpressao(NFTipoImpressao nFTipoImpressao) {
        this.tipoImpressao = nFTipoImpressao;
    }

    public void setTipoEmissao(NFTipoEmissao nFTipoEmissao) {
        this.tipoEmissao = nFTipoEmissao;
    }

    public void setDigitoVerificador(Integer n) {
        DFIntegerValidador.exatamente1(n, "DV");
        this.digitoVerificador = n;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public void setFinalidade(NFFinalidade nFFinalidade) {
        this.finalidade = nFFinalidade;
    }

    public NFDebito getTpNFDebito() {
        return this.tpNFDebito;
    }

    public NFCredito getTpNFCredito() {
        return this.tpNFCredito;
    }

    public void setProgramaEmissor(NFProcessoEmissor nFProcessoEmissor) {
        this.programaEmissor = nFProcessoEmissor;
    }

    public void setVersaoEmissor(String string) {
        DFStringValidador.tamanho20(string, "Versao Emissor");
        this.versaoEmissor = string;
    }

    public void setDataHoraContigencia(ZonedDateTime zonedDateTime) {
        this.dataHoraContigencia = zonedDateTime;
    }

    public void setJustificativaEntradaContingencia(String string) {
        DFStringValidador.tamanho15a256(string, "Justificativa Entrada Contingencia");
        this.justificativaEntradaContingencia = string;
    }

    public void setIdentificadorLocalDestinoOperacao(NFIdentificadorLocalDestinoOperacao nFIdentificadorLocalDestinoOperacao) {
        this.identificadorLocalDestinoOperacao = nFIdentificadorLocalDestinoOperacao;
    }

    public void setOperacaoConsumidorFinal(NFOperacaoConsumidorFinal nFOperacaoConsumidorFinal) {
        this.operacaoConsumidorFinal = nFOperacaoConsumidorFinal;
    }

    public void setIndicadorPresencaComprador(NFIndicadorPresencaComprador nFIndicadorPresencaComprador) {
        this.indicadorPresencaComprador = nFIndicadorPresencaComprador;
    }

    public void setIndIntermed(NFIndicadorIntermediador nFIndicadorIntermediador) {
        this.indIntermed = nFIndicadorIntermediador;
    }

    public DFUnidadeFederativa getUf() {
        return this.uf;
    }

    public String getCodigoRandomico() {
        return this.codigoRandomico;
    }

    public String getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public DFModelo getModelo() {
        return this.modelo;
    }

    public String getSerie() {
        return this.serie;
    }

    public String getNumeroNota() {
        return this.numeroNota;
    }

    public ZonedDateTime getDataHoraEmissao() {
        return this.dataHoraEmissao;
    }

    public ZonedDateTime getDataHoraSaidaOuEntrada() {
        return this.dataHoraSaidaOuEntrada;
    }

    public NFTipo getTipo() {
        return this.tipo;
    }

    public NFIdentificadorLocalDestinoOperacao getIdentificadorLocalDestinoOperacao() {
        return this.identificadorLocalDestinoOperacao;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public String getCMunFGIBS() {
        return this.cMunFGIBS;
    }

    public NFTipoImpressao getTipoImpressao() {
        return this.tipoImpressao;
    }

    public NFTipoEmissao getTipoEmissao() {
        return this.tipoEmissao;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public NFFinalidade getFinalidade() {
        return this.finalidade;
    }

    public void setTpNFDebito(NFDebito nFDebito) {
        this.tpNFDebito = nFDebito;
    }

    public void setTpNFCredito(NFCredito nFCredito) {
        this.tpNFCredito = nFCredito;
    }

    public NFOperacaoConsumidorFinal getOperacaoConsumidorFinal() {
        return this.operacaoConsumidorFinal;
    }

    public NFIndicadorPresencaComprador getIndicadorPresencaComprador() {
        return this.indicadorPresencaComprador;
    }

    public NFIndicadorIntermediador getIndIntermed() {
        return this.indIntermed;
    }

    public NFProcessoEmissor getProgramaEmissor() {
        return this.programaEmissor;
    }

    public String getVersaoEmissor() {
        return this.versaoEmissor;
    }

    public ZonedDateTime getDataHoraContigencia() {
        return this.dataHoraContigencia;
    }

    public String getJustificativaEntradaContingencia() {
        return this.justificativaEntradaContingencia;
    }

    public List<NFInfoReferenciada> getReferenciadas() {
        return this.referenciadas;
    }

    public void setGCompraGov(NFNotaInfoIdentificacaoCompraGov nFNotaInfoIdentificacaoCompraGov) {
        this.gCompraGov = nFNotaInfoIdentificacaoCompraGov;
    }

    public void setGPagAntecipado(NFNotaInfoIdentificacaoPagAntecipado nFNotaInfoIdentificacaoPagAntecipado) {
        this.gPagAntecipado = nFNotaInfoIdentificacaoPagAntecipado;
    }
}

