/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFConfig;
import com.fincatto.documentofiscal.DFLog;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import javax.naming.ldap.LdapName;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DFAssinaturaDigital
implements DFLog {
    private static final String C14N_TRANSFORM_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String[] ELEMENTOS_ASSINAVEIS = new String[]{"infEvento", "infCanc", "infNFe", "infInut", "infMDFe", "infCte"};
    private final DFConfig config;

    public DFAssinaturaDigital(DFConfig dFConfig) {
        this.config = dFConfig;
    }

    public static boolean isValida(InputStream inputStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            throw new IllegalStateException("Nao foi encontrada a assinatura do XML.");
        }
        DOMValidateContext dOMValidateContext = new DOMValidateContext(new DFKeySelector(), nodeList.item(0));
        for (String string : ELEMENTOS_ASSINAVEIS) {
            NodeList nodeList2 = document.getElementsByTagName(string);
            if (nodeList2.getLength() <= 0) continue;
            dOMValidateContext.setIdAttributeNS((Element)nodeList2.item(0), null, "Id");
        }
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
        return xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext).validate(dOMValidateContext);
    }

    public String assinarDocumento(String string) throws Exception {
        return this.assinarDocumento(string, ELEMENTOS_ASSINAVEIS);
    }

    public String assinarDocumento(String string, String ... stringArray) throws Exception {
        try (StringReader stringReader = new StringReader(string);){
            String string2;
            try (StringWriter stringWriter = new StringWriter();){
                this.assinarDocumento(stringReader, stringWriter, stringArray);
                string2 = stringWriter.toString();
            }
            return string2;
        }
    }

    public void assinarDocumento(Reader reader, Writer writer, String ... stringArray) throws Exception {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry();
        String string = ((X509Certificate)privateKeyEntry.getCertificate()).getSubjectX500Principal().getName();
        this.getLogger().debug("DN: {}", (Object)string);
        String string2 = new LdapName(string).getRdns().stream().filter(rdn -> StringUtils.equalsIgnoreCase((CharSequence)rdn.getType(), (CharSequence)"CN")).map(rdn -> String.valueOf(rdn.getValue())).findFirst().orElse("");
        this.getLogger().debug("CN: {}", (Object)string2);
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> arrayList = new ArrayList<Transform>(2);
        arrayList.add(xMLSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        arrayList.add(xMLSignatureFactory.newTransform(C14N_TRANSFORM_METHOD, (TransformParameterSpec)null));
        KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Collections.singletonList((X509Certificate)privateKeyEntry.getCertificate()));
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(reader));
        for (String string3 : stringArray) {
            NodeList nodeList = document.getElementsByTagName(string3);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string4 = element.getAttribute("Id");
                element.setIdAttribute("Id", true);
                Reference reference = xMLSignatureFactory.newReference("#" + string4, xMLSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), arrayList, null, null);
                SignedInfo signedInfo = xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod(C14N_TRANSFORM_METHOD, (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(reference));
                XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(signedInfo, keyInfo);
                xMLSignature.sign(new DOMSignContext(privateKeyEntry.getPrivateKey(), element.getParentNode()));
            }
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(document), new StreamResult(writer));
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(this.config.getCertificadoSenha().toCharArray());
        if (StringUtils.isNotBlank((CharSequence)this.config.getCertificadoAlias())) {
            this.getLogger().debug("Usando alias informado: '{}'", (Object)this.config.getCertificadoAlias());
            return (KeyStore.PrivateKeyEntry)this.config.getCertificadoKeyStore().getEntry(this.config.getCertificadoAlias(), passwordProtection);
        }
        KeyStore keyStore = this.config.getCertificadoKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            this.getLogger().debug("Usando alias descoberto: '{}'", (Object)string);
            return (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, passwordProtection);
        }
        throw new KeyStoreException("N\u00e3o foi poss\u00edvel encontrar a chave privada do certificado!");
    }

    public String assinarString(String string) throws Exception {
        byte[] byArray = string.getBytes();
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initSign(this.getPrivateKeyEntry().getPrivateKey());
        signature.update(byArray, 0, byArray.length);
        return Base64.getEncoder().encodeToString(signature.sign());
    }

    static class DFKeySelector
    extends KeySelector {
        DFKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            for (XMLStructure xMLStructure : keyInfo.getContent()) {
                XMLStructure xMLStructure2 = xMLStructure;
                if (!(xMLStructure2 instanceof X509Data)) continue;
                X509Data x509Data = (X509Data)xMLStructure2;
                for (Object obj : x509Data.getContent()) {
                    if (!(obj instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)obj;
                    if (!this.algEquals(algorithmMethod.getAlgorithm(), x509Certificate.getPublicKey().getAlgorithm())) continue;
                    return x509Certificate::getPublicKey;
                }
            }
            throw new KeySelectorException("Nao foi localizada a chave do certificado.");
        }

        private boolean algEquals(String string, String string2) {
            return string2.equalsIgnoreCase("DSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || string2.equalsIgnoreCase("RSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

