/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFConfig;
import com.fincatto.documentofiscal.utils.DFKeyManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class DFSocketFactory
implements ProtocolSocketFactory {
    public static final int TIMEOUT_PADRAO_EM_MILLIS = 60000;
    public static final int SO_TIMEOUT_PADRAO_EM_MILLIS = 30000;
    private final DFConfig config;
    private final SSLContext sslContext;

    public DFSocketFactory(DFConfig dFConfig) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        this.config = dFConfig;
        this.sslContext = this.createSSLContext(dFConfig);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException {
        Socket socket = this.sslContext.getSocketFactory().createSocket();
        ((SSLSocket)socket).setEnabledProtocols(this.config.getSSLProtocolos());
        socket.bind(new InetSocketAddress(inetAddress, n2));
        int n3 = httpConnectionParams.getConnectionTimeout();
        socket.connect(new InetSocketAddress(string, n), n3);
        return socket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(string, n);
    }

    private SSLContext createSSLContext(DFConfig dFConfig) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        KeyManager[] keyManagerArray = this.createKeyManagers(dFConfig);
        TrustManager[] trustManagerArray = this.createTrustManagers(dFConfig);
        SSLContext sSLContext = SSLContext.getInstance(dFConfig.getSSLProtocolos()[0]);
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        return sSLContext;
    }

    private KeyManager[] createKeyManagers(DFConfig dFConfig) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        return new KeyManager[]{new DFKeyManager(dFConfig)};
    }

    private TrustManager[] createTrustManagers(DFConfig dFConfig) throws KeyStoreException, NoSuchAlgorithmException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(dFConfig.getCadeiaCertificadosKeyStore());
        return trustManagerFactory.getTrustManagers();
    }
}

