/*
 * Decompiled with CFR 0.152.
 */
package com.zenvia.api.sdk.client;

import com.zenvia.api.sdk.client.Channel;
import com.zenvia.api.sdk.client.ChannelType;
import com.zenvia.api.sdk.client.exceptions.HttpConnectionFailException;
import com.zenvia.api.sdk.client.exceptions.HttpConnectionTimeoutException;
import com.zenvia.api.sdk.client.exceptions.HttpIOException;
import com.zenvia.api.sdk.client.exceptions.HttpSocketTimeoutException;
import com.zenvia.api.sdk.client.exceptions.UnsuccessfulRequestException;
import com.zenvia.api.sdk.client.exceptions.UnsupportedChannelException;
import com.zenvia.api.sdk.client.subscriptions.PartialSubscription;
import com.zenvia.api.sdk.client.subscriptions.Subscription;
import com.zenvia.api.sdk.messages.Message;
import com.zenvia.api.sdk.messages.MessageRequest;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public abstract class AbstractClient
implements Closeable {
    public static final String DEFAULT_URL = "https://api.zenvia.com";
    public static final int DEFAULT_MAX_CONNECTIONS = 100;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 25000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    public static final int DEFAULT_CONNECTION_POOL_TIMEOUT = 0;
    public static final int DEFAULT_MAX_CONNECTION_RETRIES = 4;
    public static final int DEFAULT_INACTIVITY_TIME_BEFORE_STALE_CHECK = 5000;
    protected final String apiToken;
    protected final String apiUrl;
    protected final String subscriptionApiUrl;
    protected final HttpClient httpClient;
    private final ConnectionConfig connectionConfig;
    private final RequestConfig requestConfig;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final DefaultHttpRequestRetryHandler requestRetryHandler;
    private final PoolingHttpClientConnectionManager connectionPool;

    public AbstractClient(String apiToken) {
        this(apiToken, (String)null);
    }

    public AbstractClient(String apiToken, Integer maxConnections) {
        this(apiToken, maxConnections, null, null, null);
    }

    public AbstractClient(String apiToken, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries) {
        this(apiToken, (Integer)null, connectionTimeout, socketTimeout, maxConnectionRetries);
    }

    public AbstractClient(String apiToken, Integer maxConnections, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries) {
        this(apiToken, maxConnections, connectionTimeout, socketTimeout, maxConnectionRetries, null, null);
    }

    public AbstractClient(String apiToken, Integer maxConnections, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries, Integer connectionPoolTimeout, Integer inactivityTimeBeforeStaleCheck) {
        this(apiToken, null, maxConnections, connectionTimeout, socketTimeout, maxConnectionRetries, connectionPoolTimeout, inactivityTimeBeforeStaleCheck);
    }

    public AbstractClient(String apiToken, String apiUrl) {
        this(apiToken, apiUrl, null, null, null);
    }

    public AbstractClient(String apiToken, String apiUrl, Integer maxConnections) {
        this(apiToken, apiUrl, maxConnections, null, null, null);
    }

    public AbstractClient(String apiToken, String apiUrl, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries) {
        this(apiToken, apiUrl, null, connectionTimeout, socketTimeout, maxConnectionRetries);
    }

    public AbstractClient(String apiToken, String apiUrl, Integer maxConnections, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries) {
        this(apiToken, apiUrl, maxConnections, connectionTimeout, socketTimeout, maxConnectionRetries, null, null);
    }

    public AbstractClient(String apiToken, String apiUrl, Integer maxConnections, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries, Integer connectionPoolTimeout, Integer inactivityTimeBeforeStaleCheck) {
        this(apiToken, apiUrl, AbstractClient.buildConnectionPool(AbstractClient.valueOrDefault(maxConnections, 100), AbstractClient.valueOrDefault(inactivityTimeBeforeStaleCheck, 5000)), AbstractClient.buildRequestConfig(AbstractClient.valueOrDefault(connectionTimeout, 25000), AbstractClient.valueOrDefault(socketTimeout, 60000), AbstractClient.valueOrDefault(connectionPoolTimeout, 0)), new DefaultHttpRequestRetryHandler(AbstractClient.valueOrDefault(maxConnectionRetries, 4).intValue(), false), ConnectionConfig.custom().setCharset(StandardCharsets.UTF_8).build(), (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE);
    }

    private AbstractClient(String apiToken, String apiUrl, PoolingHttpClientConnectionManager connectionPool, RequestConfig defaultRequestConfig, DefaultHttpRequestRetryHandler requestRetryHandler, ConnectionConfig defaultConnectionConfig, ConnectionReuseStrategy connectionReuseStrategy) {
        this.apiToken = apiToken;
        this.apiUrl = AbstractClient.valueOrDefault(apiUrl, DEFAULT_URL);
        this.subscriptionApiUrl = this.apiUrl + "/v1/subscriptions";
        this.connectionPool = connectionPool;
        this.connectionConfig = defaultConnectionConfig;
        this.requestConfig = defaultRequestConfig;
        this.connectionReuseStrategy = connectionReuseStrategy;
        this.requestRetryHandler = requestRetryHandler;
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.connectionPool).setDefaultConnectionConfig(this.connectionConfig).setDefaultRequestConfig(this.requestConfig).setConnectionReuseStrategy(this.connectionReuseStrategy).setRetryHandler((HttpRequestRetryHandler)this.requestRetryHandler).disableCookieManagement().build();
    }

    public Channel getChannel(String channelType) throws UnsupportedChannelException {
        return this.getChannel(ChannelType.parse(channelType));
    }

    public Channel getChannel(ChannelType channelType) throws UnsupportedChannelException {
        return new Channel(channelType, this);
    }

    public List<Subscription> listSubscriptions() throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return Arrays.asList((Object[])this.list(this.subscriptionApiUrl, Subscription[].class));
    }

    public <SUBSCRIPTION extends Subscription> SUBSCRIPTION createSubscription(SUBSCRIPTION subscription) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return (SUBSCRIPTION)this.post(this.subscriptionApiUrl, subscription, Subscription.class);
    }

    public <SUBSCRIPTION extends Subscription> SUBSCRIPTION getSubscription(String id) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return (SUBSCRIPTION)this.get(this.subscriptionApiUrl, id, Subscription.class);
    }

    public <SUBSCRIPTION extends Subscription> SUBSCRIPTION updateSubscription(SUBSCRIPTION subscription) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return this.updateSubscription(subscription.id, new PartialSubscription(subscription));
    }

    public <SUBSCRIPTION extends Subscription> SUBSCRIPTION updateSubscription(String id, PartialSubscription partialSubscription) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return (SUBSCRIPTION)this.patch(this.subscriptionApiUrl, id, partialSubscription, Subscription.class);
    }

    public void deleteSubscription(String id) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        this.delete(this.subscriptionApiUrl, id);
    }

    protected Message sendMessage(Channel channel, MessageRequest messageRequest) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return this.post(channel.url, messageRequest, Message.class);
    }

    protected abstract <RESPONSE> RESPONSE list(String var1, Class<RESPONSE> var2) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException;

    protected abstract <RESPONSE> RESPONSE get(String var1, String var2, Class<RESPONSE> var3) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException;

    protected abstract <REQUEST, RESPONSE> RESPONSE post(String var1, REQUEST var2, Class<RESPONSE> var3) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException;

    protected abstract <REQUEST, RESPONSE> RESPONSE patch(String var1, String var2, REQUEST var3, Class<RESPONSE> var4) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException;

    protected abstract void delete(String var1, String var2) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException;

    public String getApiUrl() {
        return this.apiUrl;
    }

    @Override
    public void close() {
        if (this.connectionPool != null) {
            this.connectionPool.shutdown();
        }
    }

    private static final PoolingHttpClientConnectionManager buildConnectionPool(int maxConnections, int validateAfterInactivity) {
        PoolingHttpClientConnectionManager connectionPool = new PoolingHttpClientConnectionManager();
        connectionPool.setMaxTotal(maxConnections);
        connectionPool.setDefaultMaxPerRoute(maxConnections);
        connectionPool.setValidateAfterInactivity(validateAfterInactivity);
        return connectionPool;
    }

    private static final RequestConfig buildRequestConfig(int connectionTimeout, int socketTimeout, int poolTimeout) {
        return RequestConfig.custom().setConnectionRequestTimeout(poolTimeout).setConnectTimeout(connectionTimeout).setSocketTimeout(socketTimeout).build();
    }

    private static final <TYPE> TYPE valueOrDefault(TYPE value, TYPE defaultValue) {
        return value == null ? defaultValue : value;
    }

    public int getMaxConnections() {
        return this.connectionPool.getMaxTotal();
    }

    public int getInactivityTimeBeforeStaleCheck() {
        return this.connectionPool.getValidateAfterInactivity();
    }

    public int getConnectionPoolTimeout() {
        return this.requestConfig.getConnectionRequestTimeout();
    }

    public int getConnectionTimeout() {
        return this.requestConfig.getConnectTimeout();
    }

    public int getSocketTimeout() {
        return this.requestConfig.getSocketTimeout();
    }

    public int getMaxConnectionRetries() {
        return this.requestRetryHandler.getRetryCount();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{\n  apiUrl = [" + this.getApiUrl() + "]\n  maxConnections = [" + this.getMaxConnections() + "]\n  connectionTimeout = [" + this.getConnectionTimeout() + "]\n  socketTimeout = [" + this.getSocketTimeout() + "]\n  connectionPoolTimeout = [" + this.getConnectionPoolTimeout() + "]\n  maxConnectionRetries = [" + this.getMaxConnectionRetries() + "]\n  inactivityTimeBeforeStaleCheck = [" + this.getInactivityTimeBeforeStaleCheck() + "]\n}";
    }
}

