/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components;

import com.touchcomp.touchnfce.properties.PropertiesLoader;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;

public class TouchCheckBox
extends CheckBox {
    public TouchCheckBox() {
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (newPropertyValue.booleanValue()) {
                    TouchCheckBox.this.onFocusGained();
                }
                if (oldPropertyValue.booleanValue()) {
                    TouchCheckBox.this.onFocusLost();
                }
            }
        });
    }

    public void setSelectedRadio(boolean selected) {
        this.setSelected(selected);
        if (this.isSelected()) {
            this.onFocusGained();
        } else {
            this.onFocusLost();
        }
    }

    private void onFocusGained() {
        this.setStyle("-fx-text-fill: #FFFF00;-fx-font-size: 2em;");
    }

    private void onFocusLost() {
        PropertiesLoader props = PropertiesLoader.get();
        this.setStyle("-fx-text-fill: " + props.getCorTexto() + ";-fx-font-size: 2em;");
    }
}

