/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components;

import com.touchcomp.touchnfce.properties.PropertiesLoader;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;

public class TouchComboBox<T>
extends ComboBox {
    private Label label;
    private final String STYLE_COLOR_FOCUS = "-fx-control-inner-background: #B0E0E6";
    private final String STYLE_COLOR_NO_FOCUS = "-fx-control-inner-background: #FFFFFF";

    public TouchComboBox() {
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (newPropertyValue.booleanValue()) {
                    TouchComboBox.this.onFocusGained();
                }
                if (oldPropertyValue.booleanValue()) {
                    TouchComboBox.this.onFocusLost();
                }
            }
        });
    }

    private void onFocusGained() {
        this.setStyle("-fx-control-inner-background: #B0E0E6");
        if (this.label != null) {
            this.label.setStyle("-fx-text-fill: #FFFF00;-fx-font-size: 22pt;");
        }
    }

    private void onFocusLost() {
        this.setStyle("-fx-control-inner-background: #FFFFFF");
        if (this.label != null) {
            PropertiesLoader props = PropertiesLoader.get();
            this.label.setStyle("-fx-text-fill: " + props.getCorTexto() + ";-fx-font-size: 22pt;");
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void setObjects(List<T> items) {
        ObservableList itens = FXCollections.observableArrayList(items);
        this.setItems(itens);
    }

    public T getSelectedItem() {
        return (T)this.getSelectionModel().getSelectedItem();
    }

    public void select(T item) {
        this.getSelectionModel().select(item);
    }
}

