/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components;

import com.touchcomp.touchnfce.components.TouchTextField;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class TouchDoubleField
extends TouchTextField {
    private NumberFormat format;
    private int numberDecimalCases = 2;
    UnaryOperator<TextFormatter.Change> filter = c -> {
        String text = c.getControlNewText();
        return c;
    };
    StringConverter<Double> converter = new StringConverter<Double>(){

        public Double fromString(String s) {
            try {
                if (!s.isEmpty()) {
                    return TouchDoubleField.this.format.parse(s).doubleValue();
                }
                return 0.0;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return 0.0;
            }
        }

        public String toString(Double d) {
            return TouchDoubleField.this.getDecimalFormat().format(d);
        }
    };

    public TouchDoubleField() {
        TextFormatter textFormatter = new TextFormatter(this.converter, (Object)0.0, this.filter);
        this.setTextFormatter(textFormatter);
    }

    private NumberFormat getDecimalFormat() {
        DefaultFormatterFactory f = new DefaultFormatterFactory();
        if (this.format == null) {
            this.format = NumberFormat.getNumberInstance();
            this.format.setMaximumFractionDigits(this.numberDecimalCases);
            this.format.setMinimumFractionDigits(this.numberDecimalCases);
            this.format.setMaximumIntegerDigits(9);
            this.format.setMinimumIntegerDigits(1);
            NumberFormatter formatter = new NumberFormatter(this.format);
            formatter.setValueClass(Double.class);
            f.setDefaultFormatter(formatter);
            f.setDisplayFormatter(formatter);
            f.setEditFormatter(formatter);
        }
        return this.format;
    }

    public Double getDouble() {
        String text = this.getText();
        if (text.isEmpty() || text == null) {
            return 0.0;
        }
        try {
            return this.getDecimalFormat().parse(text).doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public void setDouble(Double value) {
        value = value == null ? 0.0 : value;
        this.setText(this.getDecimalFormat().format(value));
    }

    public void clear() {
        super.clear();
        this.setDouble(0.0);
    }

    public int getNumberDecimalCases() {
        return this.numberDecimalCases;
    }

    public void setNumberDecimalCases(int numberDecimalCases) {
        this.numberDecimalCases = numberDecimalCases;
        this.getDecimalFormat().setMaximumFractionDigits(this.numberDecimalCases);
        this.getDecimalFormat().setMinimumFractionDigits(this.numberDecimalCases);
    }
}

