/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components.autocomplete;

import com.touchcomp.touchnfce.components.TouchTextField;
import java.util.Collection;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.PopupWindow;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;

public abstract class AutoCompleteLazyLoad<T>
extends TouchTextField {
    private SortedSet<T> entries;
    private PopupControl popup;
    private String currentTextValue;
    private int page = 1;
    private int oldLength = 0;
    private int oldPage;
    private ObjectProperty<T> selectedItemProperty;
    private ObservableList<T> listViewItems;
    private ListView<T> listView;
    private ItemSelLazyFilter itemSelListener;
    private ItemLazyFilter lazyLoading;
    private LinkedList<T> searchResult = new LinkedList();
    private boolean loading = false;

    public AutoCompleteLazyLoad(int width) {
        this(new TreeSet(), width);
    }

    public AutoCompleteLazyLoad() {
        this(new TreeSet(), 500.0);
    }

    public AutoCompleteLazyLoad(SortedSet items, double prefWidth) {
        this.initPopup(prefWidth);
        this.initItems(items);
        this.initListeners();
        this.setOnMouseClicked(e -> this.showPopupAllItems());
    }

    private void initListeners() {
        this.textProperty().addListener((observableValue, oldVal, newVal) -> {
            if (this.oldLength != newVal.length()) {
                this.page = 1;
            }
            this.oldLength = newVal.length();
            this.updatePopup();
        });
        this.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                this.popup.hide();
                this.currentTextValue = null;
            }
        });
    }

    private void initPopup(double prefWidth) {
        this.entries = new TreeSet<T>();
        this.popup = new PopupControl();
        this.popup.setPrefWidth(Double.NEGATIVE_INFINITY);
        this.popup.setAutoFix(true);
        this.popup.setAutoHide(true);
        this.setupListView(prefWidth);
        ((Pane)this.popup.getScene().getRoot()).getChildren().setAll((Object[])new Node[]{this.listView});
        this.popup.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
    }

    private void setupListView(double prefWidth) {
        this.listView = new ListView();
        if (prefWidth > 0.0) {
            this.listView.setMinWidth(prefWidth);
        }
        this.listView.setPrefHeight(230.0);
        this.listView.setStyle("-fx-background-color: white; -fx-background-insets: 0, 1, 2; -fx-background-radius: 5, 4, 3;");
        this.setupEventsListView();
    }

    private void setupEventsListView() {
        this.listView.getSelectionModel().selectedItemProperty().addListener((observe, oldVal, newVal) -> {
            Object selectedItem = this.listView.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                this.selectedItemProperty().setValue(selectedItem);
            }
        });
        this.listView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Object selectedItem = AutoCompleteLazyLoad.this.listView.getSelectionModel().getSelectedItem();
                if (selectedItem != null) {
                    if (selectedItem.equals(AutoCompleteLazyLoad.this.getObjetoPesquisaMais())) {
                        AutoCompleteLazyLoad.this.carregaMaisRegistros();
                    } else {
                        AutoCompleteLazyLoad.this.selectItem();
                    }
                }
            }
        });
        this.listView.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    Object selectedItem = AutoCompleteLazyLoad.this.listView.getSelectionModel().getSelectedItem();
                    if (selectedItem != null) {
                        if (selectedItem.equals(AutoCompleteLazyLoad.this.getObjetoPesquisaMais())) {
                            AutoCompleteLazyLoad.this.carregaMaisRegistros();
                        } else {
                            AutoCompleteLazyLoad.this.selectItem();
                        }
                    }
                } else if (event.getCode() == KeyCode.DOWN && AutoCompleteLazyLoad.this.listView.getSelectionModel().getSelectedIndex() == AutoCompleteLazyLoad.this.listView.getItems().size() - 3) {
                    AutoCompleteLazyLoad.this.carregaMaisRegistros();
                }
            }
        });
        this.listView.setCellFactory(new Callback<ListView<T>, ListCell<T>>(this){

            public ListCell<T> call(ListView<T> p) {
                return new ListCell<T>(this){

                    protected void updateItem(T t, boolean empty) {
                        super.updateItem(t, empty);
                        if (!empty) {
                            Label lbl = new Label();
                            lbl.setText(t.toString());
                            lbl.setStyle("-fx-font-size: 200.0%");
                            lbl.setMaxWidth(Double.MAX_VALUE);
                            this.setGraphic((Node)lbl);
                        } else {
                            this.setGraphic(null);
                        }
                    }

                    public void startEdit() {
                        super.startEdit();
                    }
                };
            }
        });
    }

    private void carregaMaisRegistros() {
        ++this.page;
        if (this.lazyLoading != null && !this.loading) {
            this.loading = true;
            SortedSet sort = this.lazyLoading.loadingMoreItems(this.currentTextValue, this.page, this.qtdObjetosPorCarregamento());
            if (sort != null && !sort.isEmpty()) {
                this.searchResult.addAll(sort);
                if (this.getObjetoPesquisaMais() != null) {
                    if (this.searchResult.contains(this.getObjetoPesquisaMais())) {
                        this.searchResult.remove(this.getObjetoPesquisaMais());
                    }
                    this.searchResult.add(this.getObjetoPesquisaMais());
                }
            } else if (this.searchResult.contains(this.getObjetoPesquisaMais())) {
                this.searchResult.remove(this.getObjetoPesquisaMais());
                this.listViewItems.setAll(this.searchResult);
            }
            int oldSize = this.listView.getItems().size();
            this.listViewItems.setAll(this.searchResult);
            if (this.page > 1) {
                this.listView.getSelectionModel().select(oldSize - 3);
                this.listView.scrollTo(oldSize - 3);
            }
            this.loading = false;
        }
    }

    private void selectItem() {
        if (this.itemSelListener != null) {
            this.popup.hide();
            this.itemSelListener.onItemListener(this.selectedItemProperty.get());
        }
    }

    public void initItems(SortedSet<T> items) {
        if (items.size() > 0) {
            this.initializeSelectedItemProperty(items.first());
        } else {
            this.initializeSelectedItemProperty(null);
        }
        this.initializeListViewItems(items);
        this.entries.clear();
        this.entries.addAll(items);
        this.popup.hide();
    }

    private void initializeListViewItems(Collection<T> items) {
        if (this.listViewItems == null) {
            this.listViewItems = FXCollections.observableArrayList(items);
        }
        this.listView.setItems(this.listViewItems);
    }

    private void initializeSelectedItemProperty(T t) {
        if (this.selectedItemProperty == null) {
            this.selectedItemProperty = new SimpleObjectProperty();
        }
        this.selectedItemProperty.set(t);
    }

    private void updatePopup() {
        Object selectedItem = this.listView.getSelectionModel().getSelectedItem();
        if (selectedItem != null && this.getText().equals(selectedItem.toString())) {
            return;
        }
        if (StringUtils.equals((CharSequence)this.currentTextValue, (CharSequence)this.getText())) {
            return;
        }
        this.currentTextValue = this.getText();
        if (this.lazyLoading != null && !this.loading) {
            this.loading = true;
            SortedSet sort = this.lazyLoading.loadingMoreItems(this.currentTextValue, this.page, this.qtdObjetosPorCarregamento());
            if (sort != null) {
                this.searchResult.clear();
                this.searchResult.addAll(sort);
            }
            this.loading = false;
        } else {
            this.searchResult.addAll(this.entries.stream().filter(x -> StringUtils.containsIgnoreCase((CharSequence)x.toString(), (CharSequence)this.getText())).collect(Collectors.toList()));
        }
        if (this.searchResult != null && this.searchResult.size() > 0) {
            if (this.getObjetoPesquisaMais() != null && !this.searchResult.contains(this.getObjetoPesquisaMais())) {
                Integer count = this.sizeData(this.currentTextValue);
                if (this.getObjetoPesquisaMais() != null) {
                    this.searchResult.add(this.getObjetoPesquisaMais());
                }
            }
            this.listViewItems.setAll(this.searchResult);
            if (!this.popup.isShowing()) {
                this.reloadPopup();
            }
        } else {
            this.popup.hide();
            this.currentTextValue = null;
        }
    }

    private void reloadPopup() {
        Point2D p = this.localToScene(0.0, 0.0);
        if (this.getScene() != null) {
            double x = p.getX() + this.getScene().getX() + this.getScene().getWindow().getX();
            double y = p.getY() + this.getScene().getY() + this.getScene().getWindow().getY() + this.getHeight();
            this.listView.setPrefWidth(this.getWidth());
            this.popup.show((Node)this, x, y);
        }
    }

    public void showPopupAllItems() {
        if (!this.popup.isShowing() && !this.entries.isEmpty()) {
            this.listViewItems.setAll(this.entries);
            this.reloadPopup();
        } else {
            this.popup.hide();
        }
    }

    public SortedSet<T> getEntries() {
        return this.entries;
    }

    public ListView getListView() {
        return this.listView;
    }

    public PopupControl getPopup() {
        return this.popup;
    }

    public boolean popupIsShowing() {
        return this.popup.isShowing();
    }

    public void clear() {
        this.entries.clear();
        this.listView.refresh();
        this.setText("");
    }

    public void requestFocus() {
        super.requestFocus();
        this.showPopupAllItems();
    }

    public ObjectProperty<T> selectedItemProperty() {
        return this.selectedItemProperty;
    }

    public ItemSelLazyFilter getItemSelListener() {
        return this.itemSelListener;
    }

    public void setItemSelListener(ItemSelLazyFilter itemSelListener) {
        this.itemSelListener = itemSelListener;
    }

    public ItemLazyFilter getLazyLoading() {
        return this.lazyLoading;
    }

    public void setLazyLoading(ItemLazyFilter lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    public abstract T getObjetoPesquisaMais();

    public abstract Integer qtdObjetosPorCarregamento();

    public abstract Integer sizeData(String var1);

    public static interface ItemLazyFilter<T> {
        public SortedSet loadingMoreItems(String var1, int var2, int var3);
    }

    public static interface ItemSelLazyFilter<T> {
        public void onItemListener(T var1);
    }
}

