/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components.table.impl;

import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.table.PaginationTable;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.helpers.preco.HelperPrecos;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.utils.MaskField;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class PaginationTableItens
extends PaginationTable<TempPesquisaProduto> {
    private UnidadeFatCliente unidadeFatCliente;

    @Override
    public TableView<TempPesquisaProduto> getInternalTable() {
        TableView table = new TableView();
        final TableColumn columnCodigoAux = new TableColumn("Cod. Aux");
        final TableColumn columnGrade = new TableColumn("Grade");
        final TableColumn columnNomeProd = new TableColumn("Produto");
        TableColumn columnUM = new TableColumn("UM");
        TableColumn columnVlrUnitario = new TableColumn("Vlr. Unit\u00e1rio");
        final TableColumn columnCodigoBarras = new TableColumn("Cod. Barras");
        TableColumn columnSaldo = new TableColumn("Saldo");
        TableColumn columnPercDesc = new TableColumn("Perc. Desconto");
        TableColumn columnVlrDesc = new TableColumn("Vlr. Desconto");
        columnGrade.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TempPesquisaProduto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TempPesquisaProduto, String> param) {
                return new SimpleObjectProperty((Object)((TempPesquisaProduto)param.getValue()).getGrade());
            }
        });
        columnGrade.setCellFactory((Callback)new Callback<TableColumn<TempPesquisaProduto, String>, TableCell<TempPesquisaProduto, String>>(){

            public TableCell<TempPesquisaProduto, String> call(TableColumn<TempPesquisaProduto, String> param) {
                TableCell<TempPesquisaProduto, String> cell = new TableCell<TempPesquisaProduto, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item);
                            this.text.setWrappingWidth(columnGrade.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        columnCodigoAux.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TempPesquisaProduto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TempPesquisaProduto, String> param) {
                return new SimpleObjectProperty((Object)((TempPesquisaProduto)param.getValue()).getCodAuxiliar());
            }
        });
        columnCodigoAux.setCellFactory((Callback)new Callback<TableColumn<TempPesquisaProduto, String>, TableCell<TempPesquisaProduto, String>>(){

            public TableCell<TempPesquisaProduto, String> call(TableColumn<TempPesquisaProduto, String> param) {
                TableCell<TempPesquisaProduto, String> cell = new TableCell<TempPesquisaProduto, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item) : new Text("");
                        this.text.setWrappingWidth(columnCodigoAux.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        columnCodigoBarras.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TempPesquisaProduto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TempPesquisaProduto, String> param) {
                return new SimpleObjectProperty((Object)((TempPesquisaProduto)param.getValue()).getCodigoBarras());
            }
        });
        columnCodigoBarras.setCellFactory((Callback)new Callback<TableColumn<TempPesquisaProduto, String>, TableCell<TempPesquisaProduto, String>>(){

            public TableCell<TempPesquisaProduto, String> call(TableColumn<TempPesquisaProduto, String> param) {
                TableCell<TempPesquisaProduto, String> cell = new TableCell<TempPesquisaProduto, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item) : new Text("");
                        this.text.setWrappingWidth(columnCodigoBarras.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        columnNomeProd.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TempPesquisaProduto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TempPesquisaProduto, String> param) {
                return new SimpleObjectProperty((Object)((TempPesquisaProduto)param.getValue()).getNomeProduto());
            }
        });
        columnNomeProd.setCellFactory((Callback)new Callback<TableColumn<TempPesquisaProduto, String>, TableCell<TempPesquisaProduto, String>>(){

            public TableCell<TempPesquisaProduto, String> call(TableColumn<TempPesquisaProduto, String> param) {
                TableCell<TempPesquisaProduto, String> cell = new TableCell<TempPesquisaProduto, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item);
                            this.text.setWrappingWidth(columnNomeProd.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        columnVlrUnitario.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TempPesquisaProduto, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TempPesquisaProduto, String> param) {
                String vlr = PaginationTableItens.this.formatarValorConfOpcoes(((TempPesquisaProduto)param.getValue()).getValorUnitario());
                return new SimpleObjectProperty((Object)vlr);
            }
        });
        columnNomeProd.setCellFactory((Callback)new Callback<TableColumn<TempPesquisaProduto, String>, TableCell<TempPesquisaProduto, String>>(){

            public TableCell<TempPesquisaProduto, String> call(TableColumn<TempPesquisaProduto, String> param) {
                TableCell<TempPesquisaProduto, String> cell = new TableCell<TempPesquisaProduto, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item);
                            this.text.setWrappingWidth(columnNomeProd.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        columnUM.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TempPesquisaProduto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TempPesquisaProduto, String> param) {
                return new SimpleObjectProperty((Object)((TempPesquisaProduto)param.getValue()).getUnidadeMedida());
            }
        });
        columnSaldo.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TempPesquisaProduto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TempPesquisaProduto, String> param) {
                return new SimpleObjectProperty((Object)ToolFormatter.formataNumero((Number)((TempPesquisaProduto)param.getValue()).getSaldoQuantitativo(), (int)3));
            }
        });
        columnPercDesc.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TempPesquisaProduto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TempPesquisaProduto, String> param) {
                if (((TempPesquisaProduto)param.getValue()).getPercDescontoTrib() != null) {
                    return new SimpleObjectProperty((Object)MaskField.monetaryField(((TempPesquisaProduto)param.getValue()).getPercDescontoTrib()));
                }
                return new SimpleObjectProperty((Object)"");
            }
        });
        columnVlrDesc.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TempPesquisaProduto, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TempPesquisaProduto, String> param) {
                Double perc = ((TempPesquisaProduto)param.getValue()).getPercDescontoTrib();
                Double vlr = ((TempPesquisaProduto)param.getValue()).getValorUnitario();
                if (perc != null && perc > 0.0) {
                    vlr = vlr - vlr * perc / 100.0;
                }
                return new SimpleObjectProperty((Object)PaginationTableItens.this.formatarValorConfOpcoes(vlr));
            }
        });
        table.getColumns().addAll((Object[])new TableColumn[]{columnCodigoAux, columnGrade, columnNomeProd, columnUM, columnVlrUnitario, columnCodigoBarras, columnSaldo, columnPercDesc, columnVlrDesc});
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        columnNomeProd.setMinWidth(300.0);
        columnGrade.setMinWidth(200.0);
        columnCodigoAux.setMinWidth(70.0);
        columnCodigoBarras.setMinWidth(100.0);
        columnUM.setMinWidth(60.0);
        columnVlrUnitario.setMinWidth(80.0);
        columnVlrUnitario.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        columnSaldo.setMinWidth(70.0);
        columnSaldo.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        columnVlrDesc.setMinWidth(80.0);
        columnVlrDesc.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        columnPercDesc.setMinWidth(70.0);
        columnPercDesc.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        return table;
    }

    private String formatarValorConfOpcoes(Double valor) {
        String vlr = ToolMethods.isWithData((Number)StaticObjects.getOpcoes().getNrCasasDecValor()) ? ToolFormatter.formataNumero((Number)valor, (int)StaticObjects.getOpcoes().getNrCasasDecValor().shortValue()) : ToolFormatter.formataNumero((Number)valor, (int)2);
        return vlr;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @Override
    public List<TempPesquisaProduto> loadingMoreItems(Integer page, String aux) {
        try {
            HelperPrecos helper = Main.getBean(HelperPrecos.class);
            List<TempPesquisaProduto> prod = null;
            Integer nrRegistros = StaticObjects.getOpcoes().getNrRegistrosProd();
            if (nrRegistros == null || nrRegistros <= 0) {
                nrRegistros = 20;
            }
            prod = helper.getProdutosConfOpcoes(aux, StaticObjects.getEmpresa(), this.unidadeFatCliente, StaticObjects.getOpcoes(), null, StaticObjects.getUsuario(), StaticObjects.getGrupo(), null, null, null, nrRegistros, page);
            return prod;
        }
        catch (ExceptionTabelaPrecosDinamica exceptionTabelaPrecosDinamica) {
            Alerts.showAlertError("Ocorreu um erro ao carregar os registros: \n" + exceptionTabelaPrecosDinamica.getMessage());
            exceptionTabelaPrecosDinamica.printStackTrace();
        }
        catch (ExceptionAvaliadorExpressoes exceptionAvaliadorExpressoes) {
            Alerts.showAlertError("Ocorreu um erro ao carregar os registros: \n" + exceptionAvaliadorExpressoes.getMessage());
            exceptionAvaliadorExpressoes.printStackTrace();
        }
        return null;
    }

    @Override
    public Boolean enableButtonAnterior() {
        return false;
    }

    @Override
    public String getPathView() {
        return "/view/components/PaginationTableItens.fxml";
    }
}

