/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.configuration;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.properties.PropertiesBD;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@PropertySource(value={"classpath:application.yml"})
@EnableTransactionManagement
public class PersistenceConfig {
    @Autowired
    private Environment environment;
    @Value(value="${spring.datasource.url}")
    private String databaseURL;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${spring.jpa.hibernate.ddl-auto}")
    private String ddlAutoHibernate;
    @Value(value="${spring.jpa.properties.hibernate.show_sql}")
    private String showSql;
    @Value(value="${spring.jpa.properties.hibernate.enable_lazy_load_no_trans}")
    private String enableLazyLoadCollections;

    @Bean
    public DataSource dataSource() {
        String urlLocal = this.databaseURL;
        String userNameLocal = this.username;
        String passwordLocal = this.password;
        String driverClassNameLocal = this.driverClassName;
        PropertiesBD confProperties = PropertiesBD.get();
        String urlDatabaseInternal = confProperties.getURLDatabase();
        if (ToolMethods.isStrWithData((String)urlDatabaseInternal)) {
            urlLocal = urlDatabaseInternal;
        }
        System.out.println("\n\n\n");
        System.out.println("Configurando bancos de dados");
        System.out.println("\n\n\n");
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(driverClassNameLocal);
        ds.setUsername(userNameLocal);
        ds.setPassword(passwordLocal);
        ds.setUrl(urlLocal);
        ds.setMinIdle(2);
        return ds;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(dataSource);
        em.setPackagesToScan(new String[]{"com.touchcomp.touchnfce.model"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        Properties properties = new Properties();
        properties.setProperty("hibernate.dialect", "org.hibernate.dialect.FirebirdDialect");
        properties.setProperty("hibernate.show_sql", "false");
        properties.setProperty("hibernate.use_sql_comments", "false");
        properties.setProperty("hibernate.format_sql", "false");
        properties.setProperty("hibernate.enable_lazy_load_no_trans", "true");
        properties.setProperty("hibernate.hbm2ddl.auto", "update");
        em.setJpaProperties(properties);
        return em;
    }
}

