/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller;

import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.controller.dialogs.DialogComboBox;
import com.touchcomp.touchnfce.controller.dialogs.DialogDateTimeTextField;
import com.touchcomp.touchnfce.controller.dialogs.DialogFieldMaxLenght;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class AlertsCode {
    public static void showAlertInfo(String baseCode, Object ... data) {
        AlertsCode.showAlertError(Main.get().getPrimaryStage(), baseCode, data);
    }

    public static void showAlertInfo(Stage stage, String baseCode, Object ... data) {
        String baseMessage = MessagesBaseMentor.getDefMsg((String)baseCode, (Object[])data);
        String title = MessagesBaseMentor.getTextDetailsMsg((String)"atencao", (Object[])new Object[0]);
        AlertsCode.showAlert(Alert.AlertType.INFORMATION, stage, title, true, baseMessage);
    }

    public static void showAlertWarning(String baseCode, Object ... data) {
        AlertsCode.showAlertError(Main.get().getPrimaryStage(), baseCode, data);
    }

    public static void showAlertWarning(Stage stage, String baseCode, Object ... data) {
        String baseMessage = MessagesBaseMentor.getDefMsg((String)baseCode, (Object[])data);
        String title = MessagesBaseMentor.getTextDetailsMsg((String)"atencao", (Object[])new Object[0]);
        AlertsCode.showAlert(Alert.AlertType.WARNING, stage, title, true, baseMessage);
    }

    public static void showAlertError(String baseCode, Object ... data) {
        AlertsCode.showAlertError(Main.get().getPrimaryStage(), baseCode, data);
    }

    public static void showAlertError(Stage stage, String baseCode, Object ... data) {
        String baseMessage = MessagesBaseMentor.getDefMsg((String)baseCode, (Object[])data);
        String title = MessagesBaseMentor.getTextDetailsMsg((String)"atencao", (Object[])new Object[0]);
        AlertsCode.showAlert(Alert.AlertType.ERROR, stage, title, true, baseMessage);
    }

    private static void showAlert(Alert.AlertType type, Stage stage, String title, boolean showAndWait, String baseMessage) {
        Alert alert = new Alert(type);
        DialogPane dialogPane = alert.getDialogPane();
        if (stage != null) {
            alert.initOwner((Window)stage);
        } else {
            alert.initOwner((Window)Main.get().getPrimaryStage());
        }
        alert.setTitle(title);
        alert.setContentText(baseMessage);
        dialogPane.setStyle("-fx-background-color: white;");
        if (showAndWait) {
            alert.showAndWait();
        }
        stage.requestFocus();
    }

    public static Optional<ButtonType> showQuestion(String title, String header, String body, Stage stage) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        EventHandler fireOnEnter = event -> {
            if (KeyCode.ENTER.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                ((Button)event.getTarget()).fire();
                alert.close();
            } else if (KeyCode.ESCAPE.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                alert.close();
            }
        };
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, fireOnEnter));
        if (stage != null) {
            alert.initOwner((Window)stage);
        } else {
            alert.initOwner((Window)Main.get().getPrimaryStage());
        }
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(body);
        return alert.showAndWait();
    }

    public static <T> T showQuestion(String title, Object[] data, Class<T> type) {
        ChoiceDialog choiceDialog = new ChoiceDialog((Object)title, data);
        choiceDialog.showingProperty().addListener((ov, b, b1) -> {
            if (b1.booleanValue()) {
                choiceDialog.setContentText("");
            } else {
                choiceDialog.setContentText(null);
            }
            if (b1.booleanValue()) {
                Node comboBox = choiceDialog.getDialogPane().lookup(".combo-box");
                comboBox.requestFocus();
            }
        });
        choiceDialog.showAndWait();
        Object sel = choiceDialog.getSelectedItem();
        if (sel != null && type.isAssignableFrom(sel.getClass())) {
            return (T)sel;
        }
        return null;
    }

    public static Optional<ButtonType> showQuestion(String header, String body, Stage stage) {
        return AlertsCode.showQuestion("Pergunta", header, body, stage);
    }

    public static Optional<ButtonType> showQuestion(String header, String body) {
        return AlertsCode.showQuestion("Pergunta", header, body, null);
    }

    public static Optional<ButtonType> showQuestion(String body) {
        return AlertsCode.showQuestion("Pergunta", "", body, null);
    }

    public static Optional<ButtonType> showQuestion(String body, Stage stage) {
        return AlertsCode.showQuestion("Pergunta", "", body, stage);
    }

    public static String showAlertInput(String message) {
        TextInputDialog dialog = new TextInputDialog("");
        dialog.initOwner((Window)Main.get().getPrimaryStage());
        dialog.setTitle("Informe");
        dialog.setHeaderText(message);
        Optional result = dialog.showAndWait();
        Main.get().getPrimaryStage().requestFocus();
        return result.isPresent() ? (String)result.get() : null;
    }

    public static String showAlertInput(String message, String defaultText) {
        TextInputDialog dialog = new TextInputDialog(defaultText);
        dialog.initOwner((Window)Main.get().getPrimaryStage());
        dialog.setTitle("Informe");
        dialog.setHeaderText(message);
        Optional result = dialog.showAndWait();
        Main.get().getPrimaryStage().requestFocus();
        return result.isPresent() ? (String)result.get() : null;
    }

    public static String showAlertInputMask(String message) {
        TextInputDialog dialog = new TextInputDialog("");
        dialog.initOwner((Window)Main.get().getPrimaryStage());
        dialog.setTitle("Informe");
        dialog.setHeaderText(message);
        PasswordField pwd = new PasswordField();
        HBox content = new HBox();
        content.setAlignment(Pos.CENTER);
        content.setSpacing(50.0);
        content.getChildren().addAll((Object[])new Node[]{pwd});
        dialog.getDialogPane().setContent((Node)content);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                return pwd.getText();
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        Main.get().getPrimaryStage().requestFocus();
        return result.isPresent() ? (String)result.get() : null;
    }

    public static String showAlertInputMask(String message, String defaultText) {
        TextInputDialog dialog = new TextInputDialog(defaultText);
        dialog.initOwner((Window)Main.get().getPrimaryStage());
        dialog.setTitle("Informe");
        dialog.setHeaderText(message);
        PasswordField pwd = new PasswordField();
        HBox content = new HBox();
        content.setAlignment(Pos.CENTER);
        content.setSpacing(50.0);
        content.getChildren().addAll((Object[])new Node[]{pwd});
        dialog.getDialogPane().setContent((Node)content);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                return pwd.getText();
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        Main.get().getPrimaryStage().requestFocus();
        return result.isPresent() ? (String)result.get() : null;
    }

    public static DialogComboBox showDialogComboBox(String message, List itens) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("itens", itens);
        h.put("label", message);
        DialogComboBox dialog = (DialogComboBox)Main.get().showDialog(Controllers.DIALOG_COMBO, h);
        return dialog;
    }

    public static DialogDateTimeTextField showDialogDateTimeTextField(Stage oldStage) {
        return (DialogDateTimeTextField)Main.get().showDialog(Controllers.DIALOG_DATE_TIME_TEXT_FIELD);
    }

    public static DialogFieldMaxLenght showDialogInputTextMaxSize(String message, int tamanho) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("maxLength", tamanho);
        h.put("label", message);
        DialogFieldMaxLenght dialog = (DialogFieldMaxLenght)Main.get().showDialog(Controllers.DIALOG_FIELD_MAX_LENGTH, h);
        return dialog;
    }
}

