/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.alteracaopreco;

import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumTipoPreco;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.components.TouchButton;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.modeltemp.TipoPrecoCombustivel;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.utils.Style;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class AlteracaoPrecoController
extends BaseDialog {
    @FXML
    private Label lblPrecoAnterior;
    @FXML
    private Label lblNovoPreco;
    @FXML
    private Label lblFormaPagamento;
    @FXML
    private TouchDoubleField tfPrecoAnterior;
    @FXML
    private TouchDoubleField tfNovoPreco;
    @FXML
    private TouchComboBox<TipoPrecoCombustivel> cmbFormaPagamento;
    @FXML
    private TouchButton btnConfirmar;
    @FXML
    private TouchButton btnCancelar;
    @FXML
    private AnchorPane body;
    private HashMap hashRetorno = null;

    @Override
    public void initializeController(ResourceBundle rb) {
        PropertiesLoader props = PropertiesLoader.get();
        Style style = new Style();
        this.body.setStyle(style.getCorBody(props.getCorBackground_1(), props.getCorBackground_2(), props.getCorBackground_3(), props.getCorBackground_4(), props.getCorBackground_5()));
        this.tfPrecoAnterior.setNumberDecimalCases(3);
        this.tfPrecoAnterior.setEditable(false);
        this.tfNovoPreco.setNumberDecimalCases(3);
        this.cmbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)this.getListTipoPrecoCombustivel()));
        this.btnConfirmar.setOnAction(evt -> {
            if (this.isValidBeforeConfirm()) {
                this.confirma();
            }
        });
        this.btnCancelar.setOnAction(evt -> this.closeDialog());
        this.setLabelsTextFields();
    }

    private void setLabelsTextFields() {
        this.tfNovoPreco.setLabel(this.lblNovoPreco);
        this.tfPrecoAnterior.setLabel(this.lblPrecoAnterior);
        this.cmbFormaPagamento.setLabel(this.lblFormaPagamento);
    }

    private void confirma() {
        this.hashRetorno = new HashMap();
        this.hashRetorno.put("novoPreco", this.tfNovoPreco.getDouble());
        this.hashRetorno.put("formaPag", this.cmbFormaPagamento.getSelectionModel().getSelectedItem());
        this.closeDialog();
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.confirma();
                    break;
                }
                case ESCAPE: {
                    this.closeDialog();
                }
            }
        }
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfNovoPreco.requestFocus();
    }

    @Override
    public void posInitialize() {
        Double precoAnterior = (Double)this.getParams().get("precoAnterior");
        this.tfPrecoAnterior.setDouble(precoAnterior);
    }

    private boolean isValidBeforeConfirm() {
        if (this.tfNovoPreco.getDouble() == null || this.tfNovoPreco.getDouble().equals(0.0)) {
            Alerts.showAlertError("Primeiro informe o novo pre\u00e7o!");
            return false;
        }
        if (this.cmbFormaPagamento.getSelectionModel() == null) {
            Alerts.showAlertError("Primeiro informe a forma de pagamento!");
            return false;
        }
        return true;
    }

    public HashMap getHashRetorno() {
        return this.hashRetorno;
    }

    private List getListTipoPrecoCombustivel() {
        ArrayList<TipoPrecoCombustivel> list = new ArrayList<TipoPrecoCombustivel>();
        list.add(new TipoPrecoCombustivel(ConstEnumTipoPreco.A_VISTA.getCodigo(), ConstEnumTipoPreco.A_VISTA.getDescricao()));
        list.add(new TipoPrecoCombustivel(ConstEnumTipoPreco.A_PRAZO.getCodigo(), ConstEnumTipoPreco.A_PRAZO.getDescricao()));
        return list;
    }
}

