/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.consumidor;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndIntermediador;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.data.ValidateData;
import com.touchcomp.basementorvalidator.others.email.ValidateEmail;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.IntermediadorComercial;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeConsumidor;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.service.impl.ServiceIntermediadorComercial;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeConsumidor;
import com.touchcomp.touchnfce.utils.MaskField;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import lombok.Generated;

public class ConsumidorController
extends BaseDialog {
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnDelConsumidor;
    @FXML
    private TouchTextField tfPassaporte;
    @FXML
    private TouchTextField tfEmail;
    @FXML
    private TouchTextField tfNome;
    @FXML
    private AutoCompleteTextField tfCpfCnpj;
    @FXML
    private ComboBox<EnumConstantsMentorSimNao> cmbConsumidorFinal;
    @FXML
    private ComboBox<EnumConstNFeIndicadorPresConsumidor> cmbPresencaConsumidor;
    @FXML
    private ComboBox<EnumConstNFeIndIntermediador> cmbTipoIntermediador;
    @FXML
    private ComboBox<IntermediadorComercial> cmbIntermediador;
    @FXML
    private Label lblCpfCnpj;
    @FXML
    private Label lblPassaporte;
    @FXML
    private Label lblNome;
    @FXML
    private Label lblEmail;
    @FXML
    private Label lblConsumidorFinal;
    @FXML
    private Label lblPresencaConsumidor;
    @FXML
    private Label lblTipoIntermediador;
    @FXML
    private Label lblIntermediador;
    @FXML
    private AnchorPane body;
    public static final String CURRENT_CONSUMIDOR = "current_consumidor";
    public static final String CURRENT_PRESENCA = "current_presenca";
    public static final String CURRENT_TIPO_INTERMEDIADOR = "current_tipo_intermeadiador";
    public static final String CURRENT_INTERMEDIADOR = "current_intermediador";
    public static final String CURRENT_CONSUMIDOR_FINAL = "current_consumidor_final";
    public static final String INF_CONSUMIDOR = "permite.inf.consumidor";
    private NFCeConsumidor consumidor;
    Boolean permiteInformarConsumidor = false;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.btnConfirmar.setOnAction(event -> this.confirmarDados());
        this.btnCancelar.setOnAction(event -> this.getStage().close());
        this.btnDelConsumidor.setOnAction(event -> this.delConsumidorNFCe(true));
        MaskField.cpfCnpjField(this.tfCpfCnpj);
        this.tfPassaporte.setLabel(this.lblPassaporte);
        this.tfCpfCnpj.setLabel(this.lblCpfCnpj);
        this.tfEmail.setLabel(this.lblEmail);
        this.tfNome.setLabel(this.lblNome);
        this.cmbPresencaConsumidor.setItems(FXCollections.observableArrayList((Object[])EnumConstNFeIndicadorPresConsumidor.values()));
        this.cmbTipoIntermediador.setItems(FXCollections.observableArrayList((Object[])EnumConstNFeIndIntermediador.values()));
        this.cmbConsumidorFinal.setItems(FXCollections.observableArrayList((Object[])EnumConstantsMentorSimNao.valuesSimNao()));
        ServiceIntermediadorComercial service = Main.getBean(ServiceIntermediadorComercial.class);
        List<IntermediadorComercial> dados = service.getIntermediadoresComerciaisAtivos();
        LinkedList<IntermediadorComercial> l = new LinkedList<IntermediadorComercial>();
        l.add(null);
        l.addAll(dados);
        this.cmbIntermediador.setItems(FXCollections.observableArrayList(l));
    }

    private void delConsumidorNFCe(boolean showMessage) {
        if (this.getNFCe() != null && this.getNFCe().getNfCeConsumidor() != null) {
            this.getNFCe().setNfCeConsumidor(null);
            this.consumidor = null;
            if (showMessage) {
                Alerts.showAlertInfo("Consumidor removido com sucesso!");
            }
            this.limpaCampos();
        } else if (this.getPedido() != null && this.getPedido().getNfCeConsumidor() != null) {
            this.getPedido().setNfCeConsumidor(null);
            this.consumidor = null;
            if (showMessage) {
                Alerts.showAlertInfo("Consumidor removido com sucesso!");
            }
            this.limpaCampos();
        } else if (showMessage) {
            Alerts.showAlertInfo("Nenhum consumidor vinculado!");
        }
    }

    private void limpaCampos() {
        this.tfCpfCnpj.setText("");
        this.tfPassaporte.setText("");
        this.tfEmail.setText("");
        this.tfNome.setText("");
    }

    @Override
    public void posInitialize() {
        Short consumidorFinal = (Short)this.getParams().get(CURRENT_CONSUMIDOR_FINAL);
        Short presencaConsumidor = (Short)this.getParams().get(CURRENT_PRESENCA);
        Short tipoIntermediador = (Short)this.getParams().get(CURRENT_TIPO_INTERMEDIADOR);
        this.permiteInformarConsumidor = (Boolean)this.getParams().get(INF_CONSUMIDOR);
        this.showConsumidor((NFCeConsumidor)this.getParams().get(CURRENT_CONSUMIDOR));
        this.cmbIntermediador.getSelectionModel().select((Object)((IntermediadorComercial)this.getParams().get(CURRENT_INTERMEDIADOR)));
        this.cmbConsumidorFinal.getSelectionModel().select((Object)EnumConstantsMentorSimNao.get((Object)consumidorFinal));
        this.cmbPresencaConsumidor.getSelectionModel().select((Object)EnumConstNFeIndicadorPresConsumidor.valueOfCodigo((Short)presencaConsumidor));
        this.cmbTipoIntermediador.getSelectionModel().select((Object)EnumConstNFeIndIntermediador.valueOfCodigo((Short)tipoIntermediador));
        if (!this.permiteInformarConsumidor.booleanValue()) {
            this.tfEmail.setEditable(false);
            this.tfCpfCnpj.setEditable(false);
            this.tfNome.setEditable(false);
            this.tfPassaporte.setEditable(false);
        }
    }

    private void showConsumidor(NFCeConsumidor o) {
        if (o == null) {
            return;
        }
        this.tfCpfCnpj.setText(o.getCpfCnpj());
        this.tfEmail.setText(o.getEmail());
        this.tfNome.setText(o.getNome());
        this.tfPassaporte.setText(o.getPassaporte());
        this.consumidor = o;
    }

    @Override
    public void requestFocusOnOpen() {
        Platform.runLater(() -> this.tfCpfCnpj.requestFocus());
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getCode()) {
            case F12: {
                this.confirmarDados();
                break;
            }
            case ESCAPE: {
                this.getStage().close();
                break;
            }
            case DELETE: {
                this.delConsumidorNFCe(true);
                break;
            }
        }
    }

    private NFCe getNFCe() {
        return StaticObjects.getNfceAberta();
    }

    private Pedido getPedido() {
        return StaticObjects.getPedidoAberto();
    }

    private void confirmarDados() {
        this.confirmarOutrosDados();
        this.confirmarConsumidor();
    }

    private void confirmarOutrosDados() {
        if (this.cmbConsumidorFinal.getSelectionModel().getSelectedItem() == null) {
            Alerts.showAlertError("Tipo Consumidor \u00e9 obrigat\u00f3rio.");
            return;
        }
        if (this.cmbPresencaConsumidor.getSelectionModel().getSelectedItem() == null) {
            Alerts.showAlertError("Campo Presen\u00e7a Consumidor \u00e9 obrigat\u00f3rio.");
            return;
        }
        EnumConstantsMentorSimNao consFinal = (EnumConstantsMentorSimNao)this.cmbConsumidorFinal.getSelectionModel().getSelectedItem();
        EnumConstNFeIndIntermediador tipoIntermediador = (EnumConstNFeIndIntermediador)this.cmbTipoIntermediador.getSelectionModel().getSelectedItem();
        EnumConstNFeIndicadorPresConsumidor presConsumidor = (EnumConstNFeIndicadorPresConsumidor)this.cmbPresencaConsumidor.getSelectionModel().getSelectedItem();
        IntermediadorComercial intermediadorComercial = (IntermediadorComercial)this.cmbIntermediador.getSelectionModel().getSelectedItem();
        if (this.getNFCe() != null) {
            if (tipoIntermediador != null) {
                this.getNFCe().setTipoIntermediadorComercial(tipoIntermediador.getValue());
            }
            if (presConsumidor != null) {
                this.getNFCe().setIndicadorPresencaConsumidor(presConsumidor.getValue());
            }
            if (consFinal != null) {
                this.getNFCe().setIndicadorConsumidorFinal(consFinal.getValue());
            }
            this.getNFCe().setIntermediadorComercial(intermediadorComercial);
        } else if (this.getPedido() != null) {
            if (tipoIntermediador != null) {
                this.getPedido().setTipoIntermediador(tipoIntermediador.getValue());
            }
            if (presConsumidor != null) {
                this.getPedido().setIndicadorPresencaConsumidor(presConsumidor.getValue());
            }
            if (consFinal != null) {
                this.getPedido().setTipoConsumidor(consFinal.getValue());
            }
            this.getPedido().setIntermediadorComercial(intermediadorComercial);
        }
    }

    private void confirmarConsumidor() {
        if (!this.permiteInformarConsumidor.booleanValue() || !this.informouDadosConsumidor()) {
            this.delConsumidorNFCe(false);
            this.closeDialog();
            return;
        }
        if (!this.isValidBefore()) {
            return;
        }
        if (this.consumidor == null) {
            this.consumidor = new NFCeConsumidor();
        }
        if (!this.tfCpfCnpj.getText().isEmpty() && this.tfCpfCnpj.getText().length() >= 14) {
            this.consumidor.setCpfCnpj(ToolString.refina((String)this.tfCpfCnpj.getText()));
        } else if (!this.tfPassaporte.getText().isEmpty()) {
            this.consumidor.setCpfCnpj(this.tfPassaporte.getText());
        } else {
            Alerts.showAlertError("Informe valores v\u00e1lidos para CPF/CNPJ/Passaporte!");
            return;
        }
        this.consumidor.setNome(this.tfNome.getText());
        this.consumidor.setEmail(this.tfEmail.getText());
        ServiceNFCeConsumidor service = Main.getBean(ServiceNFCeConsumidor.class);
        if (this.getNFCe() != null && this.getNFCe().getNfCeConsumidor() != null) {
            this.consumidor = service.merge(this.consumidor);
            this.getNFCe().setNfCeConsumidor(this.consumidor);
            this.consumidor = service.save(this.consumidor);
            this.getNFCe().setNfCeConsumidor(this.consumidor);
        } else if (this.getPedido() != null && this.getPedido().getNfCeConsumidor() != null) {
            this.consumidor = service.merge(this.consumidor);
            this.getPedido().setNfCeConsumidor(this.consumidor);
            this.consumidor = service.save(this.consumidor);
            this.getPedido().setNfCeConsumidor(this.consumidor);
        }
        this.closeDialog();
    }

    private boolean informouDadosConsumidor() {
        String cpfCnpj = this.tfCpfCnpj.getText();
        String passaporte = this.tfPassaporte.getText();
        String email = this.tfEmail.getText();
        return ToolMethods.isStrWithData((String)cpfCnpj) || ToolMethods.isStrWithData((String)passaporte) || ToolMethods.isStrWithData((String)email);
    }

    private boolean isValidBefore() {
        String cpfCnpj = this.tfCpfCnpj.getText();
        String passaporte = this.tfPassaporte.getText();
        String email = this.tfEmail.getText();
        if (!ValidateData.isValid((String[])new String[]{cpfCnpj}) && !ValidateData.isValid((String[])new String[]{passaporte})) {
            Alerts.showAlertError("Informe uma identifica\u00e7\u00e3o do consumidor para continuar (CPF, CNPJ ou passaporte)!");
            return false;
        }
        if (cpfCnpj != null && cpfCnpj.length() > 0 && passaporte != null && passaporte.length() > 0) {
            Alerts.showAlertError("Informe apenas uma identifica\u00e7\u00e3o do consumidor para continuar (CPF, CNPJ ou passaporte)!");
            return false;
        }
        if (!ValidateData.isValid((String[])new String[]{cpfCnpj})) {
            Alerts.showAlertError("O CPF/CNPJ informado \u00e9 inv\u00e1lido");
            return false;
        }
        if (email != null && email.trim().length() > 0 && !ValidateEmail.isValid((String)email)) {
            Alerts.showAlertError("Email inv\u00e1lido");
            return false;
        }
        return true;
    }

    @Generated
    public NFCeConsumidor getConsumidor() {
        return this.consumidor;
    }
}

