/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dialogs;

import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.utils.MaskField;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class DialogDateField
extends BaseDialog {
    public static final String LABEL = "label";
    public static final String DATA = "data";
    public static final String FORMAT_DATE = "formatDate";
    @FXML
    private AnchorPane body;
    @FXML
    private Label descricao;
    @FXML
    private TouchTextField tfDataInformada;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    private String label;
    private Date dataInformada;
    private SimpleDateFormat format;

    @Override
    public void initializeController(ResourceBundle resources) {
        MaskField.dateField(this.tfDataInformada);
        this.btnCancelar.setOnAction(evt -> {
            this.dataInformada = null;
            this.closeDialog();
        });
        this.btnConfirmar.setOnAction(evt -> {
            this.dataInformada = ToolDate.strToDate((String)this.tfDataInformada.getText());
            this.closeDialog();
        });
        this.tfDataInformada.setOnKeyPressed(evt -> {
            switch (evt.getCode()) {
                case ENTER: {
                    if (!ToolMethods.isStrWithData((String)this.tfDataInformada.getText())) break;
                    this.dataInformada = ToolDate.strToDate((String)this.tfDataInformada.getText());
                    this.closeDialog();
                }
            }
        });
        this.tfDataInformada.setLabel(this.descricao);
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.dataInformada = ToolDate.strToDate((String)this.tfDataInformada.getText());
                    this.closeDialog();
                    break;
                }
                case ESCAPE: {
                    this.dataInformada = null;
                    this.closeDialog();
                    break;
                }
                case ENTER: {
                    if (!this.btnConfirmar.isFocused()) break;
                    this.dataInformada = ToolDate.strToDate((String)this.tfDataInformada.getText());
                    this.closeDialog();
                }
            }
        }
    }

    public Date getDataInformada() {
        return this.dataInformada;
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfDataInformada.requestFocus();
    }

    @Override
    public void posInitialize() {
        this.label = (String)this.getParams().get(LABEL);
        this.format = new SimpleDateFormat((String)this.getParams().get(FORMAT_DATE));
        if (this.getParams().get(DATA) != null) {
            this.tfDataInformada.setText(ToolDate.dateToStr((Date)((Date)this.getParams().get(DATA)), (String)((String)this.getParams().get(FORMAT_DATE))));
        }
        this.descricao.setText(this.label);
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }
}

