/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dialogs;

import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.components.TouchRadioButton;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.Style;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class DialogDateTimeTextField
extends BaseDialog {
    @FXML
    private TouchRadioButton radioModoNormal;
    @FXML
    private TouchRadioButton radioModoExtendido;
    @FXML
    private TouchTextField tfCampoHora;
    @FXML
    private TouchTextField tfCampoData;
    @FXML
    private Button btnConfirma;
    @FXML
    private Button btnCancela;
    @FXML
    private AnchorPane body;
    private SimpleDateFormat format;
    private String auxHora;
    private String auxData;
    private Date dateInf;

    @Override
    public void initializeController(ResourceBundle resources) {
        PropertiesLoader props = PropertiesLoader.get();
        Style style = new Style();
        this.body.setStyle(style.getCorBody(props.getCorBackground_1(), props.getCorBackground_2(), props.getCorBackground_3(), props.getCorBackground_4(), props.getCorBackground_5()));
        this.format = new SimpleDateFormat("dd HH:mm");
        this.radioModoNormal.setSelectedRadio(true);
        this.setPropertiesTextFields();
        this.radioModoNormal.setOnAction(evt -> this.selectModoNormal());
        this.radioModoExtendido.setOnAction(evt -> this.selectModoExtendido());
        this.btnConfirma.setOnAction(evt -> this.confirma());
        this.btnCancela.setOnAction(evt -> {
            this.dateInf = null;
            this.closeDialog();
        });
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfCampoData.requestFocus();
    }

    public void confirma() {
        this.format.setLenient(false);
        try {
            this.dateInf = this.radioModoNormal.isSelected() ? this.format.parse(this.tfCampoData.getText() + " " + this.tfCampoHora.getText()) : this.format.parse(this.tfCampoData.getText() + " " + this.tfCampoHora.getText());
            this.closeDialog();
        }
        catch (ParseException e) {
            Alerts.showAlertError("Informe uma data e hora v\u00e1lida!", this.getStage());
        }
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F1: {
                    this.radioModoNormal.setSelectedRadio(true);
                    this.selectModoNormal();
                    break;
                }
                case F2: {
                    this.radioModoExtendido.setSelectedRadio(true);
                    this.selectModoExtendido();
                    break;
                }
                case ESCAPE: {
                    this.dateInf = null;
                    this.closeDialog();
                    break;
                }
                case F12: {
                    this.confirma();
                    break;
                }
                case ENTER: {
                    this.confirma();
                }
            }
        }
    }

    private void setPropertiesTextFields() {
        this.tfCampoData.setText("");
        this.tfCampoHora.setText("");
        this.tfCampoData.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (DialogDateTimeTextField.this.radioModoNormal.isSelected()) {
                    if (DialogDateTimeTextField.this.tfCampoData.getText().length() <= 2) {
                        Platform.runLater(() -> {
                            String value = DialogDateTimeTextField.this.tfCampoData.getText();
                            value = value.replaceAll("[^0-9]", "");
                            value = value.replaceFirst("(\\d)", "$1");
                            DialogDateTimeTextField.this.tfCampoData.setText(value);
                            DialogDateTimeTextField.this.auxData = value;
                            MaskField.positionCaret(DialogDateTimeTextField.this.tfCampoData);
                        });
                    } else {
                        DialogDateTimeTextField.this.tfCampoData.setText(DialogDateTimeTextField.this.auxData);
                    }
                } else if (DialogDateTimeTextField.this.tfCampoData.getText().length() <= 10) {
                    Platform.runLater(() -> {
                        String value = DialogDateTimeTextField.this.tfCampoData.getText();
                        value = value.replaceAll("[^0-9]", "");
                        value = value.replaceFirst("(\\d{2})(\\d)", "$1/$2");
                        value = value.replaceFirst("(\\d{2})\\/(\\d{2})(\\d)", "$1/$2/$3");
                        DialogDateTimeTextField.this.tfCampoData.setText(value);
                        DialogDateTimeTextField.this.auxData = value;
                        MaskField.positionCaret(DialogDateTimeTextField.this.tfCampoData);
                    });
                } else {
                    DialogDateTimeTextField.this.tfCampoData.setText(DialogDateTimeTextField.this.auxData);
                }
            }
        });
        this.tfCampoHora.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (DialogDateTimeTextField.this.radioModoNormal.isSelected()) {
                    if (DialogDateTimeTextField.this.tfCampoHora.getText().length() <= 5) {
                        Platform.runLater(() -> {
                            String value = DialogDateTimeTextField.this.tfCampoHora.getText();
                            value = value.replaceAll("[^0-9]", "");
                            value = value.replaceFirst("(\\d{2})(\\d)", "$1:$2");
                            DialogDateTimeTextField.this.tfCampoHora.setText(value);
                            DialogDateTimeTextField.this.auxHora = value;
                            MaskField.positionCaret(DialogDateTimeTextField.this.tfCampoHora);
                        });
                    } else {
                        DialogDateTimeTextField.this.tfCampoHora.setText(DialogDateTimeTextField.this.auxHora);
                    }
                } else if (DialogDateTimeTextField.this.tfCampoHora.getText().length() <= 8) {
                    Platform.runLater(() -> {
                        String value = DialogDateTimeTextField.this.tfCampoHora.getText();
                        value = value.replaceAll("[^0-9]", "");
                        value = value.replaceFirst("(\\d{2})(\\d)", "$1:$2");
                        value = value.replaceFirst("(\\d{2})\\:(\\d{2})(\\d)", "$1:$2:$3");
                        DialogDateTimeTextField.this.tfCampoHora.setText(value);
                        DialogDateTimeTextField.this.auxHora = value;
                        MaskField.positionCaret(DialogDateTimeTextField.this.tfCampoHora);
                    });
                } else {
                    DialogDateTimeTextField.this.tfCampoHora.setText(DialogDateTimeTextField.this.auxHora);
                }
            }
        });
    }

    public Date getDateInf() {
        return this.dateInf;
    }

    public int getModoAlteracaoDate() {
        return this.radioModoNormal.isSelected() ? 0 : 1;
    }

    private void selectModoNormal() {
        if (this.radioModoNormal.isSelected()) {
            this.format = new SimpleDateFormat("dd HH:mm");
            this.tfCampoData.setText("");
            this.tfCampoHora.setText("");
            this.radioModoExtendido.setSelectedRadio(false);
        } else {
            this.radioModoExtendido.setSelectedRadio(false);
        }
    }

    private void selectModoExtendido() {
        if (this.radioModoExtendido.isSelected()) {
            this.format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            this.tfCampoData.setText("");
            this.tfCampoHora.setText("");
            this.radioModoNormal.setSelectedRadio(false);
        } else {
            this.radioModoNormal.setSelectedRadio(false);
        }
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }
}

