/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dialogs;

import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.components.TouchMonetaryField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeTransp;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.TipoFrete;
import com.touchcomp.touchnfce.model.Transportador;
import com.touchcomp.touchnfce.model.UnidadeFederativa;
import com.touchcomp.touchnfce.service.impl.ServiceTipoFrete;
import com.touchcomp.touchnfce.service.impl.ServiceTransportador;
import com.touchcomp.touchnfce.service.impl.ServiceUnidadeFederativa;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class DialogOutrasOpcoesCliente
extends BaseDialog {
    public static final String PEDIDO = "PEDIDO";
    @FXML
    private TouchTextField tfDataPrevSaida;
    @FXML
    private TouchTextField tfPlaca;
    @FXML
    private TouchTextField tfAntt;
    @FXML
    private TouchTextField txtObservacao;
    @FXML
    private TouchMonetaryField tfVrFrete;
    @FXML
    private Label lblDataPrevSaida;
    @FXML
    private Label lblTransportador;
    @FXML
    private Label lblVrFrete;
    @FXML
    private Label lblTipoFrete;
    @FXML
    private Label lblPlaca;
    @FXML
    private Label lblAntt;
    @FXML
    private Label lblUF;
    @FXML
    private Label lblObservacao;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private AnchorPane body;
    @FXML
    private TouchComboBox<Transportador> cmbTransportador;
    @FXML
    private TouchComboBox<UnidadeFederativa> cmbUF;
    @FXML
    private TouchComboBox<TipoFrete> cmbTipoFrete;
    private String auxData;
    private SimpleDateFormat format;
    private Date dateInf;
    private NFCeTransp dadosTransporte;
    private boolean isPedido = false;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.format = new SimpleDateFormat("dd/MM/yyyy");
        this.carregarTransportadores();
        ServiceTipoFrete serviceTipoFrete = Main.getBean(ServiceTipoFrete.class);
        this.cmbTipoFrete.setItems(FXCollections.observableArrayList(serviceTipoFrete.getAll()));
        ServiceUnidadeFederativa serviceUF = Main.getBean(ServiceUnidadeFederativa.class);
        this.cmbUF.setItems(FXCollections.observableArrayList(serviceUF.getAll()));
        this.cmbUF.getSelectionModel().select((Object)StaticObjects.getEmpresa().getPessoa().getEndereco().getCidade().getUf());
        this.setPropertieFieldDate();
        this.btnConfirmar.setOnAction(evt -> this.confirma());
        this.btnCancelar.setOnAction(evt -> this.closeDialog());
        this.tfDataPrevSaida.setLabel(this.lblDataPrevSaida);
        this.tfAntt.setLabel(this.lblAntt);
        this.tfPlaca.setLabel(this.lblPlaca);
        this.cmbTransportador.setLabel(this.lblTransportador);
        this.cmbTipoFrete.setLabel(this.lblTipoFrete);
        this.cmbUF.setLabel(this.lblUF);
        this.tfVrFrete.setLabel(this.lblVrFrete);
        this.txtObservacao.setLabel(this.lblObservacao);
        this.tfDataPrevSaida.setText(ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy"));
    }

    private NFCe getNFCe() {
        return StaticObjects.getNfceAberta();
    }

    private Pedido getPedido() {
        return StaticObjects.getPedidoAberto();
    }

    @Override
    public void posInitialize() {
        this.isPedido = (Boolean)this.getParams().get(PEDIDO);
        this.objectToScreen();
    }

    private void desabilitaCamposPedido() {
        this.tfAntt.setDisable(true);
        this.lblAntt.setVisible(false);
        this.tfAntt.setVisible(false);
        this.tfPlaca.setDisable(true);
        this.lblPlaca.setVisible(false);
        this.tfPlaca.setVisible(false);
        this.tfVrFrete.setDisable(true);
        this.lblVrFrete.setVisible(false);
        this.tfVrFrete.setVisible(false);
        this.cmbUF.setDisable(true);
        this.lblUF.setVisible(false);
        this.cmbUF.setVisible(false);
        this.txtObservacao.setDisable(true);
        this.lblObservacao.setVisible(false);
        this.txtObservacao.setVisible(false);
    }

    private void objectToScreen() {
        if (this.isPedido) {
            this.desabilitaCamposPedido();
            if (this.getPedido() != null) {
                this.txtObservacao.setText(this.getPedido().getObservacao());
                this.cmbTransportador.getSelectionModel().select((Object)this.getPedido().getTransportador());
                this.cmbTipoFrete.getSelectionModel().select((Object)this.getPedido().getTipoFrete());
                this.tfVrFrete.setAmount(this.getPedido().getValorFrete());
                if (this.getPedido().getDataPrevisaoSaida() != null) {
                    this.tfDataPrevSaida.setText(ToolDate.dateToStr((Date)this.getPedido().getDataPrevisaoSaida(), (String)"dd/MM/yyyy"));
                }
            }
        } else if (this.getNFCe() != null && this.getNFCe().getDadosTransporte() != null) {
            this.dadosTransporte = this.getNFCe().getDadosTransporte();
            this.txtObservacao.setText(this.getNFCe().getInfAdicManualNFCe());
            this.cmbUF.getSelectionModel().select((Object)this.getNFCe().getDadosTransporte().getUfVeiculo());
            if (this.cmbUF.getSelectionModel().getSelectedItem() == null) {
                this.cmbUF.getSelectionModel().select((Object)StaticObjects.getEmpresa().getPessoa().getEndereco().getCidade().getUf());
            }
            this.cmbTransportador.getSelectionModel().select((Object)this.getNFCe().getDadosTransporte().getTransportador());
            this.cmbTipoFrete.getSelectionModel().select((Object)this.getNFCe().getDadosTransporte().getTipoFrete());
            this.tfVrFrete.setAmount(this.getNFCe().getDadosTransporte().getValorFrete());
            if (this.getNFCe().getDataPrevSaida() != null) {
                this.tfDataPrevSaida.setText(ToolDate.dateToStr((Date)StaticObjects.getNfceAberta().getDataPrevSaida(), (String)"dd/MM/yyyy"));
            }
            this.tfAntt.setText(this.getNFCe().getDadosTransporte().getRegistroANTTVeiculo());
            this.tfPlaca.setText(this.getNFCe().getDadosTransporte().getPlacaVeiculo());
        }
    }

    private void confirma() {
        this.format.setLenient(false);
        try {
            if (StaticObjects.getNfceAberta() == null) {
                StaticObjects.setNfceAberta(UtilNFCe.createNFCeModelo65(null));
            }
            this.dateInf = ToolMethods.isStrWithData((String)this.tfDataPrevSaida.getText()) ? this.format.parse(this.tfDataPrevSaida.getText()) : null;
            if (!this.isPedido) {
                if (this.dateInf != null && ToolDate.dataSemHora((Date)this.dateInf).before(ToolDate.dataSemHora((Date)StaticObjects.getNfceAberta().getDataEmissao()))) {
                    Alerts.showAlertError("A data de previs\u00e3o de saida n\u00e3o pode ser menor que a data de emiss\u00e3o da nota!");
                    return;
                }
                if (!this.isValidBeforeDadosPlaca()) {
                    return;
                }
                this.getNFCe().setInfAdicManualNFCe(this.txtObservacao.getText());
                this.getNFCe().setDataPrevSaida(this.dateInf);
                this.dadosTransporte.setPlacaVeiculo(this.getPlaca());
                this.dadosTransporte.setRegistroANTTVeiculo(this.getANTT());
                this.dadosTransporte.setValorFrete(this.tfVrFrete.getAmount());
                if (this.cmbTransportador.getSelectionModel() != null && this.cmbTransportador.getSelectionModel().getSelectedItem() != null) {
                    this.dadosTransporte.setTransportador((Transportador)this.cmbTransportador.getSelectionModel().getSelectedItem());
                }
                if (this.cmbTipoFrete.getSelectionModel() != null && this.cmbTipoFrete.getSelectionModel().getSelectedItem() != null) {
                    this.dadosTransporte.setTipoFrete((TipoFrete)this.cmbTipoFrete.getSelectionModel().getSelectedItem());
                }
                if (this.cmbUF.getSelectionModel() != null && this.cmbUF.getSelectionModel().getSelectedItem() != null) {
                    this.dadosTransporte.setUfVeiculo((UnidadeFederativa)this.cmbUF.getSelectionModel().getSelectedItem());
                }
                this.getNFCe().setDadosTransporte(this.dadosTransporte);
                StaticObjects.refreshNFCe();
            } else {
                if (this.dateInf != null && ToolDate.dataSemHora((Date)this.dateInf).before(ToolDate.dataSemHora((Date)this.getPedido().getDataEmissao()))) {
                    Alerts.showAlertError("A data de previs\u00e3o de saida n\u00e3o pode ser menor que a data de emiss\u00e3o do pedido!");
                    return;
                }
                this.getPedido().setObservacao(this.txtObservacao.getText());
                this.getPedido().setDataPrevisaoSaida(this.dateInf);
                if (this.cmbTransportador.getSelectionModel() != null && this.cmbTransportador.getSelectionModel().getSelectedItem() != null) {
                    this.getPedido().setTransportador((Transportador)this.cmbTransportador.getSelectionModel().getSelectedItem());
                    this.getPedido().setValorFrete(this.tfVrFrete.getAmount());
                }
                if (this.cmbTipoFrete.getSelectionModel() != null && this.cmbTipoFrete.getSelectionModel().getSelectedItem() != null) {
                    this.getPedido().setTipoFrete((TipoFrete)this.cmbTipoFrete.getSelectionModel().getSelectedItem());
                }
                StaticObjects.refreshPedido();
            }
            this.closeDialog();
        }
        catch (ParseException e) {
            Alerts.showAlertError("Informe uma data e hora v\u00e1lida!");
        }
    }

    public String getPlaca() {
        String placa = this.tfPlaca.getText();
        placa = placa != null ? placa.toUpperCase() : null;
        return placa;
    }

    public String getANTT() {
        return this.tfAntt.getText();
    }

    private boolean isValidBeforeDadosPlaca() {
        boolean retValuePlaca;
        String placa = this.tfPlaca.getText();
        String antt = this.tfAntt.getText();
        boolean bl = retValuePlaca = placa != null && !placa.isEmpty();
        if (retValuePlaca) {
            if (placa.length() != 7) {
                Alerts.showAlertInfo("Placa deve possuir 7 digitos/caracteres.");
                this.tfPlaca.requestFocus();
                return false;
            }
            if (this.cmbUF.getSelectionModel().getSelectedItem() == null) {
                Alerts.showAlertInfo("Selecione uma UF.");
                this.cmbUF.requestFocus();
                return false;
            }
        }
        return true;
    }

    private void setPropertieFieldDate() {
        this.tfDataPrevSaida.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (DialogOutrasOpcoesCliente.this.tfDataPrevSaida.getText().length() <= 10) {
                    Platform.runLater(() -> {
                        String value = DialogOutrasOpcoesCliente.this.tfDataPrevSaida.getText();
                        value = value.replaceAll("[^0-9]", "");
                        value = value.replaceFirst("(\\d{2})(\\d)", "$1/$2");
                        value = value.replaceFirst("(\\d{2})\\/(\\d{2})(\\d)", "$1/$2/$3");
                        DialogOutrasOpcoesCliente.this.tfDataPrevSaida.setText(value);
                        DialogOutrasOpcoesCliente.this.auxData = value;
                        MaskField.positionCaret(DialogOutrasOpcoesCliente.this.tfDataPrevSaida);
                    });
                } else {
                    DialogOutrasOpcoesCliente.this.tfDataPrevSaida.setText(DialogOutrasOpcoesCliente.this.auxData);
                }
            }
        });
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getCode()) {
            case ESCAPE: {
                this.closeDialog();
                break;
            }
            case F12: {
                this.confirma();
                break;
            }
            case ENTER: {
                this.confirma();
            }
        }
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfDataPrevSaida.requestFocus();
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }

    private void carregarTransportadores() {
        ServiceTransportador service = Main.getBean(ServiceTransportador.class);
        List transportadores = service.getAll();
        ArrayList<Transportador> transportadoresAtivos = new ArrayList<Transportador>();
        for (Transportador t : transportadores) {
            if (t.getAtivo() != null && (!ToolMethods.isEquals((Object)t.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)t.getPessoa().getAtivo(), (Object)1))) continue;
            transportadoresAtivos.add(t);
        }
        this.cmbTransportador.setItems(FXCollections.observableArrayList(transportadoresAtivos));
    }
}

