/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dialogs;

import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextArea;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.SituacaoPedidos;
import com.touchcomp.touchnfce.model.TipoFrete;
import com.touchcomp.touchnfce.model.Transportador;
import com.touchcomp.touchnfce.service.impl.ServiceSituacaoPedidos;
import com.touchcomp.touchnfce.service.impl.ServiceTipoFrete;
import com.touchcomp.touchnfce.service.impl.ServiceTransportador;
import com.touchcomp.touchnfce.utils.MaskField;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class DialogOutrasOpcoesPedido
extends BaseDialog {
    @FXML
    private TouchTextField tfDataPrevSaida;
    @FXML
    private TouchDoubleField tfVrFrete;
    @FXML
    private TouchTextArea tfObservacao;
    @FXML
    private Label lblDataPrevSaida;
    @FXML
    private Label lblTransportador;
    @FXML
    private Label lblVrFrete;
    @FXML
    private Label lblTipoFrete;
    @FXML
    private Label lblSituacaoPedido;
    @FXML
    private Label lblObservacao;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private AnchorPane body;
    @FXML
    private TouchComboBox<Transportador> cmbTransportador;
    @FXML
    private TouchComboBox<TipoFrete> cmbTipoFrete;
    @FXML
    private TouchComboBox<SituacaoPedidos> cmbSituacaoPedido;
    private String auxData;
    private SimpleDateFormat format;
    private Date dateInf;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.format = new SimpleDateFormat("dd/MM/yyyy");
        this.tfDataPrevSaida.setText(ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy"));
        ServiceTransportador service = Main.getBean(ServiceTransportador.class);
        this.cmbTransportador.setItems(FXCollections.observableArrayList(service.getAll()));
        ServiceTipoFrete serviceTipoFrete = Main.getBean(ServiceTipoFrete.class);
        this.cmbTipoFrete.setItems(FXCollections.observableArrayList(serviceTipoFrete.getAll()));
        ServiceSituacaoPedidos serviceSitPedido = Main.getBean(ServiceSituacaoPedidos.class);
        this.cmbSituacaoPedido.setItems(FXCollections.observableArrayList(serviceSitPedido.getSituacoesDisponiveis()));
        this.setPropertieFieldDate();
        this.btnConfirmar.setOnAction(evt -> this.confirma());
        this.btnCancelar.setOnAction(evt -> this.closeDialog());
        this.tfDataPrevSaida.setLabel(this.lblDataPrevSaida);
        this.cmbTransportador.setLabel(this.lblTransportador);
        this.cmbTipoFrete.setLabel(this.lblTipoFrete);
        this.cmbSituacaoPedido.setLabel(this.lblSituacaoPedido);
        this.tfVrFrete.setLabel(this.lblVrFrete);
        this.tfObservacao.setLabel(this.lblObservacao);
        this.desabilitaCampos();
    }

    @Override
    public void posInitialize() {
        this.showDados();
    }

    private void desabilitaCampos() {
        this.tfVrFrete.setDisable(true);
        this.lblVrFrete.setVisible(false);
        this.tfVrFrete.setVisible(false);
    }

    private void confirma() {
        this.format.setLenient(false);
        try {
            this.dateInf = this.format.parse(this.tfDataPrevSaida.getText());
            if (this.dateInf != null) {
                StaticObjects.getPedidoAberto().setDataPrevisaoSaida(this.dateInf);
            }
            if (this.cmbTransportador.getSelectionModel() != null && this.cmbTransportador.getSelectionModel().getSelectedItem() != null) {
                StaticObjects.getPedidoAberto().setTransportador((Transportador)this.cmbTransportador.getSelectionModel().getSelectedItem());
            }
            if (this.tfVrFrete.getDouble() != null) {
                StaticObjects.getPedidoAberto().setValorFrete(this.tfVrFrete.getDouble());
            }
            if (this.cmbTipoFrete.getSelectionModel() != null && this.cmbTipoFrete.getSelectionModel().getSelectedItem() != null) {
                StaticObjects.getPedidoAberto().setTipoFrete((TipoFrete)this.cmbTipoFrete.getSelectionModel().getSelectedItem());
            }
            if (this.cmbSituacaoPedido.getSelectionModel() != null && this.cmbSituacaoPedido.getSelectionModel().getSelectedItem() != null) {
                StaticObjects.getPedidoAberto().setSituacaoPedidos((SituacaoPedidos)this.cmbSituacaoPedido.getSelectionModel().getSelectedItem());
            }
            StaticObjects.getPedidoAberto().setObservacao(this.tfObservacao.getText());
            StaticObjects.refreshPedido();
            this.closeDialog();
        }
        catch (ParseException e) {
            Alerts.showAlertError("Informe uma data e hora v\u00e1lida!");
        }
    }

    private void setPropertieFieldDate() {
        this.tfDataPrevSaida.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (DialogOutrasOpcoesPedido.this.tfDataPrevSaida.getText().length() <= 10) {
                    Platform.runLater(() -> {
                        String value = DialogOutrasOpcoesPedido.this.tfDataPrevSaida.getText();
                        value = value.replaceAll("[^0-9]", "");
                        value = value.replaceFirst("(\\d{2})(\\d)", "$1/$2");
                        value = value.replaceFirst("(\\d{2})\\/(\\d{2})(\\d)", "$1/$2/$3");
                        DialogOutrasOpcoesPedido.this.tfDataPrevSaida.setText(value);
                        DialogOutrasOpcoesPedido.this.auxData = value;
                        MaskField.positionCaret(DialogOutrasOpcoesPedido.this.tfDataPrevSaida);
                    });
                } else {
                    DialogOutrasOpcoesPedido.this.tfDataPrevSaida.setText(DialogOutrasOpcoesPedido.this.auxData);
                }
            }
        });
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getCode()) {
            case ESCAPE: {
                this.closeDialog();
                break;
            }
            case F12: {
                this.confirma();
                break;
            }
            case ENTER: {
                this.confirma();
            }
        }
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfDataPrevSaida.requestFocus();
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }

    private void showDados() {
        if (StaticObjects.getPedidoAberto() != null) {
            this.cmbTransportador.getSelectionModel().select((Object)StaticObjects.getPedidoAberto().getTransportador());
            this.cmbTipoFrete.getSelectionModel().select((Object)StaticObjects.getPedidoAberto().getTipoFrete());
            this.cmbSituacaoPedido.getSelectionModel().select((Object)StaticObjects.getPedidoAberto().getSituacaoPedidos());
            this.tfVrFrete.setDouble(StaticObjects.getPedidoAberto().getValorFrete());
            this.tfObservacao.setText(StaticObjects.getPedidoAberto().getObservacao());
            this.tfDataPrevSaida.setText(ToolDate.dateToStr((Date)StaticObjects.getPedidoAberto().getDataPrevisaoSaida(), (String)"dd/MM/yyyy"));
        }
    }
}

