/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.formapagamento.pedido;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.components.listener.FocusListener;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.dialogs.DialogDoubleField;
import com.touchcomp.touchnfce.controller.formapagamento.TipoPagamentoConverter;
import com.touchcomp.touchnfce.controller.formapagamento.pedido.GrupoFormaPagamentoPedido;
import com.touchcomp.touchnfce.controller.formapagamento.venda.GrupoFormaPagamentoNFCe;
import com.touchcomp.touchnfce.controller.titulo.pedido.TituloPedido;
import com.touchcomp.touchnfce.model.ClienteNFCeMeioPagamento;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.InfPagamentoPedido;
import com.touchcomp.touchnfce.model.NFCeOpcoesCondPagamento;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.PedidoTitulo;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.service.ServiceEntityAPI;
import com.touchcomp.touchnfce.service.impl.ServiceCondicoesPagamento;
import com.touchcomp.touchnfce.service.impl.ServiceTipoPagamentoNFe;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilShowDialogTable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

class AuxInformaPagamentoPedido
implements AutoCompleteTextField.ItemSelListener {
    InfPagamentoPedido currentPagamento = null;
    AutoCompleteTextField txtOperacaoPagamento;
    private boolean processNextEvent = true;
    private KeyEvent lastEvent;
    GrupoFormaPagamentoPedido grupoFormas;
    TreeSet<TipoPagamentoConverter> tiposPagamentos = new TreeSet();
    PagamentoEstagio estagioPagamento = PagamentoEstagio.PAG_NAO_INICIADO;
    Label lblOpPagamento;

    public boolean isProcessNextEvent() {
        return this.processNextEvent;
    }

    public void setProcessNextEvent(boolean processNextEvent) {
        System.out.println("Setting Process Next Event " + processNextEvent);
        this.processNextEvent = processNextEvent;
    }

    public void setAcrescimoMarjoracaoCondicaoPagamento(CondicoesPagamento condicoesPagamento) {
        if (condicoesPagamento.getMajoracaoPreco() > 0.0) {
            this.grupoFormas.aplicaAcrescimoCondicaoPagamento(condicoesPagamento.getMajoracaoPreco());
        }
    }

    public void onItemListener(Object data) {
        switch (this.getEstagioPagamento().ordinal()) {
            case 1: {
                TipoPagamentoConverter tp = (TipoPagamentoConverter)data;
                this.afterAdicionaTpPagamento(tp);
                break;
            }
            case 3: {
                CondicoesPagamento cond = (CondicoesPagamento)data;
                this.afterAdicionaCondPag(cond);
            }
        }
    }

    void afterAdicionaCondPag(CondicoesPagamento cond) {
        this.getCurrentPagamento().setCondicoesPagamento(cond);
        this.getCurrentPagamento().setMeioPagamento(cond.getMeioPagamento());
        this.getCurrentPagamento().setTipoPagamentoNFe(cond.getMeioPagamento().getTipoPagamentoNFe());
        this.getCurrentPagamento().setNumeroParcelas(cond.getNumeroParcelas().shortValue());
        this.setAcrescimoMarjoracaoCondicaoPagamento(cond);
        this.trataEnterMudancaAuto(true);
        this.beforeInformaValor();
    }

    public void afterAdicionaTpPagamento(TipoPagamentoConverter tp) {
        this.txtOperacaoPagamento.clear();
        this.getCurrentPagamento().setTipoPagamentoNFe(tp.getTipoPagamentoNFe());
        this.beforeInformaParcelas();
    }

    AuxInformaPagamentoPedido(GrupoFormaPagamentoPedido grupoFormas, AutoCompleteTextField txtOperacaoPagamento, Label lblOpPagamento) {
        this.txtOperacaoPagamento = txtOperacaoPagamento;
        this.grupoFormas = grupoFormas;
        this.lblOpPagamento = lblOpPagamento;
        txtOperacaoPagamento.setItemSelListener(this);
        txtOperacaoPagamento.setAlignment(Pos.CENTER);
        this.setEventsTxtOpPagamento();
        txtOperacaoPagamento.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
                if (AuxInformaPagamentoPedido.this.getEstagioPagamento() == PagamentoEstagio.PAG_NAO_INICIADO && AuxInformaPagamentoPedido.this.getValorFalta() > 0.0) {
                    AuxInformaPagamentoPedido.this.beforeSelecionaTpPagamento(true);
                }
            }

            @Override
            public void onFocusLost() {
            }
        });
        txtOperacaoPagamento.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                AuxInformaPagamentoPedido.this.trataEventosTextField(event);
            }
        });
    }

    Double getValorFalta() {
        if (this.getPedido() != null && this.grupoFormas != null) {
            return ToolFormatter.arrredondarNumero((Double)(this.getPedido().getValorTotalDescTrib() - this.grupoFormas.getValorPago()), (int)2);
        }
        return 0.0;
    }

    private Pedido getPedido() {
        return StaticObjects.getPedidoAberto();
    }

    public void beforeSelecionaTpPagamento(TipoPagamentoNFe tpPag) {
        this.txtOperacaoPagamento.clear();
        this.getCurrentPagamento().setTipoPagamentoNFe(tpPag);
        this.beforeInformaParcelas();
    }

    void beforeSelecionaTpPagamento(boolean showPop) {
        this.txtOperacaoPagamento.setAlignment(Pos.CENTER);
        this.txtOperacaoPagamento.clear();
        if (this.verificaSePodeRealizarPagamento(false)) {
            if (StaticObjects.getPedidoAberto().getInfPagamentoPedido().isEmpty() && StaticObjects.getPedidoAberto().getCondicoesPagamento() != null) {
                this.getCurrentPagamento().setCondicoesPagamento(StaticObjects.getPedidoAberto().getCondicoesPagamento());
                this.getCurrentPagamento().setMeioPagamento(this.getCurrentPagamento().getCondicoesPagamento().getMeioPagamento());
                this.getCurrentPagamento().setTipoPagamentoNFe(this.getCurrentPagamento().getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe());
                this.getCurrentPagamento().setNumeroParcelas(this.getCurrentPagamento().getCondicoesPagamento().getNumeroParcelas().shortValue());
                this.beforeInformaParcelas();
                this.afterAdicionaCondPag(this.getCurrentPagamento().getCondicoesPagamento());
            } else {
                this.lblOpPagamento.setText("Selecione uma forma de pagamento");
                this.setEstagioPagamento(PagamentoEstagio.PAG_SELECIONANDO_TIPO_PAG);
                ServiceTipoPagamentoNFe serviceTipoPagamentoNFe = Main.getBean(ServiceTipoPagamentoNFe.class);
                this.tiposPagamentos = TipoPagamentoConverter.converterList(serviceTipoPagamentoNFe.getTiposPagCondicoes(StaticObjects.getEmpresa()));
                this.tiposPagamentos = this.filtrarTiposPagamentosPorCliente(this.tiposPagamentos);
                this.txtOperacaoPagamento.setItems(this.tiposPagamentos);
                if (this.txtOperacaoPagamento.isFocused() && this.txtOperacaoPagamento.getText() != null && this.txtOperacaoPagamento.getText().length() == 0 && showPop) {
                    this.txtOperacaoPagamento.showPopupAllItems();
                }
            }
        }
    }

    private TreeSet<TipoPagamentoConverter> filtrarTiposPagamentosPorCliente(TreeSet<TipoPagamentoConverter> tiposPagamentos) {
        TreeSet<TipoPagamentoConverter> lista = new TreeSet<TipoPagamentoConverter>();
        if (StaticObjects.getPedidoAberto() != null && StaticObjects.getPedidoAberto().getUnidadeFatCliente() != null && StaticObjects.getPedidoAberto().getUnidadeFatCliente().getCliente().getClienteNFCeMeioPagamento() != null && !StaticObjects.getPedidoAberto().getUnidadeFatCliente().getCliente().getClienteNFCeMeioPagamento().isEmpty()) {
            block0: for (ClienteNFCeMeioPagamento m : StaticObjects.getPedidoAberto().getUnidadeFatCliente().getCliente().getClienteNFCeMeioPagamento()) {
                TipoPagamentoNFe t;
                if (!m.getAtivo().equals((short)1) || (t = m.getTipoPagamentoNFe()) == null) continue;
                for (TipoPagamentoConverter tp : tiposPagamentos) {
                    if (!tp.getTipoPagamentoNFe().equals(t)) continue;
                    lista.add(tp);
                    continue block0;
                }
            }
            return lista;
        }
        return tiposPagamentos;
    }

    private boolean verificaSePodeRealizarPagamento(boolean condManual) {
        if (this.getValorFalta() <= 0.0 && (this.txtOperacaoPagamento.isFocused() || condManual)) {
            this.txtOperacaoPagamento.setText("Pagamento conclu\u00eddo, finalize a emiss\u00e3o.");
            this.lblOpPagamento.setText("Pagamento conclu\u00eddo, finalize a emiss\u00e3o.");
            return false;
        }
        return true;
    }

    private void setEventsTxtOpPagamento() {
        this.txtOperacaoPagamento.textProperty().addListener((observableValue, antigo, novo) -> {
            if (this.getEstagioPagamento() == PagamentoEstagio.PAG_INFORMANDO_VALOR) {
                MaskField.monetaryField(this.txtOperacaoPagamento);
            }
            if (this.getEstagioPagamento() == PagamentoEstagio.PAG_INFORMANDO_PARCELAS) {
                MaskField.onlyDigitsIntValue(this.txtOperacaoPagamento);
            }
        });
    }

    boolean trataEventosTextField(KeyEvent evt) {
        if (evt.getCode() == KeyCode.ENTER) {
            System.out.println("Event Ocurred ENTER");
        }
        if (!this.isProcessNextEvent()) {
            this.setProcessNextEvent(true);
            return true;
        }
        if (!this.verificaSePodeRealizarPagamento(false)) {
            return false;
        }
        if (evt.getCode() == KeyCode.ENTER) {
            switch (this.getEstagioPagamento().ordinal()) {
                case 0: {
                    System.out.println("Pagamento nao iniciado.");
                    return false;
                }
                case 1: {
                    GrupoFormaPagamentoPedido.pagamentoEmAndamento = true;
                    System.out.println("Pagamento seleciona Tipo Pagamento.");
                    this.afterSelecionaTipoPagamento();
                    return true;
                }
                case 2: {
                    GrupoFormaPagamentoPedido.pagamentoEmAndamento = true;
                    this.afterInformaParcelas();
                    return true;
                }
                case 3: {
                    GrupoFormaPagamentoPedido.pagamentoEmAndamento = true;
                    System.out.println("Pagamento seleciona Condicao Pagamento.");
                    return true;
                }
                case 4: {
                    GrupoFormaPagamentoPedido.pagamentoEmAndamento = true;
                    System.out.println("Pagamento seleciona informa valor.");
                    this.afterAdicionaPagamentoValor();
                    return true;
                }
            }
        }
        return false;
    }

    void afterSelecionaTipoPagamento() {
        String text = ToolString.onlyNumbers((String)this.txtOperacaoPagamento.getText());
        if (text == null || text.length() == 0) {
            return;
        }
        Integer index = new Integer(text);
        Optional<TipoPagamentoConverter> sel = this.tiposPagamentos.stream().filter(i -> Objects.equals(i.getSequencia(), index)).findFirst();
        if (sel.isPresent()) {
            this.getCurrentPagamento().setTipoPagamentoNFe(sel.get().getTipoPagamentoNFe());
            this.beforeInformaParcelas();
        }
    }

    void afterAdicionaPagamentoValor() {
        if (this.txtOperacaoPagamento.getText() == null || this.txtOperacaoPagamento.getText().length() == 0) {
            return;
        }
        try {
            DecimalFormat nf = new DecimalFormat("#,###.00");
            if (this.txtOperacaoPagamento.isEditable() && this.txtOperacaoPagamento.getText().isEmpty()) {
                Alerts.showAlertError("Erro", "Informe um valor v\u00e1lido!");
                return;
            }
            double value = ToolFormatter.arrredondarNumero((Double)nf.parse(this.txtOperacaoPagamento.getText()).doubleValue(), (int)2);
            if (value <= 0.0) {
                Alerts.showAlertError("Erro", "Informe um valor v\u00e1lido!");
                return;
            }
            if (value > 999999.0) {
                Alerts.showAlertError("Erro", "O valor n\u00e3o pode superar R$999.999,00");
                this.txtOperacaoPagamento.clear();
                return;
            }
            if (!this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo()) && !this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CHEQUE.getCodigo()) && value > this.getValorFalta()) {
                Alerts.showAlertError("Erro", "Para esta forma de pagamento, o valor de pagamento n\u00e3o poder\u00e1 ser maior que o valor restante!");
                return;
            }
            this.getCurrentPagamento().setValor(value);
            this.getCurrentPagamento().setValorTroco(this.grupoFormas.getValorTroco(this.getCurrentPagamento()));
            this.getCurrentPagamento().setValorLiquido(this.getCurrentPagamento().getValor() - this.getCurrentPagamento().getValorTroco());
            this.beforeInformaOutrosDados();
        }
        catch (ParseException ex) {
            Logger.getLogger(GrupoFormaPagamentoNFCe.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError("Valor inv\u00e1lido. Verifique o valor informado.");
            this.beforeInformaValor();
        }
    }

    void adicionaPagamento() {
        this.getCurrentPagamento().setPedido(this.getPedido());
        this.grupoFormas.atualizaPedido(this.getCurrentPagamento());
        this.grupoFormas.atualizaCamposValores();
        this.grupoFormas.setFormasPagTable();
        this.currentPagamento = null;
        this.beforeSelecionaTpPagamento(true);
    }

    void beforeInformaValor() {
        this.txtOperacaoPagamento.hidePopup();
        this.txtOperacaoPagamento.clear();
        this.setEstagioPagamento(PagamentoEstagio.PAG_INFORMANDO_VALOR);
        this.lblOpPagamento.setText("Informe o valor a ser pago: " + this.getCurrentPagamento().getTipoPagamentoNFe().getDescricao());
        if (!this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo())) {
            this.txtOperacaoPagamento.setText(ToolFormatter.formataNumero((Number)this.getValorFalta(), (int)2));
        } else {
            this.txtOperacaoPagamento.clear();
        }
        this.txtOperacaoPagamento.selectAll();
        System.out.println("Before Informa valor " + this.processNextEvent);
    }

    PagamentoEstagio getEstagioPagamento() {
        return this.estagioPagamento;
    }

    void setEstagioPagamento(PagamentoEstagio estagioPagamento) {
        this.estagioPagamento = estagioPagamento;
    }

    InfPagamentoPedido getCurrentPagamento() {
        if (this.currentPagamento == null) {
            this.currentPagamento = new InfPagamentoPedido();
        }
        return this.currentPagamento;
    }

    void beforeInformaOutrosDados() {
        this.setEstagioPagamento(PagamentoEstagio.PAG_INFORMANDO_DADOS_ADICIONAIS);
        if (this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.BOLETO_BANCARIO.getCodigo())) {
            this.mostraTitulosParcelas();
        } else if (this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CHEQUE.getCodigo())) {
            this.adicionaPagamento();
        } else if (this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CREDITO_LOJA.getCodigo())) {
            this.mostraTitulosParcelas();
        } else if (this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.DUPLICATA.getCodigo())) {
            this.mostraTitulosParcelas();
        } else if (this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.OUTROS.getCodigo())) {
            this.mostraTitulosParcelas();
        } else {
            this.adicionaPagamento();
        }
        GrupoFormaPagamentoPedido.pagamentoEmAndamento = false;
    }

    void beforeInformaParcelas() {
        if ((ToolMethods.isEquals((Object)this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo(), (Object)EnumConstNFeTipoPagNFe.CREDITO_LOJA.getCodigo()) || ToolMethods.isEquals((Object)this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo(), (Object)EnumConstNFeTipoPagNFe.BOLETO_BANCARIO.getCodigo())) && this.getCurrentPagamento().getCondicoesPagamento() != null) {
            this.getCurrentPagamento().setNumeroParcelas(this.getCurrentPagamento().getCondicoesPagamento().getNumeroParcelas().shortValue());
            this.beforeInformaCondicaoPagamento();
        } else {
            this.txtOperacaoPagamento.clear();
            if (this.getCurrentPagamento().getTipoPagamentoNFe().getNumeroParcelasFixas() != null && this.getCurrentPagamento().getTipoPagamentoNFe().getNumeroParcelasFixas() > 0) {
                this.getCurrentPagamento().setNumeroParcelas(this.getCurrentPagamento().getTipoPagamentoNFe().getNumeroParcelasFixas());
                this.beforeInformaCondicaoPagamento();
            } else {
                this.lblOpPagamento.setText("Selecione o Plano/Condi\u00e7\u00e3o de Pagamento: " + this.getCurrentPagamento().getTipoPagamentoNFe().getDescricao());
                this.setEstagioPagamento(PagamentoEstagio.PAG_SELECIONANDO_CONDICAO_PAG);
                if (this.getCurrentPagamento().getCondicoesPagamento() != null && this.getCurrentPagamento().getCondicoesPagamento().getNumeroParcelas() > 0) {
                    this.setEstagioPagamento(PagamentoEstagio.PAG_INFORMANDO_PARCELAS);
                    this.txtOperacaoPagamento.setText(this.getCurrentPagamento().getCondicoesPagamento().getNumeroParcelas().toString());
                } else {
                    this.beforeInformaCondicaoPagamento();
                }
            }
            this.txtOperacaoPagamento.selectEndOfNextWord();
        }
    }

    void beforeInformaCondicaoPagamento() {
        this.txtOperacaoPagamento.clear();
        this.lblOpPagamento.setText("Selecione o Plano/Condi\u00e7\u00e3o de Pagamento: " + this.getCurrentPagamento().getTipoPagamentoNFe().getDescricao());
        this.setEstagioPagamento(PagamentoEstagio.PAG_SELECIONANDO_CONDICAO_PAG);
        if (StaticObjects.getPedidoAberto().getCondicoesPagamento() != null && StaticObjects.getPedidoAberto().getInfPagamentoPedido().isEmpty()) {
            this.afterAdicionaCondPag(StaticObjects.getPedidoAberto().getCondicoesPagamento());
        } else {
            ServiceCondicoesPagamento serviceCondicoesPagamento = Main.getBean(ServiceCondicoesPagamento.class);
            List<CondicoesPagamento> condicoes = serviceCondicoesPagamento.get(this.getCurrentPagamento().getTipoPagamentoNFe(), (short)1, StaticObjects.getPedidoAberto().getEmpresa());
            if ((condicoes = this.getCondicoesPorEmpresa(condicoes)).isEmpty()) {
                Alerts.showAlertInfo("Nenhuma condi\u00e7\u00e3o de pagamento cadastrada em Op\u00e7\u00f5es NFCe para esta empresa!");
            }
            if (condicoes.size() == 1) {
                this.afterAdicionaCondPag(condicoes.get(0));
            } else {
                this.txtOperacaoPagamento.clear();
                this.txtOperacaoPagamento.setItems(new TreeSet<CondicoesPagamento>(condicoes));
                if (this.txtOperacaoPagamento.isFocused() && this.txtOperacaoPagamento.getText() != null && this.txtOperacaoPagamento.getText().length() == 0) {
                    this.txtOperacaoPagamento.showPopupAllItems();
                }
                this.trataEnterMudancaAuto(false);
            }
        }
    }

    private void trataEnterMudancaAuto(boolean processNextEvent) {
        this.setProcessNextEvent(processNextEvent);
    }

    private void mostraTitulosParcelas() {
        if (this.getPedido().getUnidadeFatCliente() == null) {
            Alerts.showAlertInfo("Para este tipo de pagamento deve ser informado o Cliente da NFCe!");
            return;
        }
        HashMap<String, Number> h = new HashMap<String, Number>();
        h.put("vlrTitulos", this.getCurrentPagamento().getValor());
        h.put("nmrParcelas", this.getCurrentPagamento().getNumeroParcelas());
        TituloPedido tituloController = (TituloPedido)Main.get().showDialog(Controllers.TITULO_PEDIDO, h);
        if (tituloController.getTitulos() != null && !tituloController.getTitulos().isEmpty()) {
            this.getCurrentPagamento().setTitulos(tituloController.getTitulos());
            if (this.getCurrentPagamento().getTitulos() != null) {
                for (PedidoTitulo titulo : this.getCurrentPagamento().getTitulos()) {
                    titulo.setInfPagamentoPedido(this.getCurrentPagamento());
                }
                this.adicionaPagamento();
            }
        } else {
            this.beforeSelecionaTpPagamento(true);
        }
    }

    void afterInformaParcelas() {
        if (this.getCurrentPagamento() == null || this.getCurrentPagamento().getTipoPagamentoNFe() == null) {
            return;
        }
        String text = ToolString.onlyNumbers((String)this.txtOperacaoPagamento.getText());
        if (text == null || text.length() == 0) {
            return;
        }
        this.getCurrentPagamento().setNumeroParcelas(new Short(text));
        this.beforeInformaCondicaoPagamento();
    }

    private List<CondicoesPagamento> getCondicoesPorEmpresa(List<CondicoesPagamento> condicoes) {
        ArrayList<CondicoesPagamento> condEmpresa = new ArrayList<CondicoesPagamento>();
        for (CondicoesPagamento c : condicoes) {
            for (NFCeOpcoesCondPagamento opCOnd : StaticObjects.getOpcoes().getCondicoesPagamento()) {
                CondicoesPagamento c2 = opCOnd.getCondicoesPagamento();
                if (!ToolMethods.isEquals((Object)c, (Object)c2) || !ToolMethods.isEquals((Object)opCOnd.getAtivo(), (Object)1)) continue;
                condEmpresa.add(c);
            }
        }
        return condEmpresa;
    }

    public void informarCondicoesPagamento() {
        Pedido pedido = StaticObjects.getPedidoAberto();
        CondicoesPagamento c = this.setCondicaoPagamento(pedido.getUnidadeFatCliente());
        if (c != null) {
            Double valor = this.getValorPagamentoCondManual(c);
            if (valor == null || valor <= 0.0) {
                return;
            }
            this.setAcrescimoMarjoracaoCondicaoPagamento(c);
            InfPagamentoPedido n = new InfPagamentoPedido();
            n.setCondicoesPagamento(c);
            n.setMeioPagamento(c.getMeioPagamento());
            n.setTipoPagamentoNFe(c.getMeioPagamento().getTipoPagamentoNFe());
            n.setNumeroParcelas(c.getNumeroParcelas().shortValue());
            n.setValor(valor);
            this.currentPagamento = n;
            pedido.setCondicoesPagamento(c);
            pedido.setMeioPagamento(c.getMeioPagamento());
            this.getCurrentPagamento().setValorTroco(this.grupoFormas.getValorTroco(this.getCurrentPagamento()));
            this.getCurrentPagamento().setValorLiquido(this.getCurrentPagamento().getValor() - this.getCurrentPagamento().getValorTroco());
            this.beforeInformaOutrosDados();
            this.verificaSePodeRealizarPagamento(true);
        }
    }

    private CondicoesPagamento setCondicaoPagamento(UnidadeFatCliente u) {
        ServiceEntityAPI service;
        List<Object> tiposPagamentos = new ArrayList();
        if (u != null && u.getCliente().getClienteNFCeMeioPagamento() != null && !u.getCliente().getClienteNFCeMeioPagamento().isEmpty()) {
            for (ClienteNFCeMeioPagamento m : u.getCliente().getClienteNFCeMeioPagamento()) {
                if (!m.getAtivo().equals((short)1)) continue;
                tiposPagamentos.add(m.getTipoPagamentoNFe());
            }
        }
        if (tiposPagamentos.isEmpty()) {
            service = Main.getBean(ServiceTipoPagamentoNFe.class);
            tiposPagamentos = service.getAll();
        }
        service = Main.getBean(ServiceCondicoesPagamento.class);
        List condicoesPagamento = service.getAll();
        ArrayList<CondicoesPagamento> condicoesPagamentoNew = new ArrayList<CondicoesPagamento>();
        for (TipoPagamentoNFe tipoPagamentoNFe : tiposPagamentos) {
            for (CondicoesPagamento c : condicoesPagamento) {
                if (c.getMeioPagamento() == null || c.getMeioPagamento().getTipoPagamentoNFe() == null || !c.getMeioPagamento().getTipoPagamentoNFe().equals(tipoPagamentoNFe)) continue;
                condicoesPagamentoNew.add(c);
            }
        }
        ArrayList<CondicoesPagamento> lista = new ArrayList<CondicoesPagamento>();
        for (NFCeOpcoesCondPagamento cond : StaticObjects.getOpcoes().getCondicoesPagamento()) {
            for (CondicoesPagamento condNew : condicoesPagamentoNew) {
                if (!ToolMethods.isEquals((Object)cond.getCondicoesPagamento(), (Object)condNew) || !ToolMethods.isEquals((Object)cond.getAtivo(), (Object)1)) continue;
                lista.add(cond.getCondicoesPagamento());
            }
        }
        if (!lista.isEmpty()) {
            return UtilShowDialogTable.getCondicaoPagamento(lista);
        }
        return null;
    }

    private Double getValorPagamentoCondManual(CondicoesPagamento c) {
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("label", this.getDescricaoLabelPag(c));
        DialogDoubleField d = (DialogDoubleField)Main.get().showDialog(Controllers.DIALOG_DOUBLE_FIELD, h);
        if (d.getValorInformado() != null && d.getValorInformado() > 0.0) {
            if (!c.getMeioPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo()) && !c.getMeioPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CHEQUE.getCodigo()) && d.getValorInformado() > this.getValorFalta()) {
                return this.getValorPagamentoCondManual(c);
            }
            return d.getValorInformado();
        }
        return 0.0;
    }

    private String getDescricaoLabelPag(CondicoesPagamento c) {
        if (!c.getMeioPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo()) && !c.getMeioPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CHEQUE.getCodigo())) {
            return "Informe um valor menor ou igual ao restante do pagamento";
        }
        return "Informe o valor do pagamento";
    }

    static enum PagamentoEstagio {
        PAG_NAO_INICIADO,
        PAG_SELECIONANDO_TIPO_PAG,
        PAG_INFORMANDO_PARCELAS,
        PAG_SELECIONANDO_CONDICAO_PAG,
        PAG_INFORMANDO_VALOR,
        PAG_INFORMANDO_DADOS_ADICIONAIS;

    }
}

