/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.formapagamento.pedido;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.dialogs.DialogComboBox;
import com.touchcomp.touchnfce.controller.formapagamento.GrupoFormaPagamento;
import com.touchcomp.touchnfce.controller.formapagamento.pedido.AuxInformaPagamentoPedido;
import com.touchcomp.touchnfce.controller.splash.impl.SplashEnvioPedido;
import com.touchcomp.touchnfce.controller.venda.StyleChangingRowFactory;
import com.touchcomp.touchnfce.exceptions.ExceptionClienteFinanceiro;
import com.touchcomp.touchnfce.exceptions.ExceptionSincronizacao;
import com.touchcomp.touchnfce.model.InfPagamentoPedido;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.NFCeOpcoesValidMeioPagamento;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.SituacaoPedidos;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.service.impl.ServiceSituacaoPedidos;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilCliente;
import com.touchcomp.touchnfce.utils.pedido.UtilPedidoCalculos;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.DoubleStream;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class GrupoFormaPagamentoPedido
extends GrupoFormaPagamento {
    private AuxInformaPagamentoPedido auxInformaPagamento;
    protected StyleChangingRowFactory<InfPagamentoPedido> rowFactory = new StyleChangingRowFactory("table-row-cell-yellow");
    @FXML
    protected TableColumn<InfPagamentoPedido, String> columnDescricao;
    @FXML
    protected TableColumn<InfPagamentoPedido, String> columnValor;
    @FXML
    protected Label lblDescontoTrib;

    @Override
    protected void initializeController(ResourceBundle rb) {
        super.initializeController(rb);
        this.atualizaCamposValores();
    }

    private Pedido getPedido() {
        return StaticObjects.getPedidoAberto();
    }

    @Override
    protected void requestFocusOnOpen() {
        this.txtOperacaoPagamento.requestFocus();
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKeyAux(KeyEvent evt) {
        switch (evt.getCode()) {
            case F8: {
                this.auxInformaPagamento.informarCondicoesPagamento();
                break;
            }
            case F1: {
                this.setTipoAcrescimo((short)0);
                this.verificaAplicacaoAcrescimo();
                break;
            }
            case F2: {
                this.setTipoAcrescimo((short)1);
                this.verificaAplicacaoAcrescimo();
                break;
            }
            case F3: {
                this.setTipoDesconto((short)0);
                this.verificaAplicacaoDescontoPedido();
                break;
            }
            case F4: {
                this.setTipoDesconto((short)1);
                this.verificaAplicacaoDescontoPedido();
                break;
            }
        }
    }

    @Override
    public void firstEscapeKey(KeyEvent evt) {
        this.cancelarPagamento();
    }

    void setFormasPagTable() {
        this.columnDescricao.setCellValueFactory(cellData -> new SimpleStringProperty(((InfPagamentoPedido)cellData.getValue()).getTipoPagamentoNFe().getDescricao()));
        this.columnDescricao.setCellFactory((Callback)new Callback<TableColumn<InfPagamentoPedido, String>, TableCell<InfPagamentoPedido, String>>(){

            public TableCell<InfPagamentoPedido, String> call(TableColumn<InfPagamentoPedido, String> param) {
                TableCell<InfPagamentoPedido, String> cell = new TableCell<InfPagamentoPedido, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(GrupoFormaPagamentoPedido.this.columnDescricao.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnValor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<InfPagamentoPedido, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<InfPagamentoPedido, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((InfPagamentoPedido)param.getValue()).getValor()));
            }
        });
        this.tableFormasPag.setItems(FXCollections.observableArrayList(this.getPedido().getInfPagamentoPedido()));
    }

    private void setDadosTextFields() {
        if (this.getPedido() != null) {
            this.tfTotalItens.setDouble(this.getPedido().getValorTotalBruto());
            this.tfTotalCompra.setDouble(this.getPedido().getValorTotalDescTrib());
            this.tfDesconto.setDouble(this.getPedido().getValorDescontoInf());
            this.tfAcrescimo.setDouble(this.getPedido().getValorDespAcessoriaInf());
        } else {
            Alerts.showAlertWarning("1 - Cheque\n2 - Cart\u00e3o de D\u00e9bito\n3 - Cart\u00e3o de Cr\u00e9dito\n4 - Dinheiro", "N\u00e3o foi encontrada nenhum pedido aberto para pagamento");
        }
    }

    private void enviaPedido() {
        this.vaiTelaSplashEnvioPedido();
    }

    private void vaiTelaSplashEnvioPedido() {
        if (!this.isValidBefore()) {
            return;
        }
        if (this.getPedido().getUnidadeFatCliente() != null) {
            try {
                this.validarLimiteFinanceiro(this.getPedido());
            }
            catch (ExceptionClienteFinanceiro ex) {
                Alerts.showAlertError("Existe ocorr\u00eancias quanto a an\u00e1lise do cliente: \n" + ex.getMessage());
                ex.printStackTrace();
                return;
            }
            catch (ExceptionSincronizacao ex) {
                Alerts.showAlertError("Erro ao realizar a an\u00e1lise do cliente, devido a problemas de conex\u00e3o: \n" + ex.getMessage());
                ex.printStackTrace();
                return;
            }
            catch (Exception ex) {
                Alerts.showAlertError("Erro ao realizar a an\u00e1lise do cliente, devido a problemas de conex\u00e3o: \n" + ex.getMessage());
                ex.printStackTrace();
                return;
            }
        }
        this.confirmSituacaoPedido();
        SplashEnvioPedido splashEnvioNFCe = new SplashEnvioPedido(this.getPedido());
        splashEnvioNFCe.show();
    }

    private boolean isValidBefore() {
        Pedido ped = this.getPedido();
        boolean ret = this.validate(ped.getInfPagamentoPedido());
        if (!ret) {
            Alerts.showAlertInfo("Informe os pagamentos.");
            return false;
        }
        Double valorPago = this.getValorPago();
        Double valorPedido = ped.getValorTotalDescTrib();
        boolean bl = ret = valorPago >= valorPedido;
        if (!ret) {
            Alerts.showAlertInfo("O valor informado dos pagamentos \u00e9 menor que o valor total do pedido.");
            return false;
        }
        return true;
    }

    protected Double getValorTroco(InfPagamentoPedido pag) {
        Double res = 0.0;
        for (InfPagamentoPedido pagamento : this.getPedido().getInfPagamentoPedido()) {
            res = res + pagamento.getValor();
        }
        res = res + pag.getValor();
        return (res = Double.valueOf(res - this.getPedido().getValorTotalDescTrib())) > 0.0 ? res : 0.0;
    }

    protected Double getValorPago() {
        DoubleStream st = this.getPedido().getInfPagamentoPedido().stream().mapToDouble(pg -> ToolFormatter.arrredondarNumero((Double)pg.getValor(), (int)2));
        return ToolFormatter.arrredondarNumero((Double)st.sum(), (int)2);
    }

    void atualizaPedido(InfPagamentoPedido pag) {
        this.getPedido().getInfPagamentoPedido().add(pag);
        this.refreshPedido();
    }

    boolean verificaMaximoPagamento() {
        double totPag = 0.0;
        for (InfPagamentoPedido pagamento : this.getPedido().getInfPagamentoPedido()) {
            totPag += pagamento.getValor().doubleValue();
        }
        if (totPag >= this.getPedido().getValorTotalDescTrib()) {
            Alerts.showAlertInfo("Pagamento do pedido j\u00e1 est\u00e1 conclu\u00eddo. Para adicionar mais um pagamento \u00e9 preciso remover um existente", "");
            return true;
        }
        return false;
    }

    void atualizaCamposValores() {
        Double dif;
        this.tfTotalCompra.setDouble(this.getPedido().getValorTotalDescTrib());
        Double res = 0.0;
        for (InfPagamentoPedido pagamento : this.getPedido().getInfPagamentoPedido()) {
            res = res + pagamento.getValor();
        }
        this.tfVlrRecebido.setDouble(res);
        this.tfTroco.setDouble(res - this.tfTotalCompra.getDouble());
        if (this.tfTroco.getDouble() >= 0.0) {
            this.tfTroco.setStyle("-fx-text-fill: #0000FF");
            this.troco.setText("Troco");
        } else {
            this.tfTroco.setStyle("-fx-text-fill: #FF0000");
            this.troco.setText("Falta");
        }
        this.lblDescontoTrib.setVisible(false);
        if (ToolMethods.isWithData((Number)this.getPedido().getValorTotalDescTrib()) && (dif = Double.valueOf(this.getPedido().getValorTotal() - this.getPedido().getValorTotalDescTrib())) > 0.0) {
            this.lblDescontoTrib.setText("Desc. Trib.: " + ToolFormatter.formataNumero((Number)dif, (int)2) + " Total c/ Desc.: " + ToolFormatter.formataNumero((Number)this.getPedido().getValorTotalDescTrib(), (int)2));
            this.lblDescontoTrib.setVisible(true);
        }
        this.tfTroco.setDouble(res - this.tfTotalCompra.getDouble());
    }

    private void refreshPedido() {
        StaticObjects.refreshPedido();
        this.setFormasPagTable();
    }

    private void adicionaPagamento(TipoPagamentoNFe tpPag) {
        if (!this.verificaMaximoPagamento() && this.isValidIniciaNovoPag()) {
            this.tableFormasPag.getSelectionModel().select(null);
            this.txtOperacaoPagamento.requestFocus();
            this.auxInformaPagamento.beforeSelecionaTpPagamento(tpPag);
        }
    }

    private void aplicaDescontoPedido(Short tipoDesconto) throws Exception {
        if (tipoDesconto == 0) {
            try {
                this.getPedido().setTipoDesconto((short)0);
                this.getPedido().setPercDescontoInf(this.tfDesconto.getDouble());
                this.calcularValores();
                this.tfDesconto.setDouble(this.getPedido().getPercDescontoInf());
                this.txtOperacaoPagamento.requestFocus();
            }
            catch (Exception e) {
                TLogger.get((Object)e).error((Throwable)e);
                Alerts.showAlertInfo(e.getMessage());
                this.getPedido().setPercDescontoInf(0.0);
                this.tfDesconto.setDouble(0.0);
                this.calcularValores();
            }
        } else if (tipoDesconto == 1) {
            try {
                this.getPedido().setTipoDesconto((short)1);
                this.getPedido().setValorDescontoInf(this.tfDesconto.getDouble());
                this.calcularValores();
                this.tfDesconto.setDouble(this.getPedido().getValorDescontoInf());
            }
            catch (Exception e) {
                TLogger.get((Object)e).error((Throwable)e);
                Alerts.showAlertInfo(e.getMessage());
                this.getPedido().setValorDescontoInf(0.0);
                this.tfDesconto.setDouble(0.0);
                this.calcularValores();
            }
        }
    }

    private void calcularValores() throws Exception {
        UtilPedidoCalculos.calcularValores(this.getPedido());
        this.atualizaCamposValores();
    }

    @Override
    public void removeDescontoAcrescimoNFCe() {
        try {
            for (ItemPedido i : this.getPedido().getItemPedido()) {
                i.setValorDesconto(0.0);
                i.setValorDespesaAcessoria(0.0);
                i.setPercDesconto(0.0);
                i.setPercDespesaAcessoria(0.0);
                i.setDescontoItem((short)0);
                i.setDespAcessItem((short)0);
            }
            this.getPedido().setValorDescontoInf(0.0);
            this.getPedido().setPercDescontoInf(0.0);
            this.getPedido().setValorDespAcessoriaInf(0.0);
            this.getPedido().setPercDespAcessoriaInf(0.0);
            this.calcularValores();
            this.tfDesconto.setDouble(0.0);
            this.tfAcrescimo.setDouble(0.0);
        }
        catch (Exception e) {
            TLogger.get((Object)e).error((Throwable)e);
            Alerts.showAlertInfo(e.getMessage());
        }
    }

    @Override
    protected boolean isPagamentoFinalizado(boolean showMessage) {
        return true;
    }

    private void aplicaAcrescimoPedido(Short tipoAcrescimo) throws Exception {
        if (tipoAcrescimo == 0) {
            try {
                this.getPedido().setPercDespAcessoriaInf(this.tfAcrescimo.getDouble());
                this.getPedido().setTipoDespAcessInf((short)0);
                this.calcularValores();
                this.tfAcrescimo.setText(this.tfAcrescimo.getText());
                this.txtOperacaoPagamento.requestFocus();
            }
            catch (Exception e) {
                TLogger.get((Object)e).error((Throwable)e);
                Alerts.showAlertInfo(e.getMessage());
                this.getPedido().setPercDespAcessoriaInf(this.tfAcrescimo.getDouble());
                this.calcularValores();
                this.tfAcrescimo.setDouble(0.0);
            }
        } else if (tipoAcrescimo == 1) {
            try {
                this.getPedido().setValorDespAcessoriaInf(this.tfAcrescimo.getDouble());
                this.getPedido().setTipoDespAcessInf((short)1);
                this.calcularValores();
                this.txtOperacaoPagamento.requestFocus();
            }
            catch (Exception e) {
                TLogger.get((Object)e).error((Throwable)e);
                Alerts.showAlertInfo(e.getMessage());
                this.getPedido().setValorDespAcessoriaInf(this.tfAcrescimo.getDouble());
                this.calcularValores();
                this.tfAcrescimo.setDouble(0.0);
            }
        }
    }

    private void setActionsButtons() {
        this.btnPreferenciaTP1.setOnAction(event -> this.adicionaPagamento((TipoPagamentoNFe)this.btnPreferenciaTP1.getUserData()));
        this.btnPreferenciaTP2.setOnAction(event -> this.adicionaPagamento((TipoPagamentoNFe)this.btnPreferenciaTP2.getUserData()));
        this.btnPreferenciaTP3.setOnAction(event -> this.adicionaPagamento((TipoPagamentoNFe)this.btnPreferenciaTP3.getUserData()));
        this.btnPreferenciaTP4.setOnAction(event -> this.adicionaPagamento((TipoPagamentoNFe)this.btnPreferenciaTP4.getUserData()));
        this.btnCondicoesPagamento.setOnAction(event -> this.auxInformaPagamento.informarCondicoesPagamento());
    }

    public void aplicaAcrescimoCondicaoPagamento(Double percMajoracao) {
        try {
            this.getPedido().setPercDespAcessoriaInf(percMajoracao);
            this.getPedido().setTipoDespAcessInf((short)0);
            this.calcularValores();
            this.tfAcrescimo.setDouble(this.getPedido().getValorDespAcessoriaInf());
        }
        catch (Exception e) {
            TLogger.get((Object)e).error((Throwable)e);
            Alerts.showAlertInfo(e.getMessage());
        }
    }

    @Override
    public void setPropertiesTablePagamentos() {
        this.tableFormasPag.setRowFactory(this.rowFactory);
        this.tableFormasPag.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }

    @Override
    public void initialize() {
        this.setActionsButtons();
        this.setDadosTextFields();
        this.setFormasPagTable();
        Platform.runLater(() -> {
            this.auxInformaPagamento = new AuxInformaPagamentoPedido(this, this.txtOperacaoPagamento, this.lblOpPagamento);
            this.auxInformaPagamento.beforeSelecionaTpPagamento(true);
            this.columnValor.setMaxWidth(300.0);
            this.columnValor.setMinWidth(200.0);
            this.columnValor.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        });
    }

    @Override
    public void voltar() {
        this.refreshPedido();
    }

    @Override
    public void aplicaDesconto(Short tipoDesconto) {
        try {
            this.aplicaDescontoPedido(tipoDesconto);
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            Alerts.showAlertInfo(e.getMessage());
        }
    }

    @Override
    public void aplicaAcrescimo(Short tipoAcrescimo) {
        try {
            this.aplicaAcrescimoPedido(tipoAcrescimo);
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            Alerts.showAlertInfo(e.getMessage());
        }
    }

    @Override
    public void enviaDocumentoFiscalEmail() {
    }

    @Override
    public void fecharDocumentoFiscal() {
        this.enviaPedido();
    }

    @Override
    public void removePagamento() {
        this.rowFactory.getStyledRowIndices().removeAll((Object[])new Integer[0]);
        InfPagamentoPedido pagamento = (InfPagamentoPedido)this.tableFormasPag.getSelectionModel().getSelectedItem();
        if (pagamento != null) {
            this.getPedido().getInfPagamentoPedido().remove(pagamento);
            this.refreshPedido();
            this.atualizaCamposValores();
            this.rowFactory.getStyledRowIndices().add((Object)this.tableFormasPag.getSelectionModel().getFocusedIndex());
            this.tableFormasPag.refresh();
            this.auxInformaPagamento.beforeSelecionaTpPagamento(true);
            this.txtOperacaoPagamento.requestFocus();
        }
    }

    private void cancelarPagamento() {
        Optional<ButtonType> resp = Alerts.showQuestion("Deseja realmente cancelar a forma de pagamento?");
        if (!resp.isPresent() || resp.get() != ButtonType.OK) {
            return;
        }
        if (this.auxInformaPagamento.currentPagamento == null) {
            return;
        }
        StaticObjects.getPedidoAberto().setCondicoesPagamento(null);
        this.auxInformaPagamento.currentPagamento = null;
        this.auxInformaPagamento.beforeSelecionaTpPagamento(true);
        this.txtOperacaoPagamento.requestFocus();
    }

    private void validarLimiteFinanceiro(Pedido pedido) throws ExceptionClienteFinanceiro, ExceptionSincronizacao, Exception {
        Double valor = 0.0;
        for (InfPagamentoPedido inf : pedido.getInfPagamentoPedido()) {
            TipoPagamentoNFe tipoPagamento = inf.getTipoPagamentoNFe();
            for (NFCeOpcoesValidMeioPagamento mp : StaticObjects.getOpcoes().getMeiosPagamentoValid()) {
                if (!mp.getAtivo().equals((short)1) || !mp.getTipoPagamentoNFe().equals(tipoPagamento)) continue;
                valor = valor + inf.getValorLiquido();
            }
        }
        if (valor > 0.0) {
            if (StaticObjects.getOpcoes().getUnidadeFatCliente() != null && ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getUnidadeFatCliente(), (Object)pedido.getUnidadeFatCliente())) {
                throw new ExceptionClienteFinanceiro("Para os meio(s) de pagamento informado(s), voc\u00ea deve informar um cliente que n\u00e3o seja o cliente informado em Consumidor Final em Op\u00e7\u00f5es NFCe.");
            }
            UtilCliente.analiseCreditoCliente(this.getPedido().getUnidadeFatCliente().getCliente(), valor);
        }
    }

    private boolean isValidIniciaNovoPag() {
        return !this.auxInformaPagamento.getEstagioPagamento().equals((Object)AuxInformaPagamentoPedido.PagamentoEstagio.PAG_NAO_INICIADO);
    }

    private void confirmSituacaoPedido() {
        SituacaoPedidos situacao = this.getPedido().getSituacaoPedidos();
        String sit = situacao == null ? "N\u00e3o Informada" : situacao.getDescricao();
        Optional<ButtonType> resp = Alerts.showQuestion("Situa\u00e7\u00e3o do Pedido: " + sit.toUpperCase() + ". Deseja continuar?");
        if (resp.get() == ButtonType.OK) {
            return;
        }
        ServiceSituacaoPedidos service = Main.getBean(ServiceSituacaoPedidos.class);
        DialogComboBox dialog = Alerts.showDialogComboBox("Selecione uma nova Situa\u00e7\u00e3o de Pedido", service.getSituacoesDisponiveis());
        if (dialog.getSelectedItem() != null) {
            this.getPedido().setSituacaoPedidos((SituacaoPedidos)dialog.getSelectedItem());
        }
    }
}

