/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.header;

import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.login.LoginController;
import com.touchcomp.touchnfce.utils.UtilImageSvg;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import org.apache.batik.transcoder.TranscoderException;

public class HeaderController
extends BaseController {
    @FXML
    private ImageView logo;
    @FXML
    private Label tfTextHeader;

    @Override
    protected void initializeController(ResourceBundle rb) {
        try {
            UtilImageSvg.generateImageFromSvg("logo_header");
            Image imageTouch = new Image((InputStream)new FileInputStream("target/classes/images/logo_header.png"));
            this.logo.setImage(imageTouch);
            this.tfTextHeader.setAlignment(Pos.CENTER);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (IOException | TranscoderException ex) {
            Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    public void setTextHeader(String text) {
        this.tfTextHeader.setStyle("-fx-font-size: 2.5em;");
        this.tfTextHeader.setText(text);
    }

    public void setVisible(boolean isVisible) {
        this.tfTextHeader.setVisible(isVisible);
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    @Override
    public void eventKey(KeyEvent evt) {
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }
}

