/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.login;

import com.touchcomp.basementorexceptions.exceptions.impl.criptografia.ExceptionCriptografia;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.impl.SplashLogin;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.Login;
import com.touchcomp.touchnfce.model.NFCeCaixa;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.UsuarioEmpresa;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import com.touchcomp.touchnfce.service.impl.ServiceEmpresa;
import com.touchcomp.touchnfce.service.impl.ServiceLogin;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeCaixa;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeControleCaixa;
import com.touchcomp.touchnfce.utils.UtilImageSvg;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.GridPane;
import org.apache.batik.transcoder.TranscoderException;
import org.springframework.stereotype.Controller;

@Controller
public class LoginController
implements Initializable {
    public static final String VIEW_PATH = "/view/login/LoginLayout.fxml";
    public static final Dimension PREF_WIDTH = new Dimension(900, 300);
    @FXML
    private Button btnEntrar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Label lblLogin;
    @FXML
    private Label lblSenha;
    @FXML
    private TextField tfLogin;
    @FXML
    private PasswordField pfSenha;
    @FXML
    private GridPane grid;
    @FXML
    private ImageView logo;

    public void initialize(URL url, ResourceBundle rb) {
        this.tfLogin.setOnAction(event -> this.pfSenha.requestFocus());
        this.btnEntrar.setOnAction(event -> {
            try {
                this.logar();
            }
            catch (ExceptionCriptografia exceptionCriptografia) {
                exceptionCriptografia.printStackTrace();
            }
        });
        this.btnCancelar.setOnAction(event -> this.cancelar());
        this.pfSenha.setOnAction(event -> {
            try {
                this.logar();
            }
            catch (ExceptionCriptografia exceptionCriptografia) {
                exceptionCriptografia.printStackTrace();
            }
        });
        this.tfLogin.setText(ConfPropertiesLoader.get().getLastLogin());
        try {
            UtilImageSvg.generateImageFromSvg("background_login");
            UtilImageSvg.generateImageFromSvg("logo_login");
            Image imageBack = new Image((InputStream)new FileInputStream("target/classes/images/background_login.png"));
            BackgroundImage myBI = new BackgroundImage(imageBack, BackgroundRepeat.REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, new BackgroundSize(this.grid.getWidth(), this.grid.getHeight(), false, false, true, false));
            this.grid.setBackground(new Background(new BackgroundImage[]{myBI}));
            Image imageTouch = new Image((InputStream)new FileInputStream("target/classes/images/logo_login.png"));
            this.logo.setImage(imageTouch);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (IOException | TranscoderException ex) {
            Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    private void cancelar() {
        System.exit(0);
    }

    public void logar() throws ExceptionCriptografia {
        Optional<UsuarioEmpresa> found;
        if (this.tfLogin.getText() == null) {
            return;
        }
        if (StaticObjects.getDadosSincronizacao() == null) {
            Alerts.showAlertError("Erro", "O sistema ainda n\u00e3o foi completamente sincronizado. Iremos sincronizar. Deve levar alguns minutos, por favor aguarde.");
            return;
        }
        ServiceLogin service = Main.getBean(ServiceLogin.class);
        ServiceEmpresa serviceEmpresa = Main.getBean(ServiceEmpresa.class);
        Login l = service.findByLoginAndSenha(this.tfLogin.getText().toUpperCase(), this.pfSenha.getText());
        Empresa empresa = (Empresa)serviceEmpresa.get(StaticObjects.getDadosSincronizacao().getIdEmpresa());
        ConfPropertiesLoader.get().adicionaProperties(ConfPropertiesLoader.LAST_LOGIN, this.tfLogin.getText());
        if (l == null || l.getUsuario() == null || l.getUsuario().getPessoa() == null) {
            StaticObjects.setUsuario(null);
            Alerts.showAlertError("Erro", "Erro ao efetuar login", "N\u00e3o foi encontrado nenhum usu\u00e1rio com os dados informados", null);
            return;
        }
        if (ToolMethods.isEquals((Object)l.getUsuario().getPessoa().getAtivo(), (Object)0)) {
            StaticObjects.setUsuario(null);
            Alerts.showAlertError("Erro", "Erro ao efetuar login", "Usu\u00e1rio inativo.", null);
            return;
        }
        StaticObjects.setUsuario(l.getUsuario());
        this.definirCaixaFiscal(l, empresa);
        if (StaticObjects.getNFCeCaixa() == null) {
            Alerts.showAlertError("Erro", "Selecione um caixa para iniciar.");
            return;
        }
        if (ToolMethods.isWithData(l.getUsuario().getEmpresas()) && !(found = l.getUsuario().getEmpresas().stream().filter(i -> ToolMethods.isEquals((Object)i.getEmpresa(), (Object)StaticObjects.getNFCeCaixa().getEmpresa())).findFirst()).isPresent()) {
            Alerts.showAlertError("Erro", "Usu\u00e1rio n\u00e3o tem acesso a esta empresa.", "Usu\u00e1rio n\u00e3o tem acesso a esta empresa.", null);
            return;
        }
        if (StaticObjects.getOpcoes() == null) {
            Alerts.showAlertError("Erro", "Op\u00e7\u00f5es NFCe n\u00e3o foram definidas para esta grupoEmpresa/caixa.");
            return;
        }
        SplashLogin splash = new SplashLogin();
        splash.show();
    }

    private void definirCaixaFiscal(Login l, Empresa empresa) {
        NFCeCaixa caixa = null;
        caixa = empresa.getEmpresaDados().getTipoEmpresa() != null && ToolMethods.isEquals((Object)String.valueOf(empresa.getEmpresaDados().getTipoEmpresa().getCodigo()), (Object)String.valueOf(6)) ? this.defineCaixa(empresa) : this.defineCaixaFixo(empresa);
        if (caixa == null) {
            return;
        }
        ServiceNFCeControleCaixa serviceContCaixa = Main.getBean(ServiceNFCeControleCaixa.class);
        NFCeControleCaixa cont = serviceContCaixa.getControleCaixaAberto(caixa);
        StaticObjects.setControleCaixa(cont);
        StaticObjects.setNFCeCaixa(caixa);
    }

    private NFCeCaixa defineCaixa(Empresa empresa) {
        ServiceNFCeCaixa service = Main.getBean(ServiceNFCeCaixa.class);
        List<NFCeCaixa> aux = service.getByIDEmpresa(empresa.getIdentificador());
        if (aux.size() == 1) {
            return aux.get(0);
        }
        return Alerts.showQuestion("Selecione um caixa para iniciar.", aux.toArray(), NFCeCaixa.class);
    }

    private NFCeCaixa defineCaixaFixo(Empresa empresa) {
        if (StaticObjects.getDadosSincronizacao().getAppConfiguradoCaixa() == 1) {
            return StaticObjects.getDadosSincronizacao().getNfCeCaixa();
        }
        NFCeCaixa sel = this.defineCaixa(empresa);
        StaticObjects.setNFCeCaixa(sel);
        StaticObjects.getDadosSincronizacao().setNfCeCaixa(sel);
        StaticObjects.getDadosSincronizacao().setAppConfiguradoCaixa((short)1);
        StaticObjects.refreshDadosSincronizacao();
        return sel;
    }
}

