/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.nfce;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.components.table.impl.PaginationTableCliente;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.ClienteNFCe;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.modeltemp.NFCeTipoNota;
import com.touchcomp.touchnfce.service.impl.ServiceNaturezaOperacao;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class EditarDadosNFCeController
extends BaseDialog {
    @FXML
    private Label lblPessoa;
    @FXML
    private Label lblTabela;
    @FXML
    private Label lblTipoFaturamento;
    @FXML
    private Label lblNaturezaOperacao;
    @FXML
    private PaginationTableCliente tablePessoas;
    @FXML
    private AnchorPane body;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnConfirmar;
    @FXML
    private TouchComboBox<NaturezaOperacao> cmbNaturezaOperacao;
    @FXML
    private TouchComboBox<NFCeTipoNota> cmbTipoFaturamento;
    private NFCe nfce;
    private UnidadeFatCliente unidadeFatClienteOld;
    private NaturezaOperacao natOperacaoOld;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.iniciaCombos();
        this.btnCancelar.setOnAction(evt -> this.cancelar());
        this.btnConfirmar.setOnAction(evt -> this.confirmar());
    }

    private void iniciaCombos() {
        ServiceNaturezaOperacao service = Main.getBean(ServiceNaturezaOperacao.class);
        this.cmbNaturezaOperacao.setItems(FXCollections.observableArrayList(service.getAllNuterezaOperacaoDisponivelNFCe(StaticObjects.getEmpresa().getIdentificador())));
        this.cmbNaturezaOperacao.setLabel(this.lblNaturezaOperacao);
        ArrayList<NFCeTipoNota> tipos = new ArrayList<NFCeTipoNota>();
        tipos.add(new NFCeTipoNota((short)0, "NFC-e (Modelo 65)", EnumConstantsModeloDocFiscal.NFCE_65.getCodigo()));
        tipos.add(new NFCeTipoNota((short)1, "NF-e (Modelo 55)", EnumConstantsModeloDocFiscal.NFE_55.getCodigo()));
        this.cmbTipoFaturamento.setItems(FXCollections.observableArrayList(tipos));
        this.cmbTipoFaturamento.setLabel(this.lblTipoFaturamento);
        this.cmbNaturezaOperacao.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> this.onChangeNaturezaOperacao((NaturezaOperacao)newValue));
        this.cmbTipoFaturamento.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> this.onChangeTipoFaturamento((NFCeTipoNota)newValue));
    }

    private void confirmar() {
        if (this.nfce.getNaturezaOperacao() == null) {
            Alerts.showAlertError("Informe a Natureza de Opera\u00e7\u00e3o!");
            return;
        }
        if (this.nfce.getUnidadeFatCliente() == null && ToolMethods.isEquals((Object)this.nfce.getNaturezaOperacao().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            Alerts.showAlertError("Cliente deve ser informado para NFe modelo 55!");
            return;
        }
        this.closeDialog();
    }

    private void cancelar() {
        this.nfce.setUnidadeFatCliente(this.unidadeFatClienteOld);
        this.nfce.setNaturezaOperacao(this.natOperacaoOld);
        this.closeDialog();
    }

    private void onChangeTipoFaturamento(NFCeTipoNota tf) {
        this.setTipoFaturamento(tf);
    }

    private void onChangeNaturezaOperacao(NaturezaOperacao n) {
        this.setNaturezaOperacao(n);
    }

    private void selectUnidadeFatCliente(UnidadeFatCliente un) {
        this.tablePessoas.setStringTextField(un.toString());
        this.nfce.setUnidadeFatCliente(un);
        Short tipoFaturamento = null;
        for (ClienteNFCe clienteNFCe : un.getCliente().getClienteNFCe()) {
            if (!ToolMethods.isEquals((Object)clienteNFCe.getEmpresa(), (Object)this.nfce.getEmpresa())) continue;
            if (ToolMethods.isEquals((Object)clienteNFCe.getTipoFaturamento(), (Object)2)) {
                return;
            }
            tipoFaturamento = clienteNFCe.getTipoFaturamento();
            break;
        }
        if (tipoFaturamento != null) {
            String codModDoc = null;
            Boolean diferente = false;
            if (ToolMethods.isEquals(tipoFaturamento, (Object)0) && ToolMethods.isEquals((Object)this.natOperacaoOld.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                this.cmbTipoFaturamento.getSelectionModel().select(0);
                codModDoc = EnumConstantsModeloDocFiscal.NFCE_65.getCodigo();
                diferente = true;
            } else if (!ToolMethods.isEquals(tipoFaturamento, (Object)0) && ToolMethods.isEquals((Object)this.natOperacaoOld.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
                this.cmbTipoFaturamento.getSelectionModel().select(1);
                codModDoc = EnumConstantsModeloDocFiscal.NFE_55.getCodigo();
                diferente = true;
            }
            if (diferente.booleanValue()) {
                List<NaturezaOperacao> list = this.findNaturezaFromTipoFaturamento(tipoFaturamento, codModDoc);
                this.cmbNaturezaOperacao.setItems(FXCollections.observableArrayList(list));
                this.cmbNaturezaOperacao.getSelectionModel().select((Object)this.nfce.getNaturezaOperacao());
            }
        }
    }

    @Override
    public void posInitialize() {
        this.nfce = (NFCe)this.getParams().get("nfce");
        this.unidadeFatClienteOld = this.nfce.getUnidadeFatCliente();
        this.natOperacaoOld = this.nfce.getNaturezaOperacao();
        this.setClienteNFCe();
        this.setTipoFaturamentoAndNatOperacao();
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAlterarClientePreVenda(), (Object)0)) {
            this.tablePessoas.setDisable(true);
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAlterarNatOperacaoPreVenda(), (Object)0)) {
            this.cmbTipoFaturamento.setDisable(true);
            this.cmbNaturezaOperacao.setDisable(true);
        }
    }

    private void setClienteNFCe() {
        LinkedList<UnidadeFatCliente> list = new LinkedList<UnidadeFatCliente>();
        if (this.nfce != null && this.nfce.getUnidadeFatCliente() != null) {
            list.add(this.nfce.getUnidadeFatCliente());
            this.tablePessoas.getTfFilter().setText(this.nfce.getUnidadeFatCliente().getPessoa().toString());
        }
        this.tablePessoas.setItemsTable(FXCollections.observableArrayList(list));
        this.tablePessoas.getTable().getSelectionModel().selectFirst();
    }

    private void setTipoFaturamentoAndNatOperacao() {
        String codModDoc = this.nfce.getModeloDocFiscal().getCodigo();
        Short tipoFaturamento = null;
        if (ToolMethods.isEquals((Object)codModDoc, (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            this.cmbTipoFaturamento.getSelectionModel().select(0);
        } else {
            this.cmbTipoFaturamento.getSelectionModel().select(1);
        }
        tipoFaturamento = ((NFCeTipoNota)this.cmbTipoFaturamento.getSelectionModel().getSelectedItem()).getIdentificador();
        List<NaturezaOperacao> list = this.findNaturezaFromTipoFaturamento(tipoFaturamento, codModDoc);
        this.cmbNaturezaOperacao.setItems(FXCollections.observableArrayList(list));
        this.cmbNaturezaOperacao.getSelectionModel().select((Object)this.nfce.getNaturezaOperacao());
    }

    @Override
    public void requestFocusOnOpen() {
        Platform.runLater(() -> this.tablePessoas.getTfFilter().requestFocus());
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F3: {
                    this.tablePessoas.getTable().getFocusModel().focus(0, (TableColumn)this.tablePessoas.getTable().getColumns().get(0));
                    this.tablePessoas.getTable().requestFocus();
                    break;
                }
                case F2: {
                    this.tablePessoas.getTable().getSelectionModel().select(null);
                    this.tablePessoas.getTfFilter().requestFocus();
                    break;
                }
                case F5: {
                    this.cmbTipoFaturamento.requestFocus();
                    break;
                }
                case F6: {
                    this.cmbNaturezaOperacao.requestFocus();
                    break;
                }
                case F7: {
                    this.tablePessoas.anterior();
                    break;
                }
                case F8: {
                    this.tablePessoas.proximo();
                    break;
                }
                case ESCAPE: {
                    this.cancelar();
                    break;
                }
                case F12: {
                    this.confirmar();
                    break;
                }
                case ENTER: {
                    UnidadeFatCliente un = (UnidadeFatCliente)this.tablePessoas.getTable().getSelectionModel().getSelectedItem();
                    if (un != null) {
                        this.selectUnidadeFatCliente(un);
                        break;
                    }
                    if (this.tablePessoas.getTfFilter().getText() == null || this.tablePessoas.getTfFilter().getText().isEmpty() || !this.tablePessoas.getTfFilter().getText().startsWith("=")) break;
                    this.tablePessoas.carregaRegistros(this.tablePessoas.getTfFilter().getText());
                    break;
                }
            }
        }
    }

    private List<NaturezaOperacao> findNaturezaFromTipoFaturamento(Short tipoFaturamento, String codModDoc) {
        ServiceNaturezaOperacao service = Main.getBean(ServiceNaturezaOperacao.class);
        List<Object> list = new ArrayList();
        if (tipoFaturamento != null) {
            if (ToolMethods.isEquals((Object)1, (Object)tipoFaturamento) || ToolMethods.isEquals((Object)3, (Object)tipoFaturamento)) {
                codModDoc = EnumConstantsModeloDocFiscal.NFE_55.getCodigo();
            }
            list = service.getNaturezaOperacaoByModDocFiscal(codModDoc, StaticObjects.getEmpresa().getIdentificador());
        } else {
            list = service.getAllNuterezaOperacaoDisponivelNFCe(StaticObjects.getEmpresa().getIdentificador());
        }
        if (list.isEmpty()) {
            throw new RuntimeException("Nenhuma Natureza de Opera\u00e7\u00e3o foi encontrada para Modelo Doc. Fiscal " + codModDoc);
        }
        return list;
    }

    private void setTipoFaturamento(NFCeTipoNota tf) {
        if (tf != null) {
            Short tipoFaturamento = tf.getIdentificador();
            List<NaturezaOperacao> list = this.findNaturezaFromTipoFaturamento(tipoFaturamento, tf.getCodigo());
            this.cmbNaturezaOperacao.setItems(FXCollections.observableArrayList(list));
            for (NaturezaOperacao natOperacao : list) {
                if (!ToolMethods.isEquals((Object)natOperacao, (Object)this.natOperacaoOld)) continue;
                this.cmbNaturezaOperacao.getSelectionModel().select((Object)natOperacao);
                this.nfce.setNaturezaOperacao(natOperacao);
                return;
            }
        }
        this.nfce.setNaturezaOperacao(null);
    }

    private void setNaturezaOperacao(NaturezaOperacao n) {
        this.nfce.setNaturezaOperacao(n);
    }
}

