/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.nfce;

import br.com.softwareexpress.sitef.JCliSiTefI;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.caixa.FechamentoCaixaController;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.controller.splash.impl.SplashCancelaNFCe;
import com.touchcomp.touchnfce.controller.splash.impl.SplashEnvioNFCeEmail;
import com.touchcomp.touchnfce.controller.splash.impl.SplashImpressaoComprovantePIX;
import com.touchcomp.touchnfce.controller.splash.impl.SplashImpressaoComprovanteTEF;
import com.touchcomp.touchnfce.controller.splash.impl.SplashImpressaoComprovanteTransacaoGerencial;
import com.touchcomp.touchnfce.controller.splash.impl.SplashImpressaoDanfce;
import com.touchcomp.touchnfce.controller.splash.impl.SplashTEFTransacaoGerencial;
import com.touchcomp.touchnfce.helpers.nfcesefaz.HelperNFCeSefaz;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeLoteNotas;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.print.impl.PrintDuplicataDuasVias;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.tasks.utils.UtilEnviaNFCeWebService;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import com.touchcomp.touchnfce.utils.UtilXML;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import com.touchcomp.touchnfce.utils.sitef.UtilSitefTransacaoGerencial;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Callback;

public class PesquisaNFCeController
extends BaseController {
    @FXML
    private Label lblBusca;
    @FXML
    private Label lblFocusCampoBusca;
    @FXML
    private Label lblTabela;
    @FXML
    private TouchTextField tfCampoBusca;
    @FXML
    private TableView<NFCe> tableNotas;
    @FXML
    private TableColumn<NFCe, String> columnCliente;
    @FXML
    private TableColumn<NFCe, String> columnDataEmissao;
    @FXML
    private TableColumn<NFCe, String> columnNumero;
    @FXML
    private TableColumn<NFCe, String> columnValor;
    @FXML
    private TableColumn<NFCe, String> columnStatus;
    @FXML
    private TableColumn<NFCe, String> columnMotivo;
    @FXML
    private TableColumn<NFCe, String> columnTipoDoc;
    @FXML
    private Button btnVoltar;
    @FXML
    private Button btnSelecionarNFCe;
    @FXML
    private Button btnImprimirNfce;
    @FXML
    private Button btnEnviarNfceEmail;
    @FXML
    private Button btnCancelarNFCe;
    @FXML
    private Button btnImprimirDuplicata;
    @FXML
    private Button btnDesvincularAbastecimento;
    @FXML
    private Button btnExportarXML;
    @FXML
    private Button btnClonarDocumento;
    @FXML
    private Button btnMarcarSincronizacao;
    @FXML
    private Button btnAtualizarXML;
    @FXML
    private Button btnConsultarNFCe;
    @FXML
    private AnchorPane body;
    private List<NFCe> filterElements = new LinkedList<NFCe>();

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.tableNotas.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.btnVoltar.setOnAction(event -> this.vaiTelaVenda());
        this.btnClonarDocumento.setOnAction(event -> this.clonarNFCe());
        this.btnAtualizarXML.setOnAction(event -> this.atualizarXML());
        this.btnConsultarNFCe.setOnAction(event -> this.consultarNFCe());
        this.btnSelecionarNFCe.setOnAction(event -> this.selecionaNFCe());
        this.btnExportarXML.setOnAction(event -> this.exportarXML());
        this.btnImprimirNfce.setOnAction(event -> this.imprimeDanfe());
        this.btnImprimirDuplicata.setOnAction(event -> this.showAlertOpcaoImpressaoDuplicata());
        this.btnEnviarNfceEmail.setOnAction(event -> this.enviaNFCeEmail());
        this.btnCancelarNFCe.setOnAction(event -> this.cancelarNFCe());
        this.btnDesvincularAbastecimento.setOnAction(event -> this.desvincularNFCe());
        this.setDataAtualPesquisa();
        this.tfCampoBusca.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.length() > 3) {
                this.filterElementsTable();
            }
        });
        this.btnMarcarSincronizacao.setOnAction(event -> this.marcarSincronizacaoERP());
        this.setNotasTable();
        this.configureTable();
        this.tfCampoBusca.setLabel(this.lblBusca);
    }

    private void marcarSincronizacaoERP() {
        Optional<ButtonType> res;
        ObservableList sel = this.tableNotas.getSelectionModel().getSelectedItems();
        if (sel == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione uma NFCe para continuar!", "");
            return;
        }
        Boolean sincronizaNovamente = true;
        Optional<ButtonType> res1 = Alerts.showQuestion("Deseja marcar para sincronizar novamente (OK) ou marcar como j\u00e1 sincronizada(Cancelar)?");
        if (res1.get().equals(ButtonType.NO) || res1.get().equals(ButtonType.CANCEL)) {
            sincronizaNovamente = false;
        }
        if ((res = Alerts.showQuestion("Deseja atualizar somente a NFCe selecionada (OK) ou todas as NFCe?s (Cancelar)?")).get().equals(ButtonType.NO) || res.get().equals(ButtonType.CANCEL)) {
            sel = this.tableNotas.getItems();
            Iterator aux = sel.iterator();
            Boolean erro = false;
            ServiceNFCe service = Main.getBean(ServiceNFCe.class);
            while (aux.hasNext()) {
                try {
                    NFCe nfce = (NFCe)aux.next();
                    if (sincronizaNovamente.booleanValue()) {
                        service.updateSincManual((short)0, (short)0, nfce.getIdentificador());
                        continue;
                    }
                    service.updateSincManual((short)1, (short)1, nfce.getIdentificador());
                }
                catch (Exception e) {
                    erro = true;
                    e.printStackTrace();
                    Alerts.showAlertInfo("Erro ao atualizar a NFCe.\n" + e.getMessage());
                }
            }
            if (!erro.booleanValue()) {
                Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Nota Fiscal atualizada. Sincronize manualmente ou aguarde alguns instantes para sincroniza\u00e7\u00e3o autom\u00e1tica.", "");
            }
        } else {
            ServiceNFCe service = Main.getBean(ServiceNFCe.class);
            try {
                for (NFCe nfce : sel) {
                    if (sincronizaNovamente.booleanValue()) {
                        service.updateSincManual((short)0, (short)0, nfce.getIdentificador());
                    } else {
                        service.updateSincManual((short)1, (short)1, nfce.getIdentificador());
                    }
                    Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Nota Fiscal atualizada. Sincronize manualmente ou aguarde alguns instantes para sincroniza\u00e7\u00e3o autom\u00e1tica.", "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Alerts.showAlertInfo("Erro ao atualizar a NFCe.\n" + e.getMessage());
            }
        }
    }

    private void clonarNFCe() {
        boolean temp;
        NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
        if (selected == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione uma NFCe para continuar!", "");
            return;
        }
        StaticObjects.checaExcluiNFCeTemp();
        if (StaticObjects.getNfceAberta() != null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Existe uma NFCe/NFe aberta. Finalize a mesma para continuar.", "");
            return;
        }
        if (StaticObjects.getEmpresa().getEmpresaDados().getTipoEmpresa() == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Tipo de Empresa n\u00e3o definida no cadastro da empresa no ERP.", "");
            return;
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo().shortValue(), (Object)6)) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Esta op\u00e7\u00e3o n\u00e3o pode ser utilizada para Postos de Combust\u00edveis.", "");
            return;
        }
        boolean bl = temp = EnumConstNFeStatus.isStatusCancelada((Integer)selected.getStatus()) || EnumConstNFeStatus.isStatusInutilizada((Integer)selected.getStatus()) || EnumConstNFeStatus.isStatusDenegada((Integer)selected.getStatus());
        if (!temp) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Status da NFCe/NFe nao permite clone. O Status deve ser Cancelada, Inutilizada ou Denegada.", "");
            return;
        }
        NFCe gerada = null;
        try {
            gerada = UtilNFCe.clonarNFCeNovoDoc(selected);
            StaticObjects.setNfceAberta(gerada);
            StaticObjects.refreshNFCe();
            this.goBack();
        }
        catch (Exception e) {
            e.printStackTrace();
            Alerts.showAlertInfo("Erro ao clonar a NFCe.\n" + e.getMessage());
        }
    }

    private void exportarXML() {
        NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
        if (selected == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione uma NFCe para continuar!", "");
            return;
        }
        if (selected.getXml() == null || selected.getXmlAutorizacao() == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Nota Fiscal n\u00e3o autorizada/pendende para envio.", "");
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialFileName("NFe-" + selected.getChaveNFCe() + ".xml");
        File selectedFile = fileChooser.showSaveDialog((Window)Main.get().getPrimaryStage());
        if (selectedFile == null) {
            return;
        }
        try {
            String xml = UtilXML.getXMLProcNFe(selected);
            xml = ToolString.clearSpecialCharacXMLFile((String)xml);
            StringBuilder sbb = new StringBuilder();
            sbb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");
            sbb.append(xml);
            ToolFile.writeStringInFile((File)selectedFile, (String)sbb.toString());
            Alerts.showAlertInfo("Arquivo salvo.");
        }
        catch (ExceptionIO e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            Alerts.showAlertError("Erro ao gravar o arquivo.\n" + e.getMessage());
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            Alerts.showAlertError("Erro ao gerar o XML.\n" + e.getMessage());
        }
    }

    private void desvincularNFCe() {
        NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
        if (selected == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione uma NFCe para continuar!", "");
            return;
        }
        HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
        h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_ABASTECIMENTO_AFERICAO);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getUsuario() == null) {
            Alerts.showAlertError("Voce nao possui autorizacao para realizar essa operacao");
            return;
        }
        boolean desv = false;
        for (NFCeItem item : selected.getItens()) {
            if (item.getPreAbastecimento() == null) continue;
            item.setPreAbastecimento(null);
            desv = true;
        }
        UtilCentralAbastecimento.get().setItemNTAbastCanc(true);
        if (!desv) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "N\u00e3o existe abastecimentos vinculados a esta nota.", "");
            return;
        }
        UtilPermissaoUsuario.createAndAddLogNotExists(loginController.getUsuario(), EnumConstNFCeTipoAutenticacao.AUTENTICACAO_LIBERACAO_FINANCEIRA_CLIENTE, selected, null);
        if (desv) {
            selected.setStatusSincERP((short)0);
            ServiceNFCe service = Main.getBean(ServiceNFCe.class);
            service.save(selected);
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Abastecimentos desvinculados.", "");
            UtilCentralAbastecimento.get().setItemNTAbastCanc(true);
            this.goBack();
            return;
        }
    }

    @Override
    protected void requestFocusOnOpen() {
        this.tfCampoBusca.requestFocus();
    }

    private void imprimeDanfe() {
        NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
        if (selected == null) {
            Alerts.showAlertInfo("Nenhuma NFCe selecionada.");
            return;
        }
        SplashImpressaoDanfce splashImpDanfce = new SplashImpressaoDanfce(selected);
        splashImpDanfce.show();
        SplashImpressaoComprovanteTEF splashImpTEF = new SplashImpressaoComprovanteTEF(selected);
        splashImpTEF.show();
        SplashImpressaoComprovantePIX splashImpPIX = new SplashImpressaoComprovantePIX(selected);
        splashImpPIX.show();
    }

    private void enviaNFCeEmail() {
        NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
        if (selected == null) {
            Alerts.showAlertInfo("Nenhuma NFCe selecionada.");
            return;
        }
        if (!UtilNFCe.isStatusValidoImpressao(selected)) {
            Alerts.showAlertInfo("Status da NFCe nao permite envio. Deve estar autorizada ou em contigencia");
            return;
        }
        String todos = Alerts.showAlertInput("Se desejar, adicione outros emails alem dos definidos na NFCe(Separe por ;).");
        Object[] aux = ToolString.splitString((String)todos, (char[])new char[]{'.'});
        List outrosEmails = ToolMethods.toList((Object[])aux);
        SplashEnvioNFCeEmail splashEnvioNFCe = new SplashEnvioNFCeEmail(selected, StaticObjects.getOpcoes(), outrosEmails);
        splashEnvioNFCe.show();
    }

    private void selecionaNFCe() {
        NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
        if (selected == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione uma NFCe para continuar!", "");
            return;
        }
        if (!selected.getNfCeControleCaixa().equals(StaticObjects.getControleCaixa())) {
            Alerts.showAlertError("Erro", "Nao e possivel selecionar uma NF vinculada a outro controle de caixa.");
            return;
        }
        this.vaiTelaResumoVenda(selected);
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case DOWN: {
                if (!this.tfCampoBusca.isFocused()) break;
                this.tableNotas.requestFocus();
                this.tableNotas.getSelectionModel().selectFirst();
                break;
            }
            case F12: {
                this.selecionaNFCe();
                break;
            }
            case ESCAPE: {
                this.vaiTelaVenda();
                break;
            }
            case F3: {
                this.tableNotas.requestFocus();
                this.tableNotas.getSelectionModel().selectFirst();
                break;
            }
            case F2: {
                this.tableNotas.getSelectionModel().select(null);
                this.tfCampoBusca.requestFocus();
                break;
            }
            case F4: {
                this.imprimeDanfe();
                break;
            }
            case F7: {
                this.showAlertOpcaoImpressaoDuplicata();
                break;
            }
            case F8: {
                this.clonarNFCe();
                break;
            }
            case F9: {
                this.desvincularNFCe();
                break;
            }
            case F5: {
                this.cancelarNFCe();
                break;
            }
            case F6: {
                this.enviaNFCeEmail();
                break;
            }
            case F10: {
                this.consultarNFCe();
                break;
            }
            case F11: {
                this.atualizarXML();
                break;
            }
        }
    }

    private void confirmaCancelamentoNFCe(NFCe nfce, Usuario usuario) {
        try {
            String motivo = "";
            if (nfce.getNfCeCancelamento() != null) {
                motivo = nfce.getNfCeCancelamento().getMotivo();
            }
            if (nfce.getInutilizacaoNFe() != null) {
                motivo = nfce.getInutilizacaoNFe().getJustificativa();
            }
            if ((motivo = Alerts.showAlertInput("Informe o justificativa do cancelamento.", motivo)) == null || motivo.length() <= 15) {
                Alerts.showAlertInfo("A justificativa deve possuir ao menos 15 caracteres.");
                return;
            }
            SplashCancelaNFCe splashCancelaNFCe = new SplashCancelaNFCe();
            splashCancelaNFCe.setNfce(nfce);
            splashCancelaNFCe.setJustificativa(motivo);
            splashCancelaNFCe.setUsuario(usuario);
            splashCancelaNFCe.showAndWait();
            ServiceNFCe service = Main.getBean(ServiceNFCe.class);
            nfce = (NFCe)service.get(nfce.getIdentificador());
            if (EnumConstNFeStatus.isStatusCancelada((Integer)nfce.getStatus()) || EnumConstNFeStatus.isStatusInutilizada((Integer)nfce.getStatus())) {
                Alerts.showAlertInfo("NFCe cancelada/inutilizada com sucesso!");
                this.cancelarPagamentosCDC(nfce);
            } else if (nfce.getNfCeCancelamento() != null) {
                nfce.getNfCeCancelamento().getMotivo();
                if (nfce.getNfCeCancelamento() != null) {
                    Alerts.showAlertInfo(nfce.getNfCeCancelamento().getMotivo());
                }
            } else {
                Alerts.showAlertInfo("Nota n\u00e3o foi cancelada.");
            }
            this.tableNotas.getItems().clear();
            this.tableNotas.refresh();
            this.setDataAtualPesquisa();
            this.tfCampoBusca.textProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.length() > 3) {
                    this.filterElementsTable();
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger(PesquisaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cancelarNFCe() {
        try {
            NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
            if (selected == null) {
                Alerts.showAlertError("Erro", "Selecione uma NFCe para continuar!");
                return;
            }
            if (!selected.getNfCeControleCaixa().equals(StaticObjects.getControleCaixa())) {
                Alerts.showAlertError("Erro", "Nao e possivel cancelar uma NF vinculada a outro controle de caixa.");
                return;
            }
            if (!EnumConstNFeStatus.isStatusAutorizada((Integer)selected.getStatus())) {
                Alerts.showAlertInfo("A NFCe selecionada n\u00e3o est\u00e1 autorizada!");
                return;
            }
            Optional<ButtonType> resp = Alerts.showQuestion("Deseja realmente cancelar?");
            if (!resp.isPresent() || resp.get() != ButtonType.OK) {
                return;
            }
            if (UtilPermissaoUsuario.isPermitidoCancelarNFCeItem()) {
                this.confirmaCancelamentoNFCe(selected, StaticObjects.getUsuario());
                return;
            }
            HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
            h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_CANCELAMENTO);
            LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
            if (loginController.getUsuario() == null) {
                Alerts.showAlertError("Voce nao possui autorizacao para realizar essa operacao");
            } else {
                UtilPermissaoUsuario.createAndAddLogNotExists(loginController.getUsuario(), EnumConstNFCeTipoAutenticacao.AUTENTICACAO_CANCELAMENTO, selected, null);
                this.confirmaCancelamentoNFCe(selected, loginController.getUsuario());
            }
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertError("Erro ao realizar o cancelamento: " + ex.getMessage());
        }
    }

    private void setNotasTable() {
        this.columnCliente.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCe, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCe, String> param) {
                if (((NFCe)param.getValue()).getUnidadeFatCliente() != null) {
                    return new SimpleObjectProperty((Object)((NFCe)param.getValue()).getUnidadeFatCliente().toString());
                }
                if (((NFCe)param.getValue()).getNfCeConsumidor() != null) {
                    return new SimpleObjectProperty((Object)((NFCe)param.getValue()).getNfCeConsumidor().getNome());
                }
                return new SimpleObjectProperty((Object)"Nao informado");
            }
        });
        this.columnCliente.setCellFactory((Callback)new Callback<TableColumn<NFCe, String>, TableCell<NFCe, String>>(){

            public TableCell<NFCe, String> call(TableColumn<NFCe, String> param) {
                TableCell<NFCe, String> cell = new TableCell<NFCe, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(PesquisaNFCeController.this.columnCliente.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnDataEmissao.setCellValueFactory(cellData -> new SimpleStringProperty(ToolDate.dateToStr((Date)((NFCe)cellData.getValue()).getDataEmissao(), (String)"dd/MM/yyyy")));
        this.columnNumero.setCellValueFactory(cellData -> new SimpleStringProperty(String.valueOf(((NFCe)cellData.getValue()).getNumero())));
        this.columnStatus.setCellValueFactory(cellData -> new SimpleStringProperty(String.valueOf(((NFCe)cellData.getValue()).getStatus())));
        this.columnTipoDoc.setCellValueFactory(cellData -> new SimpleStringProperty(this.getTipoDoc((NFCe)cellData.getValue())));
        this.columnMotivo.setCellValueFactory(cellData -> new SimpleStringProperty(String.valueOf(((NFCe)cellData.getValue()).getMotivo())));
        this.columnMotivo.setCellFactory((Callback)new Callback<TableColumn<NFCe, String>, TableCell<NFCe, String>>(){

            public TableCell<NFCe, String> call(TableColumn<NFCe, String> param) {
                TableCell<NFCe, String> cell = new TableCell<NFCe, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(PesquisaNFCeController.this.columnMotivo.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnValor.setCellValueFactory(cellData -> new SimpleStringProperty(MaskField.monetaryField(((NFCe)cellData.getValue()).getTotalizadores().getValorTotalNFe())));
        this.tableNotas.setItems(FXCollections.observableArrayList(this.filterElements));
    }

    private String getTipoDoc(NFCe value) {
        if (ToolMethods.isEquals((Object)value.getNaturezaOperacao().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            return "NF-e (Modelo 55)";
        }
        if (ToolMethods.isEquals((Object)value.getNaturezaOperacao().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return "NFC-e (Modelo 65)";
        }
        return "DOC";
    }

    private void filterElementsTable() {
        this.filterElements.removeAll(this.filterElements);
        ServiceNFCe service = Main.getBean(ServiceNFCe.class);
        this.filterElements.addAll(service.getNotasPesquisa(this.tfCampoBusca.getText(), StaticObjects.getEmpresa(), StaticObjects.getNFCeCaixa()));
        this.setNotasTable();
    }

    private void vaiTelaResumoVenda(NFCe selected) {
        HashMap<String, NFCe> data = new HashMap<String, NFCe>();
        data.put("NFCe", selected);
        Main.get().mudaTela(Controllers.RESUMO_NFCe, data);
    }

    private void configureTable() {
        this.columnCliente.setMinWidth(330.0);
        this.columnDataEmissao.setMinWidth(60.0);
        this.columnTipoDoc.setMinWidth(60.0);
        this.columnNumero.setMinWidth(160.0);
        this.columnValor.setMinWidth(40.0);
        this.columnMotivo.setMinWidth(170.0);
        this.columnValor.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    private void setDataAtualPesquisa() {
        Integer day = ToolDate.dayFromDate((Date)new Date());
        Integer month = ToolDate.monthFromDate((Date)new Date());
        Integer year = ToolDate.yearFromDate((Object)new Date());
        StringBuilder sb = new StringBuilder();
        if (day < 10) {
            sb.append("0");
        }
        sb.append(day.toString());
        sb.append("/");
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month.toString());
        sb.append("/");
        sb.append(year.toString());
        this.tfCampoBusca.setText(sb.toString());
        this.filterElementsTable();
    }

    private void cancelarPagamentosCDC(NFCe nfce) {
        Boolean cancela = false;
        for (NFCePagamento n : nfce.getPagamentos()) {
            if (n.getNfcePagamentoCDC() == null || !n.getNfcePagamentoCDC().getStatus().equals((short)0) && !n.getNfcePagamentoCDC().getStatus().equals((short)1)) continue;
            cancela = true;
        }
        if (cancela.booleanValue()) {
            Alerts.showAlertInfo("Existia pagamentos de cart\u00e3o de cr\u00e9dito/d\u00e9bito para esta NFCe. Ser\u00e1 necess\u00e1rio o processo de cancelamento destes pagamentos junto a operadora!");
            HashMap<String, Integer> h = new HashMap<String, Integer>();
            h.put("modalidade", 110);
            SplashTEFTransacaoGerencial s = new SplashTEFTransacaoGerencial(h);
            s.showAndWait();
            String via1 = (String)h.get("1viaTEF");
            String via2 = (String)h.get("2viaTEF");
            JCliSiTefI j = (JCliSiTefI)h.get("jCliSiTef");
            if (via1 != null && !via1.isEmpty() || via2 != null && !via2.isEmpty()) {
                SplashImpressaoComprovanteTransacaoGerencial imp = new SplashImpressaoComprovanteTransacaoGerencial(h);
                imp.showAndWait();
            }
            if (h.get("impresso") != null && ((Boolean)h.get("impresso")).booleanValue()) {
                int retorno = new UtilSitefTransacaoGerencial().finalizarTransacaoSiTef(1, j);
                System.out.println("retorno: " + retorno);
            }
        }
    }

    private void vaiTelaVenda() {
        Main.get().mudaTela(Controllers.VENDA);
    }

    private void showAlertOpcaoImpressaoDuplicata() {
        Alert dialogoExe = new Alert(Alert.AlertType.CONFIRMATION);
        ButtonType btnCompleto = new ButtonType("Impressora Laser", ButtonBar.ButtonData.OK_DONE);
        ButtonType btnSimplificado = new ButtonType("Impressora Termica");
        ButtonType btnCancelar = new ButtonType("Cancelar");
        dialogoExe.setTitle("Imprimir Duplicata");
        dialogoExe.setHeaderText("Como deseja imprimir a duplicata");
        dialogoExe.getButtonTypes().setAll((Object[])new ButtonType[]{btnCompleto, btnSimplificado, btnCancelar});
        dialogoExe.showAndWait().ifPresent(b -> {
            block12: {
                if (b == btnCompleto) {
                    NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
                    if (selected == null) {
                        Alerts.showAlertError("Erro", "Selecione uma NFCe para continuar!");
                        return;
                    }
                    try {
                        List<NFCePagamento> pagamentos = this.printDuplicataDuasVias(selected);
                        if (pagamentos != null && !pagamentos.isEmpty()) {
                            new PrintDuplicataDuasVias().printDuplicataDuasVias(pagamentos, (short)1);
                            break block12;
                        }
                        Alerts.showAlertError("O pagamento da nota selecionada n\u00e3o \u00e9 do tipo duplicata!");
                        dialogoExe.close();
                    }
                    catch (ExceptionJasperReports | ExceptionPrint ex) {
                        Logger.getLogger(FechamentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
                        Alerts.showAlertError(ex.getMessage());
                    }
                } else if (b == btnSimplificado) {
                    NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
                    if (selected == null) {
                        Alerts.showAlertError("Erro", "Selecione uma NFCe para continuar!");
                        return;
                    }
                    try {
                        List<NFCePagamento> pagamentos = this.printDuplicataDuasVias(selected);
                        if (pagamentos != null && !pagamentos.isEmpty()) {
                            new PrintDuplicataDuasVias().printDuplicataDuasVias(pagamentos, (short)0);
                            break block12;
                        }
                        Alerts.showAlertError("O pagamento da nota selecionada n\u00e3o \u00e9 do tipo duplicata!");
                        dialogoExe.close();
                    }
                    catch (ExceptionJasperReports | ExceptionPrint ex) {
                        Logger.getLogger(FechamentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
                        Alerts.showAlertError(ex.getMessage());
                    }
                } else {
                    dialogoExe.close();
                }
            }
        });
    }

    private List<NFCePagamento> printDuplicataDuasVias(NFCe nfce) {
        ArrayList<NFCePagamento> listPagamentos = new ArrayList<NFCePagamento>();
        if (nfce.getPagamentos() != null && !nfce.getPagamentos().isEmpty()) {
            for (NFCePagamento p : nfce.getPagamentos()) {
                if (!p.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CREDITO_LOJA.getCodigo()) || !p.getStatus().equals((short)1)) continue;
                listPagamentos.add(p);
            }
        }
        return listPagamentos;
    }

    private void atualizarXML() {
        try {
            NFCe nfce = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
            if (nfce == null) {
                Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione uma NFCe para continuar!", "");
                return;
            }
            if (!EnumConstNFeStatus.isStatusAutorizada((Integer)nfce.getStatus())) {
                Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Nota Fiscal n\u00e3o autorizada/pendende para envio.", "");
                return;
            }
            if (nfce.getXml() == null) {
                if (nfce.getLoteNotas() == null) {
                    NFCeLoteNotas lote = new NFCeLoteNotas();
                    lote.setTipoAmbiente(nfce.getTipoAmbiente().shortValue());
                    lote.setVersaoNFe(nfce.getVersaoNfe());
                    lote.getNotas().add(nfce);
                    nfce.setLoteNotas(lote);
                    nfce = UtilNFCe.save(nfce);
                }
                UtilEnviaNFCeWebService.recuperarXmlNFCe(nfce);
                nfce.setStatusSincERP((short)0);
                nfce.setSincronizacaoManual((short)0);
                nfce = UtilNFCe.save(nfce);
            }
            if (nfce.getXmlAutorizacao() == null) {
                UtilEnviaNFCeWebService.recuperarXmlNFCeAutorizacao(nfce);
                nfce.setStatusSincERP((short)0);
                nfce.setSincronizacaoManual((short)0);
                nfce = UtilNFCe.save(nfce);
            }
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "XML atualizado com sucesso!", "");
        }
        catch (Exception ex) {
            Logger.getLogger(PesquisaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    private void consultarNFCe() {
        try {
            NFCe nfce = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
            if (nfce == null) {
                Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione uma NFCe para continuar!", "");
                return;
            }
            new HelperNFCeSefaz().consultarAndAtualizar(nfce);
            Alerts.showAlertInfo("Status: " + nfce.getStatus() + "-" + nfce.getMotivo());
            this.tableNotas.refresh();
            this.setDataAtualPesquisa();
            this.tfCampoBusca.textProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.length() > 3) {
                    this.filterElementsTable();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Alerts.showAlertInfo("Erro ao consultar a NFCe.\n" + ex.getMessage());
        }
    }
}

