/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.nfce;

import java.util.Collections;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class StyleChangingRowFactory<T>
implements Callback<TableView<T>, TableRow<T>> {
    private final String styleClass;
    private final ObservableList<Integer> styledRowIndices;
    private final Callback<TableView<T>, TableRow<T>> baseFactory;

    public StyleChangingRowFactory(String styleClass, Callback<TableView<T>, TableRow<T>> baseFactory) {
        this.styleClass = styleClass;
        this.baseFactory = baseFactory;
        this.styledRowIndices = FXCollections.observableArrayList();
    }

    public StyleChangingRowFactory(String styleClass) {
        this(styleClass, null);
    }

    public TableRow<T> call(TableView<T> tableView) {
        final TableRow row = this.baseFactory == null ? new TableRow() : (TableRow)this.baseFactory.call(tableView);
        row.indexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> obs, Number oldValue, Number newValue) {
                StyleChangingRowFactory.this.updateStyleClass(row);
            }
        });
        this.styledRowIndices.addListener((ListChangeListener)new ListChangeListener<Integer>(){

            public void onChanged(ListChangeListener.Change<? extends Integer> change) {
                StyleChangingRowFactory.this.updateStyleClass(row);
            }
        });
        return row;
    }

    public ObservableList<Integer> getStyledRowIndices() {
        return this.styledRowIndices;
    }

    private void updateStyleClass(TableRow<T> row) {
        ObservableList rowStyleClasses = row.getStyleClass();
        if (this.styledRowIndices.contains((Object)row.getIndex())) {
            if (!rowStyleClasses.contains((Object)this.styleClass)) {
                row.getStyleClass().add((Object)this.styleClass);
            }
        } else {
            rowStyleClasses.removeAll(Collections.singleton(this.styleClass));
        }
    }
}

