/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.nfce;

import com.touchcomp.basementor.constants.enums.EnumConstPercentualValor;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoEmissao;
import com.touchcomp.basementorclientwebservices.nfe.model.env.lotefat.NFeLoteFaturamento;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchButton;
import com.touchcomp.touchnfce.components.TouchCheckBox;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchRadioButton;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.splash.impl.SplashReconstruirNFCe;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeChequeTerceiros;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemCofins;
import com.touchcomp.touchnfce.model.NFCeItemICMS;
import com.touchcomp.touchnfce.model.NFCeItemIpi;
import com.touchcomp.touchnfce.model.NFCeItemPis;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.NFCeTitulo;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.nfe.AuxEnviaNota;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConstNFeVersoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.UtilNfeSendWebServices;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.tasks.utils.UtilXMLFile;
import com.touchcomp.touchnfce.utils.MaskField;
import java.awt.Desktop;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class VisualizarNFCe
extends BaseController {
    @FXML
    private Label lblNaturezaOperacao;
    @FXML
    private Label lblCliente;
    @FXML
    private Label lblPessoaAutorizada;
    @FXML
    private Label lblCondicoesPagamento;
    @FXML
    private Label lblMeioPagamento;
    @FXML
    private Label lblSerie;
    @FXML
    private Label lblNrNota;
    @FXML
    private Label lblDataHoraEmissao;
    @FXML
    private Label lblDataHoraSaida;
    @FXML
    private Label lblChave;
    @FXML
    private Label lblTipoFrete;
    @FXML
    private Label lblTransportador;
    @FXML
    private Label lblValorFreteItem;
    @FXML
    private Label lblVrIcmsFCB;
    @FXML
    private Label lblNrItem;
    @FXML
    private Label lblProduto;
    @FXML
    private Label lblVrUnitario;
    @FXML
    private Label lblQuantidadeTotal;
    @FXML
    private Label lblValorTotal;
    @FXML
    private Label lblModeloFiscal;
    @FXML
    private Label lblCfop;
    @FXML
    private Label lblDesconto;
    @FXML
    private Label lblVrIcmsRetido;
    @FXML
    private Label lblPercentualDesconto;
    @FXML
    private Label lblValorDesconto;
    @FXML
    private Label lblDespesasAcessorias;
    @FXML
    private Label lblPercentualDespesasAcessorias;
    @FXML
    private Label lblValorDespesasAcessorias;
    @FXML
    private Label lblFrete;
    @FXML
    private Label lblPercentualFrete;
    @FXML
    private Label lblValorFrete;
    @FXML
    private Label lblIncidenciaIcms;
    @FXML
    private Label lblModalidadeIcms;
    @FXML
    private Label lblMotivoDesoneracao;
    @FXML
    private Label lblAliquotaIcms;
    @FXML
    private Label lblPercRedBCIcms;
    @FXML
    private Label lblDiferimento;
    @FXML
    private Label lblIcmsIsento;
    @FXML
    private Label lblVrIcms;
    @FXML
    private Label lblVrBCIcms;
    @FXML
    private Label lblAliquotaFCB;
    @FXML
    private Label lblIcmsOutros;
    @FXML
    private Label lblVrIcmsOperacao;
    @FXML
    private Label lblVrIcmsFCBlblVrIcmsRetido;
    @FXML
    private Label lblIcmsDiferimento;
    @FXML
    private Label lblVrBCIcmsFCB;
    @FXML
    private Label lblVrIcmsDesonerado;
    @FXML
    private Label lblIcmsTributado;
    @FXML
    private Label lblAliquotaIcmsRetido;
    @FXML
    private Label lblVrBCCalculoIcmsRetido;
    @FXML
    private Label lblAliquotaIcmsSimples;
    @FXML
    private Label lblVrIcmsSimples;
    @FXML
    private Label lblIncidenciaIpi;
    @FXML
    private Label lblClasseEnquadramento;
    @FXML
    private Label lblAliquotaIpi;
    @FXML
    private Label lblVrIpiTributado;
    @FXML
    private Label lblVrIpiIsento;
    @FXML
    private Label lblVrIpiOutros;
    @FXML
    private Label lblVrIpiIndustria;
    @FXML
    private Label lblIpiObservacao;
    @FXML
    private Label lblVrIpiComercio;
    @FXML
    private Label lblQuantidadeVendidaIpi;
    @FXML
    private Label lblIncidenciaPis;
    @FXML
    private Label lblVrBaseCalculo;
    @FXML
    private Label lblAliquotaPis;
    @FXML
    private Label lblValorPis;
    @FXML
    private Label lblAliquotaQuantidadePis;
    @FXML
    private Label lblQuantidadeVendidaPis;
    @FXML
    private Label lblIncidenciaCofins;
    @FXML
    private Label lblVrBaseCalculoCofins;
    @FXML
    private Label lblAliquotaCofins;
    @FXML
    private Label lblValorCofins;
    @FXML
    private Label lblAliquotaQuantidadeCofins;
    @FXML
    private Label lblQuantidadeVendidaCofins;
    @FXML
    private TouchTextField tfCliente;
    @FXML
    private TouchTextField tfPessoaAutorizada;
    @FXML
    private TouchTextField tfSerie;
    @FXML
    private TouchTextField tfNrNota;
    @FXML
    private TouchTextField tfDataHoraEmissao;
    @FXML
    private TouchTextField tfDataHoraSaida;
    @FXML
    private TouchTextField tfChave;
    @FXML
    private TouchTextField tfNrItem;
    @FXML
    private TouchTextField tfProduto;
    @FXML
    private TouchTextField tfCfop;
    @FXML
    private TouchTextField tfIncidenciaICMS;
    @FXML
    private TouchTextField tfModalidadeIcms;
    @FXML
    private TouchTextField tfMotivoDesoneracao;
    @FXML
    private TouchTextField tfIncidenciaIpi;
    @FXML
    private TouchTextField tfClasseEnquadramento;
    @FXML
    private TouchTextField tfIncidenciaPis;
    @FXML
    private TouchTextField tfIncidenciaCofins;
    @FXML
    private TouchDoubleField tfValorFreteItem;
    @FXML
    private TouchDoubleField tfVrUnitario;
    @FXML
    private TouchDoubleField tfQuantidadeTotal;
    @FXML
    private TouchDoubleField tfValorTotal;
    @FXML
    private TouchDoubleField tfPercentualDesconto;
    @FXML
    private TouchDoubleField tfValorDesconto;
    @FXML
    private TouchDoubleField tfPercentualDespesasAcessorias;
    @FXML
    private TouchDoubleField tfValorDespesasAcessorias;
    @FXML
    private TouchDoubleField tfPercentualFrete;
    @FXML
    private TouchDoubleField tfValorFrete;
    @FXML
    private TouchDoubleField tfAliquotaIcms;
    @FXML
    private TouchDoubleField tfPercRedBCIcms;
    @FXML
    private TouchDoubleField tfDiferimento;
    @FXML
    private TouchDoubleField tfIcmsIsento;
    @FXML
    private TouchDoubleField tfVrIcms;
    @FXML
    private TouchDoubleField tfVrBCIcms;
    @FXML
    private TouchDoubleField tfAliquotaFCB;
    @FXML
    private TouchDoubleField tfIcmsOutros;
    @FXML
    private TouchDoubleField tfVrIcmsOperacao;
    @FXML
    private TouchDoubleField tfVrIcmsFCB;
    @FXML
    private TouchDoubleField tfVrIcmsRetido;
    @FXML
    private TouchDoubleField tfVrIcmsDiferimento;
    @FXML
    private TouchDoubleField tfVrBCIcmsFCB;
    @FXML
    private TouchDoubleField tfVrIcmsDesonerado;
    @FXML
    private TouchDoubleField tfIcmsTributado;
    @FXML
    private TouchDoubleField tfAliquotaIcmsRetido;
    @FXML
    private TouchDoubleField tfVrBCCalculoIcmsRetido;
    @FXML
    private TouchDoubleField tfAliquotaIcmsSimples;
    @FXML
    private TouchDoubleField tfVrIcmsSimples;
    @FXML
    private TouchDoubleField tfAliquotaIpi;
    @FXML
    private TouchDoubleField tfVrIpiTributado;
    @FXML
    private TouchDoubleField tfVrIpiIsento;
    @FXML
    private TouchDoubleField tfVrIpiOutros;
    @FXML
    private TouchDoubleField tfVrIpiIndustria;
    @FXML
    private TouchDoubleField tfIpiObservacao;
    @FXML
    private TouchDoubleField tfVrIpiComercio;
    @FXML
    private TouchDoubleField tfQuantidadeVendidaIpi;
    @FXML
    private TouchDoubleField tfAliquotaPis;
    @FXML
    private TouchDoubleField tfValorPis;
    @FXML
    private TouchDoubleField tfAliquotaQuantidadePis;
    @FXML
    private TouchDoubleField tfQuantidadeVendidaPis;
    @FXML
    private TouchDoubleField tfVrBaseCalculoCofins;
    @FXML
    private TouchDoubleField tfAliquotaCofins;
    @FXML
    private TouchDoubleField tfValorCofins;
    @FXML
    private TouchDoubleField tfAliquotaQuantidadeCofins;
    @FXML
    private TouchDoubleField tfQuantidadeVendidaCofins;
    @FXML
    private TouchDoubleField tfVrBaseCalculo;
    @FXML
    private TouchRadioButton rbPercentualDesconto;
    @FXML
    private TouchRadioButton rbValorDesconto;
    @FXML
    private TouchRadioButton rbPercentualDespesasAcessorias;
    @FXML
    private TouchRadioButton rbValorDespesasAcessorias;
    @FXML
    private TouchRadioButton rbPercentualFrete;
    @FXML
    private TouchRadioButton rbValorFrete;
    @FXML
    private TabPane tabPaneDados;
    @FXML
    private TabPane tabOpcoesItem;
    @FXML
    private Tab tabDadosGerais;
    @FXML
    private Tab tabTransportador;
    @FXML
    private Tab tabItens;
    @FXML
    private Tab tabValorAcessorios;
    @FXML
    private Tab tabIcms;
    @FXML
    private Tab tabIpi;
    @FXML
    private Tab tabPis;
    @FXML
    private Tab tabCofins;
    @FXML
    private Tab tabPagamentos;
    @FXML
    private TouchComboBox cmbNaturezaOperacao;
    @FXML
    private TouchComboBox cmbCondicoesPagamento;
    @FXML
    private TouchComboBox cmbMeioPagamento;
    @FXML
    private TouchComboBox cmbTipoFrete;
    @FXML
    private TouchComboBox cmbTransportador;
    @FXML
    private TouchComboBox cmbModeloFiscal;
    @FXML
    private TableView<NFCeChequeTerceiros> tableCheques;
    @FXML
    private TableView<NFCeItem> tableItens;
    @FXML
    private TableView<NFCePagamento> tablePagamentos;
    @FXML
    private TableView<NFCeTitulo> tableTitulos;
    @FXML
    private TouchCheckBox chItemCancelado;
    private TableColumn<NFCeChequeTerceiros, String> columnFavorecido;
    private TableColumn<NFCeChequeTerceiros, String> columnNrCheque;
    private TableColumn<NFCeChequeTerceiros, String> columnAgencia;
    private TableColumn<NFCeChequeTerceiros, String> columnConta;
    private TableColumn<NFCeChequeTerceiros, String> columnValorCheque;
    private TableColumn<NFCeChequeTerceiros, String> columnDataVencimentoCheque;
    @FXML
    private TableColumn<NFCeItem, String> columnItens;
    private TableColumn<NFCePagamento, String> columnMeioPagamento;
    private TableColumn<NFCePagamento, String> columnValorBruto;
    private TableColumn<NFCePagamento, String> columnValorTroco;
    private TableColumn<NFCePagamento, String> columnValorLiquido;
    private TableColumn<NFCeTitulo, String> columnCliente;
    private TableColumn<NFCeTitulo, String> columnDataEmissao;
    private TableColumn<NFCeTitulo, String> columnDataVencimento;
    private TableColumn<NFCeTitulo, String> columnValor;
    @FXML
    private TableColumn columnPagamentos;
    @FXML
    private TableColumn columnTitulos;
    @FXML
    private TableColumn columnCheques;
    @FXML
    private TouchButton btnGerarXml;
    @FXML
    private TouchButton btnVoltar;
    @FXML
    private TouchButton btnReconstruir;
    ToggleGroup groupDesconto = new ToggleGroup();
    ToggleGroup groupDespesasAcessorias = new ToggleGroup();
    ToggleGroup groupFrete = new ToggleGroup();
    private NFCe nfce;
    private final TLogger logger = TLogger.get(VisualizarNFCe.class);
    private final ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.btnVoltar.setOnAction(evt -> Main.get().mudaTela(Controllers.CONSISTENCIA_NFCE));
        this.btnGerarXml.setOnAction(evt -> this.gerarXmlSemValidade());
        this.btnReconstruir.setOnAction(evt -> this.reconstruirNFCe());
    }

    @Override
    public void paramsData(Class<? extends BaseController> aClass, Map data) {
        this.nfce = (NFCe)data.get("NFCe");
        this.iniciaColunas();
        this.setLabelComponents();
        this.setStyleComponents();
        this.setPropertiesComponents();
        this.setDadosNFCe(this.nfce);
    }

    private void setDadosNFCe(NFCe nfce) {
        this.cmbNaturezaOperacao.setItems(FXCollections.observableArrayList(Arrays.asList(nfce.getNaturezaOperacao())));
        this.cmbNaturezaOperacao.getSelectionModel().selectFirst();
        this.cmbCondicoesPagamento.setItems(FXCollections.observableArrayList(Arrays.asList(nfce.getCondicoesPagamento())));
        this.cmbCondicoesPagamento.getSelectionModel().selectFirst();
        if (nfce.getCondicoesPagamento() != null) {
            this.cmbMeioPagamento.setItems(FXCollections.observableArrayList(Arrays.asList(nfce.getCondicoesPagamento().getMeioPagamento())));
            this.cmbMeioPagamento.getSelectionModel().selectFirst();
        }
        if (nfce.getUnidadeFatCliente() != null) {
            Object cliente = "";
            cliente = nfce.getUnidadeFatCliente().getCliente().getCodigoCliente() != null && !nfce.getUnidadeFatCliente().getCliente().getCodigoCliente().isEmpty() ? (String)cliente + nfce.getUnidadeFatCliente().getCliente().getCodigoCliente() : (String)cliente + nfce.getUnidadeFatCliente().getCliente().getIdentificador();
            cliente = (String)cliente + " - " + nfce.getUnidadeFatCliente().getCliente().toString();
            this.tfCliente.setText((String)cliente);
        } else if (nfce.getNfCeConsumidor() != null) {
            this.tfCliente.setText(nfce.getNfCeConsumidor().toString());
        } else {
            this.tfCliente.setText("");
        }
        if (nfce.getPessoaAutorizada() != null) {
            this.tfPessoaAutorizada.setText(nfce.getPessoaAutorizada().toString());
        }
        this.tfSerie.setText(nfce.getSerie());
        this.tfNrNota.setText(nfce.getNumero().toString());
        this.tfDataHoraEmissao.setText(ToolDate.dateToStr((Date)nfce.getDataEmissao(), (String)"dd/MM/yyyy"));
        this.tfDataHoraSaida.setText(ToolDate.dateToStr((Date)nfce.getDataPrevSaida(), (String)"dd/MM/yyyy"));
        this.tfChave.setText(nfce.getChaveNFCe());
        if (nfce.getDadosTransporte() != null) {
            this.cmbTipoFrete.setItems(FXCollections.observableArrayList(Arrays.asList(nfce.getDadosTransporte().getTipoFrete())));
            this.cmbTipoFrete.getSelectionModel().selectFirst();
            this.cmbTransportador.setItems(FXCollections.observableArrayList(Arrays.asList(nfce.getDadosTransporte().getTransportador())));
            this.cmbTransportador.getSelectionModel().selectFirst();
            if (this.cmbTransportador.getSelectionModel().getSelectedItem() != null) {
                this.cmbTransportador.setTooltip(new Tooltip(this.cmbTransportador.getSelectionModel().getSelectedItem().toString()));
            }
            this.tfValorFrete.setDouble(nfce.getDadosTransporte().getValorFrete());
        }
        this.setItensNFCe(nfce);
        this.setPagamentosTable(nfce.getPagamentos());
    }

    private void setItensNFCe(NFCe nfce) {
        this.columnItens.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeItem)cellData.getValue()).getProduto().getNome()));
        this.columnItens.setCellFactory((Callback)new Callback<TableColumn<NFCeItem, String>, TableCell<NFCeItem, String>>(){

            public TableCell<NFCeItem, String> call(TableColumn<NFCeItem, String> param) {
                TableCell<NFCeItem, String> cell = new TableCell<NFCeItem, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item);
                            this.text.setWrappingWidth(VisualizarNFCe.this.columnItens.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.tableItens.setOnKeyPressed(evt -> {
            switch (evt.getCode()) {
                case DOWN: {
                    Platform.runLater(() -> this.setDadosItem((NFCeItem)this.tableItens.getSelectionModel().getSelectedItem()));
                    break;
                }
                case UP: {
                    Platform.runLater(() -> this.setDadosItem((NFCeItem)this.tableItens.getSelectionModel().getSelectedItem()));
                }
            }
        });
        this.tableItens.setOnMouseClicked(evt -> Platform.runLater(() -> this.setDadosItem((NFCeItem)this.tableItens.getSelectionModel().getSelectedItem())));
        this.tableItens.setItems(FXCollections.observableArrayList(nfce.getItens()));
        this.tablePagamentos.setOnKeyPressed(evt -> {
            switch (evt.getCode()) {
                case DOWN: {
                    this.setTitulosTable(((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getTitulos());
                    this.setChequesTable(((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getChequeTerceiros());
                    break;
                }
                case UP: {
                    this.setTitulosTable(((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getTitulos());
                    this.setChequesTable(((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getChequeTerceiros());
                }
            }
        });
        this.tablePagamentos.setOnMouseClicked(evt -> Platform.runLater(() -> {
            if (((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getTitulos() != null && !((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getTitulos().isEmpty()) {
                this.setTitulosTable(((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getTitulos());
            } else {
                this.tableTitulos.getItems().clear();
            }
            if (((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getChequeTerceiros() != null && !((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getChequeTerceiros().isEmpty()) {
                this.setChequesTable(((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getChequeTerceiros());
            } else {
                this.tableCheques.getItems().clear();
            }
        }));
    }

    private void setDadosItem(NFCeItem item) {
        Platform.runLater(() -> {
            this.tfProduto.setText(item.getProduto().getNome());
            this.tfNrItem.setText(item.getNumeroItem().toString());
            this.tfVrUnitario.setDouble(item.getValorUnitarioComercial());
            this.chItemCancelado.setSelected(ToolMethods.isEquals((Object)item.getStatus(), (Object)0));
            this.tfQuantidadeTotal.setDouble(item.getQuantidadeComercial());
            this.tfValorTotal.setDouble(item.getValorTotal());
            this.cmbModeloFiscal.setItems(FXCollections.observableArrayList(Arrays.asList(item.getModeloFiscal())));
            this.cmbModeloFiscal.getSelectionModel().selectFirst();
            this.tfCfop.setText(item.getCfop().getCodigo() + " - " + item.getCfop().getDescricao());
            this.setValoresAcessorios(item);
            this.setDadosIcms(item.getIcms());
            this.setDadosIpi(item.getIpi());
            this.setDadosPis(item.getPis());
            this.setDadosCofins(item.getCofins());
        });
    }

    private void setValoresAcessorios(NFCeItem item) {
        if (ToolMethods.isEquals((Object)item.getPercValorDesconto(), (Object)EnumConstPercentualValor.PERCENTUAL.getValue())) {
            this.rbPercentualDesconto.setSelected(true);
            this.tfPercentualDesconto.setDouble(item.getPercentualDesconto());
        } else {
            this.rbValorDesconto.setSelected(true);
            this.tfValorDesconto.setDouble(item.getValorDesconto());
        }
        if (ToolMethods.isEquals((Object)item.getPercValorDespAcess(), (Object)EnumConstPercentualValor.PERCENTUAL.getValue())) {
            this.rbPercentualDespesasAcessorias.setSelected(true);
            this.tfPercentualDespesasAcessorias.setDouble(item.getPercentualDespAcess());
        } else {
            this.rbPercentualDespesasAcessorias.setSelected(true);
            this.tfPercentualDespesasAcessorias.setDouble(item.getValorDespesasAcessorias());
        }
        if (ToolMethods.isEquals((Object)item.getPercValorFrete(), (Object)EnumConstPercentualValor.PERCENTUAL.getValue())) {
            this.rbPercentualFrete.setSelected(true);
            this.tfPercentualFrete.setDouble(item.getPercentualFrete());
        } else {
            this.rbPercentualFrete.setSelected(true);
            this.tfPercentualFrete.setDouble(item.getValorFrete());
        }
    }

    private void setDadosIcms(NFCeItemICMS icms) {
        this.tfIncidenciaICMS.setText(icms.getIncidenciaIcms().toString());
        this.tfModalidadeIcms.setText(icms.getModalidadeIcms().toString());
        if (icms.getMotivoDesoneracaoIcms() != null) {
            this.tfMotivoDesoneracao.setText(icms.getMotivoDesoneracaoIcms().toString());
        }
        this.tfAliquotaIcms.setDouble(icms.getAliquotaIcms());
        this.tfPercRedBCIcms.setDouble(icms.getPercRedBCIcms());
        this.tfDiferimento.setDouble(icms.getPercDiferimento());
        this.tfVrBCIcms.setDouble(icms.getValorBcCalculoIcms());
        this.tfIcmsIsento.setDouble(icms.getValorIcmsIsento());
        this.tfVrIcms.setDouble(icms.getValorIcms());
        this.tfIcmsOutros.setDouble(icms.getValorIcmsOutros());
        this.tfAliquotaFCB.setDouble(icms.getAliquotaIcmsFundoCombPobreza());
        this.tfVrIcmsOperacao.setDouble(icms.getValoricmsOperacao());
        this.tfVrIcmsFCB.setDouble(icms.getValorIcmsFundoCombPobreza());
        this.tfVrIcmsRetido.setDouble(icms.getValorIcmsStRetido());
        this.tfAliquotaIcmsSimples.setDouble(icms.getAliquotaIcmsSimples());
        this.tfVrBCCalculoIcmsRetido.setDouble(icms.getValorBcCalculoIcmsStRetido());
        this.tfVrIcmsDiferimento.setDouble(icms.getValorIcmsDiferimento());
        this.tfVrBCIcmsFCB.setDouble(icms.getValorBcCalculoIcmsFundoCombPobreza());
        this.tfVrIcmsDesonerado.setDouble(icms.getValorIcmsDesonerado());
        this.tfIcmsTributado.setDouble(icms.getValorIcmsTributado());
        this.tfVrIcmsSimples.setDouble(icms.getValorIcmsSimples());
        this.tfAliquotaIcmsRetido.setDouble(icms.getAliquotaIcmsSTRetido());
    }

    private void setDadosIpi(NFCeItemIpi ipi) {
        this.tfIncidenciaIpi.setText(ipi.getIncidenciaIpi().toString());
        this.tfClasseEnquadramento.setText(ipi.getClasseEnqIpi().toString());
        this.tfAliquotaIpi.setDouble(ipi.getAliquota());
        this.tfVrIpiTributado.setDouble(ipi.getValorIpiTributado());
        this.tfVrIpiIsento.setDouble(ipi.getValorIpiIsento());
        this.tfVrIpiOutros.setDouble(ipi.getValorIpiOutros());
        this.tfVrIpiIndustria.setDouble(ipi.getValorIpiIndustria());
        this.tfIpiObservacao.setDouble(ipi.getValorIpiObservacao());
        this.tfVrIpiComercio.setDouble(ipi.getValorIpiComercio());
        this.tfQuantidadeVendidaIpi.setDouble(ipi.getQuantidadeVendida());
    }

    private void setDadosPis(NFCeItemPis pis) {
        this.tfIncidenciaPis.setText(pis.getIncidenciaPisCofins().toString());
        this.tfVrBaseCalculo.setDouble(pis.getValorBaseCalculo());
        this.tfAliquotaPis.setDouble(pis.getAliquota());
        this.tfValorPis.setDouble(pis.getValor());
        this.tfAliquotaQuantidadePis.setDouble(pis.getAliquotaQuantidade());
        this.tfQuantidadeVendidaPis.setDouble(pis.getQuantidadeVendida());
    }

    private void setDadosCofins(NFCeItemCofins cofins) {
        this.tfIncidenciaCofins.setText(cofins.getIncidenciaPisCofins().toString());
        this.tfVrBaseCalculoCofins.setDouble(cofins.getValorBaseCalculo());
        this.tfAliquotaCofins.setDouble(cofins.getAliquota());
        this.tfValorCofins.setDouble(cofins.getValor());
        this.tfAliquotaQuantidadeCofins.setDouble(cofins.getAliquotaQuantidade());
        this.tfQuantidadeVendidaCofins.setDouble(cofins.getQuantidadeVendida());
    }

    private void setPagamentosTable(List<NFCePagamento> pagamentos) {
        this.tablePagamentos.setItems(FXCollections.observableArrayList(pagamentos));
        Platform.runLater(() -> {
            double totalWidthTablePag = this.tablePagamentos.getWidth();
            this.columnMeioPagamento.setPrefWidth((totalWidthTablePag -= 6.0) * 64.0 / 100.0);
            this.columnValorBruto.setPrefWidth(totalWidthTablePag * 12.0 / 100.0);
            this.columnValorLiquido.setPrefWidth(totalWidthTablePag * 12.0 / 100.0);
            this.columnValorTroco.setPrefWidth(totalWidthTablePag * 12.0 / 100.0);
        });
    }

    private void setTitulosTable(List<NFCeTitulo> titulos) {
        this.tableTitulos.setItems(FXCollections.observableArrayList(titulos));
        this.tableTitulos.requestFocus();
        this.tableTitulos.getSelectionModel().selectFirst();
        Platform.runLater(() -> {
            double totalWidthTableTit = this.tableTitulos.getWidth();
            this.columnCliente.setPrefWidth((totalWidthTableTit -= 36.0) * 58.0 / 100.0);
            this.columnDataEmissao.setPrefWidth(totalWidthTableTit * 15.0 / 100.0);
            this.columnDataVencimento.setPrefWidth(totalWidthTableTit * 15.0 / 100.0);
            this.columnValor.setPrefWidth(totalWidthTableTit * 12.0 / 100.0);
        });
        this.columnDataVencimento.setStyle("-fx-alignment: CENTER;");
        this.columnDataEmissao.setStyle("-fx-alignment: CENTER;");
        this.columnValor.setStyle("-fx-alignment: TOP_RIGHT;");
    }

    private void setChequesTable(List<NFCeChequeTerceiros> cheques) {
        Platform.runLater(() -> {
            this.tableCheques.requestFocus();
            this.tableCheques.getSelectionModel().selectFirst();
            this.tableCheques.setItems(FXCollections.observableArrayList((Collection)cheques));
            double totalWidthTableCheque = this.tableCheques.getWidth();
            this.columnFavorecido.setPrefWidth(totalWidthTableCheque * 35.0 / 100.0);
            this.columnNrCheque.setPrefWidth(totalWidthTableCheque * 15.0 / 100.0);
            this.columnAgencia.setPrefWidth(totalWidthTableCheque * 14.0 / 100.0);
            this.columnConta.setPrefWidth(totalWidthTableCheque * 12.0 / 100.0);
            this.columnValorCheque.setPrefWidth(totalWidthTableCheque * 12.0 / 100.0);
            this.columnDataVencimento.setPrefWidth(totalWidthTableCheque * 12.0 / 100.0);
        });
        this.columnDataVencimento.setStyle("-fx-alignment: CENTER;");
        this.columnAgencia.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnConta.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnNrCheque.setStyle("-fx-alignment: TOP_RIGHT;");
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case ESCAPE: {
                Main.get().mudaTela(Controllers.CONSISTENCIA_NFCE);
                break;
            }
            case F1: {
                this.tabPaneDados.getSelectionModel().select((Object)this.tabDadosGerais);
                break;
            }
            case F2: {
                this.tabPaneDados.getSelectionModel().select((Object)this.tabTransportador);
                break;
            }
            case F3: {
                this.tabPaneDados.getSelectionModel().select((Object)this.tabItens);
                break;
            }
            case F4: {
                this.tabPaneDados.getSelectionModel().select((Object)this.tabPagamentos);
                this.requestFocusTablePagamentos();
                break;
            }
            case F5: {
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() == this.tabItens) {
                    this.tabOpcoesItem.getSelectionModel().select((Object)this.tabValorAcessorios);
                    break;
                }
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() != this.tabPagamentos) break;
                this.tableTitulos.getSelectionModel().select(null);
                this.tableCheques.getSelectionModel().select(null);
                break;
            }
            case F6: {
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() == this.tabItens) {
                    this.tabOpcoesItem.getSelectionModel().select((Object)this.tabIcms);
                    break;
                }
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() != this.tabPagamentos) break;
                this.tableTitulos.requestFocus();
                this.tableTitulos.getSelectionModel().selectFirst();
                break;
            }
            case F7: {
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() == this.tabItens) {
                    this.tabOpcoesItem.getSelectionModel().select((Object)this.tabIpi);
                    break;
                }
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() != this.tabPagamentos) break;
                this.tableCheques.requestFocus();
                this.tableCheques.getSelectionModel().selectFirst();
                break;
            }
            case F8: {
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() != this.tabItens) break;
                this.tabOpcoesItem.getSelectionModel().select((Object)this.tabPis);
                break;
            }
            case F9: {
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() != this.tabItens) break;
                this.tabOpcoesItem.getSelectionModel().select((Object)this.tabCofins);
                break;
            }
            case F10: {
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() != this.tabItens) break;
                this.requestFocusTableItens();
                break;
            }
            case F11: {
                if (this.tabPaneDados.getSelectionModel().getSelectedItem() != this.tabItens) break;
                Alerts.showAlertInfo(this.cmbModeloFiscal.getSelectionModel().getSelectedItem().toString());
                break;
            }
            case F12: {
                this.gerarXmlSemValidade();
            }
        }
    }

    private void requestFocusTableItens() {
        Platform.runLater(() -> {
            this.tableItens.requestFocus();
            this.tableItens.getSelectionModel().selectFirst();
            this.setDadosItem((NFCeItem)this.tableItens.getSelectionModel().getSelectedItem());
        });
    }

    private void requestFocusTablePagamentos() {
        Platform.runLater(() -> {
            this.tablePagamentos.requestFocus();
            this.tablePagamentos.getSelectionModel().selectFirst();
            this.setTitulosTable(((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getTitulos());
            this.setChequesTable(((NFCePagamento)this.tablePagamentos.getSelectionModel().getSelectedItem()).getChequeTerceiros());
        });
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    private void iniciaColunas() {
        this.columnMeioPagamento = new TableColumn("Meio Pagamento");
        this.columnValorBruto = new TableColumn("Valor Bruto");
        this.columnValorLiquido = new TableColumn("Valor L\u00edquido");
        this.columnValorTroco = new TableColumn("Valor Troco");
        this.columnMeioPagamento.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCePagamento)cellData.getValue()).getMeioPagamento().getDescricao()));
        this.columnMeioPagamento.setCellFactory((Callback)new Callback<TableColumn<NFCePagamento, String>, TableCell<NFCePagamento, String>>(){

            public TableCell<NFCePagamento, String> call(TableColumn<NFCePagamento, String> param) {
                TableCell<NFCePagamento, String> cell = new TableCell<NFCePagamento, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(VisualizarNFCe.this.columnMeioPagamento.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnValorBruto.setCellValueFactory(cellData -> new SimpleStringProperty(MaskField.monetaryField(((NFCePagamento)cellData.getValue()).getValor())));
        this.columnValorLiquido.setCellValueFactory(cellData -> new SimpleStringProperty(MaskField.monetaryField(((NFCePagamento)cellData.getValue()).getValorLiquido())));
        this.columnValorTroco.setCellValueFactory(cellData -> new SimpleStringProperty(MaskField.monetaryField(((NFCePagamento)cellData.getValue()).getValorTroco())));
        this.columnCliente = new TableColumn("Cliente");
        this.columnDataEmissao = new TableColumn("Data Emiss\u00e3o");
        this.columnDataVencimento = new TableColumn("Data Vencimento");
        this.columnValor = new TableColumn("Valor");
        this.columnCliente.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeTitulo)cellData.getValue()).getNfcePagamento().getNfce().getUnidadeFatCliente().getCliente().getPessoa().getNome()));
        this.columnCliente.setCellFactory((Callback)new Callback<TableColumn<NFCeTitulo, String>, TableCell<NFCeTitulo, String>>(){

            public TableCell<NFCeTitulo, String> call(TableColumn<NFCeTitulo, String> param) {
                TableCell<NFCeTitulo, String> cell = new TableCell<NFCeTitulo, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(VisualizarNFCe.this.columnCliente.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnDataEmissao.setCellValueFactory(cellData -> new SimpleStringProperty(ToolDate.dateToStr((Date)((NFCeTitulo)cellData.getValue()).getDataCadastro(), (String)"dd/MM/yyyy")));
        this.columnDataVencimento.setCellValueFactory(cellData -> new SimpleStringProperty(ToolDate.dateToStr((Date)((NFCeTitulo)cellData.getValue()).getDataVencimento(), (String)"dd/MM/yyyy")));
        this.columnValor.setCellValueFactory(cellData -> new SimpleStringProperty(MaskField.monetaryField(((NFCeTitulo)cellData.getValue()).getValor())));
        this.columnFavorecido = new TableColumn("Titular");
        this.columnNrCheque = new TableColumn("Nr Cheque");
        this.columnAgencia = new TableColumn("Ag\u00eancia");
        this.columnConta = new TableColumn("Conta");
        this.columnValorCheque = new TableColumn("Valor");
        this.columnDataVencimentoCheque = new TableColumn("Data Vencimento");
        this.columnFavorecido.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeChequeTerceiros)cellData.getValue()).getTitular()));
        this.columnFavorecido.setCellFactory((Callback)new Callback<TableColumn<NFCeChequeTerceiros, String>, TableCell<NFCeChequeTerceiros, String>>(){

            public TableCell<NFCeChequeTerceiros, String> call(TableColumn<NFCeChequeTerceiros, String> param) {
                TableCell<NFCeChequeTerceiros, String> cell = new TableCell<NFCeChequeTerceiros, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(VisualizarNFCe.this.columnFavorecido.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnNrCheque.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeChequeTerceiros)cellData.getValue()).getNumero().toString()));
        this.columnNrCheque.setCellFactory((Callback)new Callback<TableColumn<NFCeChequeTerceiros, String>, TableCell<NFCeChequeTerceiros, String>>(){

            public TableCell<NFCeChequeTerceiros, String> call(TableColumn<NFCeChequeTerceiros, String> param) {
                TableCell<NFCeChequeTerceiros, String> cell = new TableCell<NFCeChequeTerceiros, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(VisualizarNFCe.this.columnNrCheque.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnAgencia.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeChequeTerceiros)cellData.getValue()).getAgencia()));
        this.columnConta.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeChequeTerceiros)cellData.getValue()).getContaCorrente()));
        this.columnValorCheque.setCellValueFactory(cellData -> new SimpleStringProperty(MaskField.monetaryField(((NFCeChequeTerceiros)cellData.getValue()).getValor())));
        this.columnDataVencimentoCheque.setCellValueFactory(cellData -> new SimpleStringProperty(ToolDate.dateToStr((Date)((NFCeChequeTerceiros)cellData.getValue()).getDataVencimento(), (String)"dd/MM/yyyy")));
    }

    private void setPropertiesComponents() {
        this.tabPaneDados.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> observable, Tab oldTab, Tab newTab) {
                if (newTab == VisualizarNFCe.this.tabItens) {
                    VisualizarNFCe.this.requestFocusTableItens();
                } else if (newTab == VisualizarNFCe.this.tabPagamentos) {
                    VisualizarNFCe.this.requestFocusTablePagamentos();
                }
            }
        });
        this.rbPercentualDesconto.setToggleGroup(this.groupDesconto);
        this.rbValorDesconto.setToggleGroup(this.groupDesconto);
        this.rbPercentualDespesasAcessorias.setToggleGroup(this.groupDespesasAcessorias);
        this.rbValorDespesasAcessorias.setToggleGroup(this.groupDespesasAcessorias);
        this.rbPercentualFrete.setToggleGroup(this.groupFrete);
        this.rbValorFrete.setToggleGroup(this.groupFrete);
        this.columnPagamentos.getColumns().addAll(new Object[]{this.columnMeioPagamento, this.columnValorBruto, this.columnValorLiquido, this.columnValorTroco});
        this.columnTitulos.getColumns().addAll(new Object[]{this.columnCliente, this.columnDataEmissao, this.columnDataVencimento, this.columnValor});
        this.columnCheques.getColumns().addAll(new Object[]{this.columnFavorecido, this.columnNrCheque, this.columnAgencia, this.columnConta, this.columnValorCheque, this.columnDataVencimentoCheque});
    }

    private void setStyleComponents() {
        this.tableItens.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableItens.setStyle("-fx-table-cell-border-color: transparent;");
        this.tableCheques.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableCheques.setStyle("-fx-table-cell-border-color: transparent;");
        this.tablePagamentos.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tablePagamentos.setStyle("-fx-table-cell-border-color: transparent;");
        this.tableTitulos.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableTitulos.setStyle("-fx-table-cell-border-color: transparent;");
        this.cmbModeloFiscal.setStyle("-fx-font-size: 0.9em;");
        this.columnValorBruto.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnValorTroco.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnValorLiquido.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnValor.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnDataEmissao.setStyle("-fx-alignment: CENTER;");
        this.columnDataVencimento.setStyle("-fx-alignment: CENTER;");
        this.columnValorCheque.setStyle("-fx-alignment: TOP_RIGHT;");
        Platform.runLater(() -> {
            this.tabValorAcessorios.setStyle("-fx-pref-width: 14em;-fx-font-size: 10pt;-fx-alignment: center;");
            this.tabIcms.setStyle("-fx-pref-width: 12em;-fx-font-size: 10pt;-fx-alignment: center;");
            this.tabIpi.setStyle("-fx-pref-width: 11em;-fx-font-size: 10pt;-fx-alignment: center;");
            this.tabPis.setStyle("-fx-pref-width: 11em;-fx-font-size: 10pt;-fx-alignment: center;");
            this.tabCofins.setStyle("-fx-pref-width: 12em;-fx-font-size: 10pt;-fx-alignment: center;");
        });
    }

    private void setLabelComponents() {
        this.cmbNaturezaOperacao.setLabel(this.lblNaturezaOperacao);
        this.tfCliente.setLabel(this.lblCliente);
        this.tfPessoaAutorizada.setLabel(this.lblPessoaAutorizada);
        this.cmbCondicoesPagamento.setLabel(this.lblCondicoesPagamento);
        this.cmbMeioPagamento.setLabel(this.lblMeioPagamento);
        this.tfSerie.setLabel(this.lblSerie);
        this.tfNrNota.setLabel(this.lblNrNota);
        this.tfDataHoraEmissao.setLabel(this.lblDataHoraEmissao);
        this.tfDataHoraSaida.setLabel(this.lblDataHoraSaida);
        this.tfChave.setLabel(this.lblChave);
        this.cmbTipoFrete.setLabel(this.lblTipoFrete);
        this.cmbTransportador.setLabel(this.lblTransportador);
        this.tfValorFrete.setLabel(this.lblValorFrete);
        this.tfNrItem.setLabel(this.lblNrItem);
        this.tfProduto.setLabel(this.lblProduto);
        this.tfVrUnitario.setLabel(this.lblVrUnitario);
        this.tfQuantidadeTotal.setLabel(this.lblQuantidadeTotal);
        this.tfValorTotal.setLabel(this.lblValorTotal);
        this.cmbModeloFiscal.setLabel(this.lblModeloFiscal);
        this.tfCfop.setLabel(this.lblCfop);
        this.tfPercentualDesconto.setLabel(this.lblPercentualDesconto);
        this.tfValorDesconto.setLabel(this.lblValorDesconto);
        this.tfPercentualDespesasAcessorias.setLabel(this.lblPercentualDespesasAcessorias);
        this.tfValorDespesasAcessorias.setLabel(this.lblValorDespesasAcessorias);
        this.tfPercentualFrete.setLabel(this.lblPercentualFrete);
        this.tfValorFrete.setLabel(this.lblValorFrete);
        this.tfIncidenciaICMS.setLabel(this.lblIncidenciaIcms);
        this.tfModalidadeIcms.setLabel(this.lblModalidadeIcms);
        this.tfMotivoDesoneracao.setLabel(this.lblMotivoDesoneracao);
        this.tfAliquotaIcms.setLabel(this.lblAliquotaIcms);
        this.tfPercRedBCIcms.setLabel(this.lblPercRedBCIcms);
        this.tfDiferimento.setLabel(this.lblDiferimento);
        this.tfVrBCIcms.setLabel(this.lblVrBCIcms);
        this.tfIcmsIsento.setLabel(this.lblIcmsIsento);
        this.tfVrIcms.setLabel(this.lblVrIcms);
        this.tfAliquotaFCB.setLabel(this.lblAliquotaFCB);
        this.tfIcmsOutros.setLabel(this.lblIcmsOutros);
        this.tfVrIcmsOperacao.setLabel(this.lblVrIcmsOperacao);
        this.tfVrIcmsFCB.setLabel(this.lblVrIcmsFCB);
        this.tfVrIcmsRetido.setLabel(this.lblVrIcmsRetido);
        this.tfVrIcmsDiferimento.setLabel(this.lblIcmsDiferimento);
        this.tfVrBCIcmsFCB.setLabel(this.lblVrBCIcmsFCB);
        this.tfVrIcmsDesonerado.setLabel(this.lblVrIcmsDesonerado);
        this.tfIcmsTributado.setLabel(this.lblIcmsTributado);
        this.tfAliquotaIcmsRetido.setLabel(this.lblAliquotaIcmsRetido);
        this.tfVrBCCalculoIcmsRetido.setLabel(this.lblVrBCCalculoIcmsRetido);
        this.tfAliquotaIcmsSimples.setLabel(this.lblAliquotaIcmsSimples);
        this.tfVrIcmsSimples.setLabel(this.lblVrIcmsSimples);
        this.tfIncidenciaIpi.setLabel(this.lblIncidenciaIpi);
        this.tfClasseEnquadramento.setLabel(this.lblClasseEnquadramento);
        this.tfAliquotaIpi.setLabel(this.lblAliquotaIpi);
        this.tfVrIpiTributado.setLabel(this.lblVrIpiTributado);
        this.tfVrIpiIsento.setLabel(this.lblVrIpiIsento);
        this.tfVrIpiOutros.setLabel(this.lblVrIpiOutros);
        this.tfVrIpiIndustria.setLabel(this.lblVrIpiIndustria);
        this.tfIpiObservacao.setLabel(this.lblIpiObservacao);
        this.tfVrIpiComercio.setLabel(this.lblVrIpiComercio);
        this.tfQuantidadeVendidaIpi.setLabel(this.lblQuantidadeVendidaIpi);
        this.tfIncidenciaPis.setLabel(this.lblIncidenciaPis);
        this.tfVrBaseCalculo.setLabel(this.lblVrBaseCalculo);
        this.tfAliquotaPis.setLabel(this.lblAliquotaPis);
        this.tfValorPis.setLabel(this.lblValorPis);
        this.tfAliquotaQuantidadePis.setLabel(this.lblAliquotaQuantidadePis);
        this.tfQuantidadeVendidaPis.setLabel(this.lblQuantidadeVendidaPis);
        this.tfIncidenciaCofins.setLabel(this.lblIncidenciaCofins);
        this.tfVrBaseCalculoCofins.setLabel(this.lblVrBaseCalculoCofins);
        this.tfAliquotaCofins.setLabel(this.lblAliquotaCofins);
        this.tfValorCofins.setLabel(this.lblValorCofins);
        this.tfAliquotaQuantidadeCofins.setLabel(this.lblAliquotaQuantidadeCofins);
        this.tfQuantidadeVendidaCofins.setLabel(this.lblQuantidadeVendidaCofins);
    }

    private void gerarXmlSemValidade() {
        if (this.nfce != null) {
            try {
                if (this.nfce.getLoteNotas() == null) {
                    Alerts.showAlertInfo("Para gerar o XML sem validade da nota, a mesma deve possuir ao menos uma tentativa de envio!");
                    return;
                }
                NFeLoteFaturamento n = new AuxEnviaNota(StaticObjects.getOpcoes()).criarNotaEnvio(this.nfce.getLoteNotas());
                byte[] xml = UtilNfeSendWebServices.createXMLSemValidade(ConstNFeVersoes.VERSAO_20180005_1_20, n);
                File f = UtilXMLFile.saveOnFile(new String(xml), "xml_sem_validade", this.nfce.getChaveNFCe() + ".xml");
                Alerts.showAlertInfo("Xml gerado com sucesso!");
                Desktop.getDesktop().open(f.getParentFile());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Alerts.showAlertError("Erro ao gerar xml sem validade. \n" + ex.getMessage());
                this.logger.error(ex.getClass(), (Throwable)ex);
            }
        }
    }

    private void reconstruirNFCe() {
        this.atualizarDataEmissaoNFCe();
        SplashReconstruirNFCe splash = new SplashReconstruirNFCe();
        splash.setAtualizarValorProduto(this.atualizarValoresUnitarios());
        splash.setNfce(this.nfce);
        splash.showAndWait();
        this.setDadosNFCe((NFCe)this.serviceNFCe.get(this.nfce.getIdentificador()));
        this.goBack();
    }

    private void atualizarDataEmissaoNFCe() {
        int difDays = ToolDate.diferenceDayBetweenDatesUseJodaDays((Date)ToolDate.dataSemHora((Date)this.nfce.getDataEmissao()), (Date)ToolDate.dataSemHora((Date)new Date()));
        if (difDays > 0 && !ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getPermitirAlterarDataNFCe(), (Object)1)) {
            Alerts.showAlertInfo("A data de emiss\u00e3o da nota \u00e9 diferente da data atual. N\u00e3o \u00e9 permitido atualizar a data de emiss\u00e3o. A nota ser\u00e1 reconstruida.");
            return;
        }
        EnumConstantsMentorSimNao ret = Alerts.showQuestionYesNo("", "", "Deseja atualizar a data de emiss\u00e3o?", Main.get().getPrimaryStage());
        boolean show = false;
        if (ret.equals((Object)EnumConstantsMentorSimNao.SIM)) {
            this.nfce.setDataEmissao(new Date());
            show = true;
        }
        if (show && this.nfce.getDataPrevSaida() != null && this.nfce.getDataEmissao() != null && this.nfce.getDataPrevSaida().before(this.nfce.getDataEmissao())) {
            Alerts.showAlertInfo("A Data de previs\u00e3o de sa\u00edda \u00e9 menor do que a data de emiss\u00e3o. A data de previs\u00e3o de Sa\u00edda ser\u00e1 alterada para ser igual a emiss\u00e3o. Caso deseje, altere diretamente no menu de vendas a mesma.");
            this.nfce.setDataPrevSaida(this.nfce.getDataEmissao());
        }
    }

    private Boolean atualizarValoresUnitarios() {
        TipoEmissaoNFe tipoEmissao;
        TipoEmissaoNFe tipoEmissaoNFe = tipoEmissao = this.nfce.getPeriodoEmissaoNFCe() != null ? this.nfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : this.nfce.getPeriodoEmissaoNFe().getTipoEmissaoNfe();
        if (tipoEmissao.getCodigo().shortValue() == EnumConstNFeTipoEmissao.CONTIGENCIA_OFFLINE.getValue() || tipoEmissao.getCodigo().shortValue() == EnumConstNFeTipoEmissao.CONTIGENCIA_EMISSAO_FS.getValue() || tipoEmissao.getCodigo().shortValue() == EnumConstNFeTipoEmissao.CONTIGENCIA_FSDA.getValue()) {
            return false;
        }
        EnumConstantsMentorSimNao ret = Alerts.showQuestionYesNo("", "", "Deseja manter os valores unitarios atuais dos produtos?", Main.get().getPrimaryStage());
        boolean show = false;
        if (ret.equals((Object)EnumConstantsMentorSimNao.SIM)) {
            return false;
        }
        return true;
    }
}

