/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.opcoes;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.textfile.writter.ToolTextFileWritter;
import com.touchcomp.basementortools.tools.textfile.writter.model.TextLineWritter;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.TabelaPrecoBase;
import com.touchcomp.touchnfce.model.TabelaPrecoBaseProduto;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.service.impl.ServiceTabelaPrecoBase;
import java.io.File;

public class AuxValidaProdutosSemModelo {
    public void validaProdutosSemModeloNFCe(File baseDir, NFCeOpcoes nfce, NaturezaOperacao natOp) throws ExceptionIO {
        ServiceTabelaPrecoBase service = Main.getBean(ServiceTabelaPrecoBase.class);
        TabelaPrecoBase tab = service.get(nfce.getEmpresa());
        AuxModeloFiscal aux = new AuxModeloFiscal();
        ToolTextFileWritter t = new ToolTextFileWritter();
        for (TabelaPrecoBaseProduto tp : tab.getProdutos()) {
            ModeloFiscal mod = aux.getModeloFiscalNFCe(tp.getProduto(), null, null, null, natOp, nfce.getEmpresa(), false);
            TextLineWritter line = t.newLine();
            line.newReg(tab.getIdentificador());
            line.newReg(tp.getProduto().getIdentificador());
            line.newReg(tp.getProduto().getCodigoAuxiliar());
            line.newReg(tp.getProduto().getNome());
            line.newReg(tp.getProduto().getUnidadeMedida().getSigla());
            line.newReg(tp.getProduto().getUnidadeMedida().getSigla());
            line.newReg(tp.getValorVenda());
            line.newReg(natOp.getIdentificador());
            line.newReg(natOp.getDescricao());
            if (mod != null) {
                line.newReg(mod.getIdentificador());
                line.newReg(mod.getDescricao());
                continue;
            }
            line.newReg(Long.valueOf(0L));
            line.newReg("SEM MODELO FISCAL");
        }
        t.writeOnOutputStream(new File(baseDir.getAbsolutePath() + "/produtos_vs_modelos_nfce.txt"));
    }

    public void validaProdutosSemModeloNFe(File baseDir, NFCeOpcoes nfce, UnidadeFatCliente cliente, NaturezaOperacao natOp) throws ExceptionIO {
        ServiceTabelaPrecoBase service = Main.getBean(ServiceTabelaPrecoBase.class);
        TabelaPrecoBase tab = service.get(nfce.getEmpresa());
        AuxModeloFiscal aux = new AuxModeloFiscal();
        ToolTextFileWritter t = new ToolTextFileWritter();
        for (TabelaPrecoBaseProduto tp : tab.getProdutos()) {
            ModeloFiscal mod = aux.getModeloFiscalNFCe(tp.getProduto(), cliente, null, null, natOp, nfce.getEmpresa(), false);
            TextLineWritter line = t.newLine();
            line.newReg(tab.getIdentificador());
            line.newReg(tp.getProduto().getIdentificador());
            line.newReg(tp.getProduto().getCodigoAuxiliar());
            line.newReg(tp.getProduto().getNome());
            line.newReg(tp.getProduto().getUnidadeMedida().getSigla());
            line.newReg(tp.getProduto().getUnidadeMedida().getSigla());
            line.newReg(tp.getValorVenda());
            line.newReg(natOp.getIdentificador());
            line.newReg(natOp.getDescricao());
            if (mod != null) {
                line.newReg(mod.getIdentificador());
                line.newReg(mod.getDescricao());
                continue;
            }
            line.newReg(Long.valueOf(0L));
            line.newReg("SEM MODELO FISCAL");
        }
        t.writeOnOutputStream(new File(baseDir.getAbsolutePath() + "/produtos_vs_modelos_nfe.txt"));
    }
}

