/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.pessoa;

import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.pessoa.converter.TempPessoaConverter;
import com.touchcomp.touchnfce.model.Pessoa;
import com.touchcomp.touchnfce.service.impl.ServicePessoa;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class PessoaIndicanteController
extends BaseDialog
implements AutoCompleteTextField.ItemSelListener,
AutoCompleteTextField.ItemSourceFilter {
    public static final String CURRENT_PESSOA_INDICANTE = "current_pessoa_indicante";
    @FXML
    private Label lblPessoa;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnExcluirPessoa;
    @FXML
    private Button btnConfirmar;
    @FXML
    private AnchorPane body;
    @FXML
    private AutoCompleteTextField<Pessoa> tfPessoa;
    private Pessoa pessoaIndicante;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.btnConfirmar.setOnAction(evt -> this.setPessoaIndicante());
        this.btnCancelar.setOnAction(evt -> this.closeDialog());
        this.btnExcluirPessoa.setOnAction(evt -> this.excluiPessoaIndicante());
        this.tfPessoa.setLabel(this.lblPessoa);
        this.tfPessoa.setItemSelListener(this);
        this.tfPessoa.setItemSourceFilter(this);
    }

    private void currentToScreen() {
        if (StaticObjects.getPedidoAberto().getIndicante() != null) {
            this.pessoaIndicante = StaticObjects.getPedidoAberto().getIndicante();
            this.tfPessoa.setText(this.pessoaIndicante.getNome());
        }
    }

    @Override
    public void posInitialize() {
        this.currentToScreen();
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.setPessoaIndicante();
                    break;
                }
                case ESCAPE: {
                    this.closeDialog();
                    break;
                }
                case DELETE: {
                    this.excluiPessoaIndicante();
                }
            }
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfPessoa.requestFocus();
    }

    public Pessoa getPessoaIndicante() {
        return this.pessoaIndicante;
    }

    private void setPessoaIndicante() {
        if (this.pessoaIndicante != null) {
            StaticObjects.getPedidoAberto().setIndicante(this.pessoaIndicante);
            StaticObjects.refreshPedido();
            this.closeDialog();
        } else {
            Alerts.showAlertInfo("Selecione uma pessoa!", this.getStage());
        }
    }

    private void excluiPessoaIndicante() {
        if (StaticObjects.getPedidoAberto().getIndicante() != null) {
            StaticObjects.getPedidoAberto().setIndicante(null);
            Alerts.showAlertInfo("Pessoa indicante exclu\u00edda do atual pedido!", this.getStage());
            this.tfPessoa.setText("");
        } else {
            Alerts.showAlertError("Nenhuma pessoa indicante est\u00e1 vinculada a este pedido!", this.getStage());
        }
    }

    public void onItemListener(Object data) {
        TempPessoaConverter pessoaConv = (TempPessoaConverter)data;
        this.pessoaIndicante = pessoaConv.getTempPesqPessoa();
    }

    @Override
    public SortedSet onTextChange(String text) {
        ServicePessoa service = Main.getBean(ServicePessoa.class);
        if (text != null && text.trim().length() > 2) {
            List<Pessoa> pessoas = service.searchPessoa(text);
            TreeSet<TempPessoaConverter> set = TempPessoaConverter.converterList(pessoas);
            return set;
        }
        return null;
    }
}

