/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.prevenda;

import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.controller.venda.auxparamtribcbsibs.AuxParamTribCbsIbs;
import com.touchcomp.touchnfce.model.GradeCor;
import com.touchcomp.touchnfce.model.GradeItemPedido;
import com.touchcomp.touchnfce.model.InfPagamentoPedido;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.ParamTribCbsIbsClass;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.SituacaoPedidos;
import com.touchcomp.touchnfce.service.impl.ServiceGradeCor;
import com.touchcomp.touchnfce.service.impl.ServiceModeloFiscal;
import com.touchcomp.touchnfce.service.impl.ServiceParamTribCbsIbsClass;
import com.touchcomp.touchnfce.service.impl.ServiceSituacaoPedidos;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeCalculos;
import com.touchcomp.touchnfce.utils.pedido.UtilPedido;
import com.touchcomp.touchvomodel.vo.findpedidoprevenda.DTOFindPedidoPreVenda;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV10;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class ConsultarPreVenda
extends BaseController {
    @FXML
    private Label lblBusca;
    @FXML
    private Label lblFocusCampoBusca;
    @FXML
    private Label lblTabela;
    @FXML
    private TextField tfCampoBusca;
    @FXML
    private TableView<DTOFindPedidoPreVenda> tablePedidos;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnCliente;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnIdPedido;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnCodCliente;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnDataCadastro;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnValorTot;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnSitPedido;
    @FXML
    private Button btnVoltar;
    @FXML
    private Button btnGerarNfce;
    @FXML
    private AnchorPane body;
    private TLogger logger = TLogger.get(ConsultarPreVenda.class);

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.setOnActionButtons();
        this.tablePedidos.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.configureTable();
        this.setDataAtualPesquisa();
        this.tfCampoBusca.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    ConsultarPreVenda.this.filterElementsTable();
                }
            }
        });
    }

    private void configureTable() {
        this.columnIdPedido.setMinWidth(40.0);
        this.columnCodCliente.setMinWidth(40.0);
        this.columnCliente.setMinWidth(300.0);
        this.columnSitPedido.setMinWidth(200.0);
        this.columnDataCadastro.setMinWidth(70.0);
        this.columnValorTot.setMinWidth(80.0);
        this.columnIdPedido.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columnCodCliente.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columnDataCadastro.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columnValorTot.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    private void setOnActionButtons() {
        this.btnGerarNfce.setOnAction(evt -> this.gerarNfce());
        this.btnVoltar.setOnAction(evt -> Main.get().mudaTela(Controllers.VENDA));
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case DOWN: {
                if (!this.tfCampoBusca.isFocused()) break;
                this.tablePedidos.requestFocus();
                break;
            }
            case F12: {
                this.gerarNfce();
                break;
            }
            case ESCAPE: {
                Main.get().mudaTela(Controllers.VENDA);
                break;
            }
            case F3: {
                this.tablePedidos.requestFocus();
                this.tablePedidos.getSelectionModel().selectFirst();
                break;
            }
            case F2: {
                this.tablePedidos.getSelectionModel().select(null);
                this.tfCampoBusca.requestFocus();
                break;
            }
        }
    }

    private void setPedidosTable(List<DTOFindPedidoPreVenda> result) {
        this.columnIdPedido.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String> param) {
                return new SimpleObjectProperty((Object)(String.valueOf(((DTOFindPedidoPreVenda)param.getValue()).getIdentificador()) + "/" + (((DTOFindPedidoPreVenda)param.getValue()).getSerialForSync() != null ? ((DTOFindPedidoPreVenda)param.getValue()).getSerialForSync() : "")));
            }
        });
        this.columnCodCliente.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String> param) {
                if (((DTOFindPedidoPreVenda)param.getValue()).getUnidadeFatCliente() != null) {
                    if (((DTOFindPedidoPreVenda)param.getValue()).getUnidadeFatCliente().getCliente().getCodigoCliente() != null) {
                        return new SimpleObjectProperty((Object)String.valueOf(((DTOFindPedidoPreVenda)param.getValue()).getUnidadeFatCliente().getCliente().getCodigoCliente()));
                    }
                    return new SimpleObjectProperty((Object)String.valueOf(""));
                }
                if (((DTOFindPedidoPreVenda)param.getValue()).getNfceConsumidor() != null && ((DTOFindPedidoPreVenda)param.getValue()).getNfceConsumidor().getCpfCnpj() != null) {
                    return new SimpleObjectProperty((Object)String.valueOf(((DTOFindPedidoPreVenda)param.getValue()).getNfceConsumidor().getCpfCnpj()));
                }
                return new SimpleObjectProperty((Object)"Cliente/Consumidor n\u00e3o informado");
            }
        });
        this.columnCliente.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String> param) {
                if (((DTOFindPedidoPreVenda)param.getValue()).getUnidadeFatCliente() != null) {
                    return new SimpleObjectProperty((Object)String.valueOf(((DTOFindPedidoPreVenda)param.getValue()).getUnidadeFatCliente().getCliente().getPessoa().getNome()));
                }
                if (((DTOFindPedidoPreVenda)param.getValue()).getNfceConsumidor() != null && ((DTOFindPedidoPreVenda)param.getValue()).getNfceConsumidor().getNome() != null) {
                    return new SimpleObjectProperty((Object)String.valueOf(((DTOFindPedidoPreVenda)param.getValue()).getNfceConsumidor().getNome()));
                }
                return new SimpleObjectProperty((Object)"Cliente/Consumidor n\u00e3o informado");
            }
        });
        this.columnCliente.setCellFactory((Callback)new Callback<TableColumn<DTOFindPedidoPreVenda, String>, TableCell<DTOFindPedidoPreVenda, String>>(){

            public TableCell<DTOFindPedidoPreVenda, String> call(TableColumn<DTOFindPedidoPreVenda, String> param) {
                TableCell<DTOFindPedidoPreVenda, String> cell = new TableCell<DTOFindPedidoPreVenda, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(ConsultarPreVenda.this.columnCliente.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnSitPedido.setCellValueFactory(cellData -> new SimpleStringProperty(String.valueOf(this.getSituacaoPedido(((DTOFindPedidoPreVenda)cellData.getValue()).getSituacaoPedidoIdentificador()))));
        this.columnSitPedido.setCellFactory((Callback)new Callback<TableColumn<DTOFindPedidoPreVenda, String>, TableCell<DTOFindPedidoPreVenda, String>>(){

            public TableCell<DTOFindPedidoPreVenda, String> call(TableColumn<DTOFindPedidoPreVenda, String> param) {
                TableCell<DTOFindPedidoPreVenda, String> cell = new TableCell<DTOFindPedidoPreVenda, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(ConsultarPreVenda.this.columnSitPedido.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnDataCadastro.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String> param) {
                return new SimpleObjectProperty((Object)ToolDate.dateToStr((Date)((DTOFindPedidoPreVenda)param.getValue()).getDataEmissao(), (String)"dd-MM-yyyy"));
            }
        });
        this.columnValorTot.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DTOFindPedidoPreVenda, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((DTOFindPedidoPreVenda)param.getValue()).getValorTotal()));
            }
        });
        this.tablePedidos.setItems(FXCollections.observableArrayList(result));
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    private void gerarNfce() {
        if (this.tablePedidos.getSelectionModel().getSelectedItem() == null) {
            Alerts.showAlertError("Selecione um pedido da tabela para continuar!");
            return;
        }
        if (StaticObjects.getOpcoes().getSituacaoPedidosFat() == null) {
            Alerts.showAlertError("Primeiro informe a Situa\u00e7\u00e3o de Pedido Faturado no cadastro das Op\u00e7oes NFC-e!");
            return;
        }
        DTOFindPedidoPreVenda dtoTemp = (DTOFindPedidoPreVenda)this.tablePedidos.getSelectionModel().getSelectedItem();
        DTOPedidoV10 dtoPedido = UtilPedido.sicronizaPedidoPreVenda(dtoTemp.getIdentificador());
        if (dtoPedido == null) {
            Alerts.showAlertError("Nenhum pedido foi encontrado no ERP com o serialForSync: " + dtoTemp.getIdentificador());
            return;
        }
        try {
            Pedido pedido = UtilPedido.getClonePedidoSincronizado(dtoPedido);
            StaticObjects.refreshPedido(pedido);
            this.converterPedidoInNFCe(pedido);
            UtilPedido.atualizaSituacaoPedido(dtoTemp.getIdentificador(), StaticObjects.getOpcoes().getSituacaoPedidosFat().getIdentificador());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("pedido", this.tablePedidos.getSelectionModel().getSelectedItem());
            Main.get().mudaTela(Controllers.VENDA, data);
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            Alerts.showAlertInfo("Erro ao transformar a Pre Venda em Nota Fiscal:\n" + e.getMessage());
        }
    }

    private void converterPedidoInNFCe(Pedido pedido) throws Exception {
        NFCe nfce = UtilNFCe.getNewNFCeByPedido(pedido);
        Boolean recarregarModeloFiscal = false;
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAlterarClientePreVenda(), (Object)1) || ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAlterarNatOperacaoPreVenda(), (Object)1)) {
            HashMap<String, NFCe> args = new HashMap<String, NFCe>();
            args.put("nfce", nfce);
            Main.get().showDialog(Controllers.EDITAR_DADOS_NFCE, args);
            UtilNFCe.setAndUpdateNaturezaOperacaoNFCe(nfce, nfce.getNaturezaOperacao());
            recarregarModeloFiscal = true;
        }
        ServiceGradeCor serviceGrade = Main.getBean(ServiceGradeCor.class);
        ServiceModeloFiscal serviceModeloFiscal = Main.getBean(ServiceModeloFiscal.class);
        ServiceParamTribCbsIbsClass serviceParamTribCbsIbsClass = Main.getBean(ServiceParamTribCbsIbsClass.class);
        for (ItemPedido itemPedido : pedido.getItemPedido()) {
            NFCeItem itemNFCe = new NFCeItem();
            GradeItemPedido gradeItemPedido = itemPedido.getGradeItemPedido().get(0);
            ModeloFiscal modeloFiscal = (ModeloFiscal)serviceModeloFiscal.get(itemPedido.getModeloFiscal().getIdentificador());
            ParamTribCbsIbsClass paramTrib = itemPedido.getParamTribCbsIbsClass();
            if (itemPedido.getParamTribCbsIbsClass() != null) {
                paramTrib = (ParamTribCbsIbsClass)serviceParamTribCbsIbsClass.get(itemPedido.getParamTribCbsIbsClass().getIdentificador());
            }
            if (recarregarModeloFiscal.booleanValue()) {
                ModeloFiscal modFiscal = new AuxModeloFiscal().getModeloFiscalNFCe(itemPedido.getProduto(), nfce.getUnidadeFatCliente(), nfce.getNfcePessoa(), nfce.getEnderecoEntrega(), nfce.getNaturezaOperacao(), nfce.getEmpresa(), true);
                if (modeloFiscal != null) {
                    modeloFiscal = modFiscal;
                    paramTrib = new AuxParamTribCbsIbs().getParametrizacaoNFe(nfce, itemPedido.getProduto(), modeloFiscal);
                }
            }
            UtilNFCe.getNewNFCeItem(itemNFCe, nfce, (GradeCor)serviceGrade.get(gradeItemPedido.getGradeCor().getIdentificador()), modeloFiscal, paramTrib, itemPedido.getQuantidadeTotal(), itemPedido.getPercComissao(), itemPedido.getValorUnitario(), itemPedido.getValorCusto(), itemPedido.getValorTotalBruto(), UtilPedido.getCentroEstoque(pedido, StaticObjects.getOpcoes().getCentroEstoque()), null, false);
            itemNFCe.setValorDescontoInf(itemPedido.getValorDesconto());
            itemNFCe.setPercValorDesconto((short)1);
            itemNFCe.setValorDespesasAcessoriasInf(itemPedido.getValorDespesaAcessoria());
            itemNFCe.setPercValorDespAcess((short)1);
            itemNFCe.setValorFreteInf(itemPedido.getValorFrete());
            itemNFCe.setPercValorFrete((short)1);
            itemNFCe.setValorSeguroInf(itemPedido.getValorSeguro());
            itemNFCe.setPercValorSeguro((short)1);
            itemNFCe.setRepresentante(itemPedido.getPedido().getRepresentante());
            itemNFCe.setPercentualComissao(itemPedido.getPercComissao());
            itemNFCe.setNrLoteFabricacao(itemPedido.getNrLoteFabricacao());
            itemNFCe.setDataFabricacao(itemPedido.getDataFabricacao());
            itemNFCe.setDataValidade(itemPedido.getDataValidade());
            if (ToolMethods.isEquals((Object)pedido.getDestacarDesconto(), (Object)0) && itemNFCe.getValorDescontoInf() > 0.0) {
                Double valorDescTemp = ToolFormatter.arrredondarNumero((Double)(itemNFCe.getValorDescontoInf() / itemNFCe.getQuantidadeComercial()), (int)2);
                itemNFCe.setValorUnitarioComercial(itemNFCe.getValorUnitarioComercial() - valorDescTemp);
                itemNFCe.setValorDescontoInf(0.0);
                itemNFCe.setPercentualDescontoInf(0.0);
                itemNFCe.setValorTotalBruto(ToolFormatter.arrredondarNumero((Double)(itemNFCe.getValorUnitarioComercial() * itemNFCe.getQuantidadeComercial()), (int)2));
            }
            if (ToolMethods.isEquals((Object)pedido.getDestacarDespAcessoria(), (Object)0) && itemNFCe.getValorDespesasAcessoriasInf() > 0.0) {
                Double valorDespTemp = ToolFormatter.arrredondarNumero((Double)(itemNFCe.getValorDespesasAcessoriasInf() / itemNFCe.getQuantidadeComercial()), (int)2);
                itemNFCe.setValorUnitarioComercial(itemNFCe.getValorUnitarioComercial() + valorDespTemp);
                itemNFCe.setValorDespesasAcessoriasInf(0.0);
                itemNFCe.setPercentualDespAcessInf(0.0);
                itemNFCe.setValorTotalBruto(ToolFormatter.arrredondarNumero((Double)(itemNFCe.getValorUnitarioComercial() * itemNFCe.getQuantidadeComercial()), (int)2));
            }
            nfce.getItens().add(itemNFCe);
        }
        UtilNFCe.putInformacoesRastreioLote(pedido, nfce);
        this.showInfPagamento(pedido);
        UtilNFCeCalculos.calcularValores(nfce);
        this.atualizaCampoSubTotal(nfce);
        StaticObjects.refreshNFCe();
        StaticObjects.setNfceAberta(nfce);
    }

    private void showInfPagamento(Pedido ped) {
        StringBuilder sb = new StringBuilder();
        sb.append("Condi\u00e7\u00f5es informadas no Pedido:\n");
        double troco = 0.0;
        double totBruto = 0.0;
        double totLiquido = 0.0;
        for (InfPagamentoPedido inf : ped.getInfPagamentoPedido()) {
            sb.append(inf.getCondicoesPagamento());
            sb.append(": ");
            sb.append(ToolFormatter.formataNumero((Number)inf.getValorLiquido(), (int)2));
            if (inf.getNumeroParcelas() > 0) {
                sb.append(" (");
                sb.append(inf.getNumeroParcelas());
                sb.append(")");
            }
            sb.append("\n");
            troco += inf.getValorTroco().doubleValue();
            totBruto += inf.getValor().doubleValue();
            totLiquido += inf.getValorLiquido().doubleValue();
        }
        Alerts.showAlertInfo(sb.toString());
    }

    private void atualizaCampoSubTotal(NFCe nfce) {
        try {
            UtilNFCeCalculos.calcularValores(nfce);
        }
        catch (ExceptionImpostoIcms | ExceptionImpostoIPI | ExceptionImpostoPisCofins | ExceptionImpostoCbsIbs ex) {
            ex.printStackTrace();
        }
    }

    private Short getNumeroParcelas(NFCePagamento nfcePag) {
        if (nfcePag.getCondicoesPagamento() != null) {
            return nfcePag.getCondicoesPagamento().getNumeroParcelas().shortValue();
        }
        return null;
    }

    private void filterElementsTable() {
        this.tablePedidos.getItems().clear();
        List<DTOFindPedidoPreVenda> result = UtilPedido.findPedidosSemNotas(this.tfCampoBusca.getText());
        this.setPedidosTable(result);
    }

    private void setDataAtualPesquisa() {
        Integer day = ToolDate.dayFromDate((Date)new Date());
        Integer month = ToolDate.monthFromDate((Date)new Date());
        Integer year = ToolDate.yearFromDate((Object)new Date());
        StringBuilder sb = new StringBuilder();
        if (day < 10) {
            sb.append("0");
        }
        sb.append(day.toString());
        sb.append("/");
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month.toString());
        sb.append("/");
        sb.append(year.toString());
        this.tfCampoBusca.setText(sb.toString());
        this.filterElementsTable();
    }

    private String getSituacaoPedido(Long situacaoPedidoIdentificador) {
        ServiceSituacaoPedidos service = Main.getBean(ServiceSituacaoPedidos.class);
        SituacaoPedidos sit = (SituacaoPedidos)service.get(situacaoPedidoIdentificador);
        if (sit == null) {
            return "";
        }
        return sit.getDescricao();
    }
}

