/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.sincronizardados.thread;

import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.sincronizardados.thread.BaseSinc;
import com.touchcomp.touchnfce.model.DadosSincronizacao;
import com.touchcomp.touchnfce.sinc.send.SincEnvBase;
import com.touchcomp.touchnfce.sinc.send.SincEnvFactory;
import com.touchcomp.touchnfce.sinc.send.SincEnvListener;
import com.touchcomp.touchnfce.sinc.send.SincParamsSend;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.control.TextArea;

public class SincEnvio
extends BaseSinc
implements SincEnvListener,
Runnable {
    private static SincEnvio instance;
    private String sincEnvio = "";
    private TextArea txtDadosEnviados;
    private boolean isFinish = true;

    private SincEnvio(TextArea txtDadosEnviados) {
        this.txtDadosEnviados = txtDadosEnviados;
        this.updateTextArea(this.sincEnvio);
    }

    public static SincEnvio getInstance(TextArea txtDadosEnviados) {
        if (instance == null) {
            instance = new SincEnvio(txtDadosEnviados);
        } else {
            SincEnvio.instance.txtDadosEnviados = txtDadosEnviados;
        }
        return instance;
    }

    @Override
    public void run() {
        try {
            if (!this.isFinish) {
                System.out.println("SINCRONIZACAO DE ENVIO EM ANDAMENTO");
                return;
            }
            if (this.checkLockSinc().booleanValue()) {
                this.updateTextArea("A sincroniza\u00e7\u00e3o est\u00e1 bloqueada nas op\u00e7\u00f5es de sua empresa.\n");
                return;
            }
            this.isFinish = false;
            this.sincEnvio = "";
            DadosSincronizacao dadosSincronizacao = StaticObjects.getDadosSincronizacao();
            SincParamsSend params = new SincParamsSend(dadosSincronizacao, StaticObjects.getNFCeCaixa());
            SincEnvFactory.getInstance().setListener(this);
            SincEnvFactory.getInstance().startSinc(params);
        }
        catch (ExceptionDecodeHexString64 | ExceptionIO | ExceptionReflection | ExceptionWebService ex) {
            this.updateTextArea(ex.getMessage());
            ex.printStackTrace();
            Logger.getLogger(SincEnvio.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            this.updateTextArea(ex.getMessage());
            ex.printStackTrace();
            Logger.getLogger(SincEnvio.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.isFinish = true;
        }
    }

    private void updateTextArea(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (this.txtDadosEnviados == null) {
            return;
        }
        Platform.runLater(() -> this.txtDadosEnviados.appendText(message));
    }

    @Override
    public void onSincProgressItemRec(long perc) {
    }

    @Override
    public void beforeSincEnv(List<SincEnvBase> sincs) {
        this.txtDadosEnviados.clear();
        this.updateTextArea("Iniciando Sincroniza\u00e7\u00e3o.\n");
    }

    @Override
    public void onSincDataSizeEnv(SincEnvBase base, double perc) {
        this.updateTextArea("Verificando dados " + base.getDescSinc() + "\n");
    }

    @Override
    public void onSincDataEnv(SincEnvBase base, double perc) {
        this.sincEnvio = "Sincronizando Envio: " + base.getDescSinc() + " " + ToolFormatter.formataNumero((Number)perc, (int)2) + "%\n";
        this.updateTextArea(this.sincEnvio);
    }

    @Override
    public void afterSincEnv(List<SincEnvBase> sincs, Date in, Date end, Long durationInSeconds) {
        this.updateTextArea("Sincroniza\u00e7\u00e3o terminada.");
    }
}

