/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.helpers.nfcesefaz.HelperNFCeSefaz;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.Usuario;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;
import lombok.Generated;

public class SplashCancelaNFCe
extends SplashMain<NFCe>
implements Initializable {
    private NFCe nfce;
    private String justificativa;
    private Usuario usuario;

    @Override
    protected void successTask() {
        StaticObjects.reloadNFCeAberta();
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        workerStateEvent.getSource().getException().printStackTrace();
        Alerts.showAlertError("Erro ao enviar/cancelar/inutilizar a NFCe:\n\n" + workerStateEvent.getSource().getException().getMessage());
    }

    @Override
    protected NFCe call() throws Exception {
        try {
            return new HelperNFCeSefaz().cancelar(this.nfce, this.justificativa, this.usuario);
        }
        catch (Exception ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            throw ex;
        }
    }

    private boolean isValidToCancel() {
        if (TMethods.isEquals((Object)this.nfce.getStatus(), (Object)EnumConstNFeStatus.CANCELADA.getValue())) {
            Alerts.showAlertError("NFCe j\u00e1 se encontra cancelada.");
            return false;
        }
        if (TMethods.isEquals((Object)this.nfce.getStatus(), (Object)EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue()) || TMethods.isEquals((Object)this.nfce.getStatus(), (Object)EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_DESTINATARIO.getValue()) || TMethods.isEquals((Object)this.nfce.getStatus(), (Object)EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_DESTINATARIO_NAO_HABILITADO.getValue()) || TMethods.isEquals((Object)this.nfce.getStatus(), (Object)EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_EMITENTE.getValue())) {
            Alerts.showAlertError("NFCe denegada. N\u00e3o \u00e9 poss\u00edvel cancelar.");
            return false;
        }
        return true;
    }

    private boolean isAutorizada() {
        return TMethods.isEquals((Object)this.nfce.getStatus(), (Object)EnumConstNFeStatus.AUTORIZADA.getValue()) || TMethods.isEquals((Object)this.nfce.getStatus(), (Object)EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue());
    }

    @Generated
    public void setNfce(NFCe nfce) {
        this.nfce = nfce;
    }

    @Generated
    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }
}

