/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.DadosSincronizacao;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.sinc.send.SincEnvBase;
import com.touchcomp.touchnfce.sinc.send.SincEnvFactory;
import com.touchcomp.touchnfce.sinc.send.SincEnvListener;
import com.touchcomp.touchnfce.sinc.send.SincParamsSend;
import com.touchcomp.touchnfce.utils.Style;
import com.touchcomp.touchnfce.utils.UtilImageSvg;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import org.apache.batik.transcoder.TranscoderException;

public class SplashControllerEnvioExit
implements Initializable {
    @FXML
    private ImageView imgLogoTouch;
    @FXML
    private ProgressBar progressBarLoading;
    @FXML
    private Label lblStatus;
    @FXML
    private AnchorPane body;
    @FXML
    private ImageView logo;

    public void initialize(URL url, ResourceBundle rb) {
        PropertiesLoader props = PropertiesLoader.get();
        Style style = new Style();
        this.body.setStyle(style.getCorBody(props.getCorBackground_1(), props.getCorBackground_2(), props.getCorBackground_3(), props.getCorBackground_4(), props.getCorBackground_5()));
        this.lblStatus.setAlignment(Pos.CENTER);
        this.lblStatus.setTextAlignment(TextAlignment.CENTER);
        this.lblStatus.setStyle(style.getCorTexto(props.getCorTexto()) + "-fx-font: 23pt \"Microsoft New Tai Lue\"");
        this.inicializaImagem();
        this.rotateImageTouch();
        this.executeExampleProgressBar();
    }

    private void inicializaImagem() {
        try {
            UtilImageSvg.generateImageFromSvg("logo_splash");
            Image image = new Image((InputStream)new FileInputStream("target/classes/images/logo_splash.png"));
            this.logo.setImage(image);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SplashControllerEnvioExit.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (IOException | TranscoderException ex) {
            Logger.getLogger(SplashControllerEnvioExit.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    public void executeExampleProgressBar() {
        Service servico = new Service(){

            protected Task createTask() {
                return new MyTask(SplashControllerEnvioExit.this);
            }
        };
        this.lblStatus.textProperty().bind((ObservableValue)servico.messageProperty());
        this.progressBarLoading.progressProperty().bind((ObservableValue)servico.progressProperty());
        servico.restart();
    }

    private void rotateImageTouch() {
        RotateTransition rt = new RotateTransition(Duration.millis((double)10000.0), (Node)this.imgLogoTouch);
        rt.setByAngle(360.0);
        rt.setCycleCount(-1);
        rt.setInterpolator(Interpolator.LINEAR);
        rt.play();
    }

    private class MyTask
    extends Task
    implements SincEnvListener {
        Throwable throwable;

        private MyTask(SplashControllerEnvioExit splashControllerEnvioExit) {
        }

        protected void failed() {
            Alerts.showAlertError("Ocorreu uma falha ao sincronizar: ", "", "Ocorreu uma falha ao sincronizar: " + (this.throwable != null ? this.throwable.getMessage() : ""), Main.get().getPrimaryStage());
            System.exit(0);
        }

        protected Void call() throws Exception {
            SincEnvFactory.getInstance().setListener(this);
            try {
                DadosSincronizacao dadosSincronizacao = StaticObjects.getDadosSincronizacao();
                SincParamsSend params = new SincParamsSend(dadosSincronizacao, StaticObjects.getNFCeCaixa());
                SincEnvFactory.getInstance().setListener(this);
                SincEnvFactory.getInstance().startSinc(params);
            }
            catch (ExceptionIO ex) {
                this.throwable = ex;
                Logger.getLogger(SplashControllerEnvioExit.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", ex.getMessage());
            }
            catch (ExceptionDecodeHexString64 | ExceptionReflection | ExceptionWebService ex) {
                this.throwable = ex;
                Logger.getLogger(SplashControllerEnvioExit.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", ex.getMessage());
            }
            catch (Exception ex) {
                this.throwable = ex;
                Logger.getLogger(SplashControllerEnvioExit.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", ex.getMessage());
            }
            return null;
        }

        protected void succeeded() {
            super.succeeded();
            System.exit(0);
        }

        @Override
        public void onSincProgressItemRec(long perc) {
            this.updateProgress(perc, 100L);
        }

        @Override
        public void beforeSincEnv(List<SincEnvBase> sincs) {
            this.updateMessage("Iniciando sincroniza\u00e7\u00e3o");
        }

        @Override
        public void onSincDataSizeEnv(SincEnvBase base, double perc) {
            this.updateMessage("Quantidade reg.: " + base.getDescSinc());
            this.updateProgress(perc, 100.0);
        }

        @Override
        public void onSincDataEnv(SincEnvBase base, double perc) {
            this.updateMessage(base.getDescSinc());
        }

        @Override
        public void afterSincEnv(List<SincEnvBase> sincs, Date in, Date end, Long durationInSeconds) {
        }
    }
}

