/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.model.BicoBombaCombustivel;
import com.touchcomp.touchnfce.model.BombaCombustivel;
import com.touchcomp.touchnfce.modeltemp.DeParaBicoBomba;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.utils.Style;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class SplashShowBombasCentralAbastecimento
extends SplashMain
implements Initializable {
    private HBox gridBombas;
    private HBox gridBombas1;
    private HBox gridBombas2;
    private List<DeParaBicoBomba> listDeParaBicos = new LinkedList<DeParaBicoBomba>();
    private List<BombaCombustivel> bombas = new ArrayList<BombaCombustivel>();

    public SplashShowBombasCentralAbastecimento(HBox gridBombas, HBox gridBombas1, HBox gridBombas2, List<DeParaBicoBomba> listDeParaBicos) {
        this.updateStatus("Carregando Bicos e Bombas.");
        this.gridBombas = gridBombas;
        this.gridBombas1 = gridBombas1;
        this.gridBombas2 = gridBombas2;
        this.listDeParaBicos = listDeParaBicos;
    }

    @Override
    protected void successTask() {
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
    }

    protected List<BombaCombustivel> call() throws Exception {
        this.setBombas(UtilCentralAbastecimento.get().getAllBombasCombustivel());
        this.showBombas(this.getBombas());
        return this.getBombas();
    }

    public List<BombaCombustivel> getBombas() {
        return this.bombas;
    }

    public void setBombas(List<BombaCombustivel> bombas) {
        this.bombas = bombas;
    }

    public void showBombas(List<BombaCombustivel> listBombas) {
        int count = 1;
        for (BombaCombustivel bomba : listBombas) {
            HBox hbox = new HBox();
            hbox.setSpacing(5.0);
            hbox.setAlignment(Pos.CENTER);
            VBox uiBomba = new VBox();
            uiBomba.setSpacing(2.0);
            uiBomba.setAlignment(Pos.CENTER);
            Image icon = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/icones/bomba.png"));
            ImageView image = new ImageView();
            image.setFitHeight(60.0);
            image.setFitWidth(60.0);
            image.setImage(icon);
            VBox vbox = new VBox();
            vbox.setSpacing(2.0);
            vbox.setAlignment(Pos.CENTER);
            HBox boxStatus = new HBox();
            boxStatus.setSpacing(10.0);
            boxStatus.setAlignment(Pos.CENTER);
            for (BicoBombaCombustivel bico : bomba.getBicos()) {
                DeParaBicoBomba dePara = new DeParaBicoBomba();
                PropertiesLoader props = PropertiesLoader.get();
                Style style = new Style();
                Label labelBico = new Label();
                labelBico.setText("  " + bico.getCodigo() + "  ");
                labelBico.setStyle(style.getCorTexto(props.getCorTexto()));
                labelBico.setWrapText(true);
                dePara.setBico(bico);
                dePara.setLabel(labelBico);
                labelBico.setOnMouseEntered(evt -> {
                    labelBico.setScaleX(1.4);
                    labelBico.setScaleY(1.4);
                });
                labelBico.setOnMouseExited(evt -> {
                    labelBico.setScaleX(1.0);
                    labelBico.setScaleY(1.0);
                });
                this.listDeParaBicos.add(dePara);
                boxStatus.getChildren().add((Object)labelBico);
            }
            uiBomba.getChildren().add((Object)boxStatus);
            vbox.getChildren().add((Object)image);
            vbox.getChildren().add((Object)uiBomba);
            hbox.getChildren().add((Object)vbox);
            if (count <= 2) {
                this.gridBombas.getChildren().add((Object)hbox);
            } else if (count > 2 && count <= 4) {
                this.gridBombas1.getChildren().add((Object)hbox);
            } else {
                this.gridBombas2.getChildren().add((Object)hbox);
            }
            ++count;
        }
    }
}

