/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.status;

import com.fincatto.documentofiscal.DFModelo;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.statusservico.NFeStatusServicoRet;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.MainEvents;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.listeners.ShortcutListener;
import com.touchcomp.touchnfce.tasks.TaskExecuter;
import com.touchcomp.touchnfce.tasks.TaskResult;
import com.touchcomp.touchnfce.tasks.impl.AppTaskConsultaStatusServico;
import com.touchcomp.touchnfce.utils.Style;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;

public class StatusConexaoController
extends BaseController
implements TaskResult<NFeStatusServicoRet>,
Runnable {
    @FXML
    private AnchorPane body;
    @FXML
    private Label lblData;
    @FXML
    private Label lblUsuario;
    @FXML
    private Label lblCaixa;
    @FXML
    private Label lblPeriodoEmissaoNFCe;
    @FXML
    private Label lblPeriodoEmissaoNFe;
    @FXML
    private Label lblModeloNfce;
    @FXML
    private Label lblTipoEmissaoNFCe;
    @FXML
    private Label lblTipoEmissaoNFe;
    @FXML
    private Button btnStatusNFCe;
    @FXML
    private Button btnStatusNFe;
    private static String stringRealDateTime;
    private static final Style style;
    private final Runnable clock = new Runnable(){

        @Override
        public void run() {
            try {
                while (true) {
                    if (Main.get().getPrimaryStage().isFocused()) {
                        Platform.runLater(() -> {
                            if (Main.get().getFxmlLoader().getController() instanceof ShortcutListener) {
                                MainEvents.getInstance().setListener((ShortcutListener)Main.get().getFxmlLoader().getController(), Main.get().getPrimaryStage());
                            }
                        });
                    } else {
                        List<Window> openStages = Stage.getWindows().stream().filter(Window::isShowing).toList();
                        for (Window openStage : openStages) {
                            FXMLLoader loader;
                            if (!openStage.isFocused() || (loader = (FXMLLoader)openStage.getUserData()) == null || !(loader.getController() instanceof ShortcutListener)) continue;
                            Platform.runLater(() -> MainEvents.getInstance().setListener((ShortcutListener)loader.getController(), openStage));
                        }
                    }
                    stringRealDateTime = ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy hh:mm:ss");
                    Platform.runLater(() -> StatusConexaoController.this.lblData.setText(stringRealDateTime));
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(StatusConexaoController.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
    };

    @Override
    protected void initializeController(ResourceBundle rb) {
        String versao = "202511-05";
        if (StaticObjects.getUsuario() != null && StaticObjects.getNFCeCaixa() != null) {
            this.lblUsuario.setText(this.quebraNomeUsuario());
            this.lblCaixa.setWrapText(true);
            this.lblCaixa.setText(StaticObjects.getNFCeCaixa().getDescricao());
        }
        this.lblCaixa.setText(this.lblCaixa.getText() + "|V-" + versao + "|");
        this.setStyleLabels();
        this.atualizaStatusPedido();
        this.atualizaPeriodoEmissaoNFCe();
        this.atualizaPeriodoEmissaoNFe();
        this.atualizaStatusModeloNFCe();
        new Thread(this.clock).start();
    }

    private void setStyleLabels() {
        Platform.runLater(() -> {
            this.lblUsuario.setStyle(style.getStyleLabelFooterMain());
            this.lblUsuario.setWrapText(true);
            this.lblCaixa.setStyle(style.getStyleLabelFooterMain());
            this.lblCaixa.setWrapText(true);
            this.lblData.setStyle(style.getStyleLabelFooterMain());
            this.lblPeriodoEmissaoNFCe.setStyle(style.getStyleLabelFooterMain());
            this.lblPeriodoEmissaoNFCe.setWrapText(true);
            this.lblTipoEmissaoNFCe.setStyle(style.getStyleLabelFooterMain());
            this.lblTipoEmissaoNFe.setStyle(style.getStyleLabelFooterMain());
            this.lblPeriodoEmissaoNFe.setStyle(style.getStyleLabelFooterMain());
            this.lblPeriodoEmissaoNFe.setWrapText(true);
            this.lblModeloNfce.setStyle(style.getStyleLabelFooterMain());
        });
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    @Override
    public void onFinish(NFeStatusServicoRet result) {
        this.setColorAndStatusServiceNFCe(result);
        this.setColorAndStatusServiceNFe(result);
    }

    private void setColorAndStatusServiceNFCe(NFeStatusServicoRet result) {
        Platform.runLater(() -> {
            if (ToolMethods.isEquals((Object)result, null)) {
                this.btnStatusNFCe.setStyle(style.getStyleButtonDisponibilidadeSefazServicoForaAr());
                return;
            }
            if (ToolMethods.isEquals((Object)result.getStatusNFCe(), null)) {
                return;
            }
            if (ToolMethods.isEquals((Object)result.getStatusNFCe(), (Object)"107")) {
                this.btnStatusNFCe.setStyle(style.getStyleButtonDisponibilidadeSefazServicoOperacao());
            } else {
                this.btnStatusNFCe.setStyle(style.getStyleButtonDisponibilidadeSefazServicoForaAr());
            }
            this.btnStatusNFCe.setText(result.getStatusNFCe());
        });
    }

    private void setColorAndStatusServiceNFe(NFeStatusServicoRet result) {
        Platform.runLater(() -> {
            if (ToolMethods.isEquals((Object)result, null)) {
                this.btnStatusNFe.setStyle(style.getStyleButtonDisponibilidadeSefazServicoForaAr());
                return;
            }
            if (ToolMethods.isEquals((Object)result.getStatusNFe(), null)) {
                return;
            }
            if (ToolMethods.isEquals((Object)result.getStatusNFe(), (Object)"107")) {
                this.btnStatusNFe.setStyle(style.getStyleButtonDisponibilidadeSefazServicoOperacao());
            } else {
                this.btnStatusNFe.setStyle(style.getStyleButtonDisponibilidadeSefazServicoForaAr());
            }
            this.btnStatusNFe.setText(result.getStatusNFe());
        });
    }

    @Override
    public void onError(NFeStatusServicoRet result, Exception ex) {
        if (ex != null) {
            ex.printStackTrace();
        }
        this.setColorAndStatusServiceNFCe(result);
        this.setColorAndStatusServiceNFe(result);
    }

    @Override
    public void run() {
        if (StaticObjects.getOpcoes() != null) {
            while (true) {
                this.consultaStatusNFCe();
                this.consultaStatusNFe();
                try {
                    Thread.sleep(150000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    Logger.getLogger(StatusConexaoController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void consultaStatusNFCe() {
        try {
            AppTaskConsultaStatusServico taskNFCe = new AppTaskConsultaStatusServico(this, StaticObjects.getOpcoes(), StaticObjects.getEmpresa(), DFModelo.NFCE);
            TaskExecuter.getInstance().getExecutor().submit(taskNFCe).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            ex.printStackTrace();
            Logger.getLogger(StatusConexaoController.class.getName()).log(Level.SEVERE, null, ex);
            this.setColorAndStatusServiceNFCe(null);
        }
    }

    private void consultaStatusNFe() {
        try {
            AppTaskConsultaStatusServico taskNFe = new AppTaskConsultaStatusServico(this, StaticObjects.getOpcoes(), StaticObjects.getEmpresa(), DFModelo.NFE);
            TaskExecuter.getInstance().getExecutor().submit(taskNFe).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            ex.printStackTrace();
            Logger.getLogger(StatusConexaoController.class.getName()).log(Level.SEVERE, null, ex);
            this.setColorAndStatusServiceNFe(null);
        }
    }

    public String quebraNomeUsuario() {
        String[] partes_nome = StaticObjects.getUsuario().getPessoa().getNome().split(" ");
        if (partes_nome.length > 1) {
            String nome_aux = partes_nome[0] + " " + partes_nome[1];
            return nome_aux;
        }
        return partes_nome[0];
    }

    public void atualizaStatusModeloNFCe() {
        Object status = "";
        if (StaticObjects.getNfceAberta() == null) {
            this.lblModeloNfce.setText((String)status);
            return;
        }
        status = ToolMethods.isEquals((Object)StaticObjects.getNfceAberta().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo()) ? "NFCe: " : (ToolMethods.isEquals((Object)StaticObjects.getNfceAberta().getNfeTransferencia(), (Object)1) ? "NFe Transf.: " : "NFe: ");
        status = (String)status + StaticObjects.getNfceAberta().getNumero() + "/" + StaticObjects.getNfceAberta().getSerie();
        this.lblModeloNfce.setText((String)status);
        String text = StaticObjects.getOpcoes().getTipoAmbiente() == 1 ? "Prod." : "Hom.";
        this.lblModeloNfce.setText(this.lblModeloNfce.getText() + " (" + text + ")");
    }

    public void atualizaStatusPedido() {
        if (StaticObjects.getPedidoAberto() == null) {
            this.lblModeloNfce.setText("");
            return;
        }
        this.lblModeloNfce.setText("Pedido: " + StaticObjects.getPedidoAberto().getIdentificador());
    }

    @Override
    public void eventKey(KeyEvent evt) {
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    public void atualizaPeriodoEmissaoNFCe() {
        if (StaticObjects.getNFCePeriodoEmissao() == null) {
            this.lblPeriodoEmissaoNFCe.setText("");
            return;
        }
        this.lblPeriodoEmissaoNFCe.setText(StaticObjects.getNFCePeriodoEmissao().getTipoEmissaoNfe().getDescricao());
    }

    public void atualizaPeriodoEmissaoNFe() {
        if (StaticObjects.getNFePeriodoEmissao() == null) {
            this.lblPeriodoEmissaoNFe.setText("");
            return;
        }
        this.lblPeriodoEmissaoNFe.setText(StaticObjects.getNFePeriodoEmissao().getTipoEmissaoNfe().getDescricao());
        if (StaticObjects.getOpcoes().getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo() == 6) {
            if (UtilCentralAbastecimento.get().isControlMaster()) {
                this.lblPeriodoEmissaoNFe.setText(this.lblPeriodoEmissaoNFe.getText() + "/MASTER");
            } else {
                this.lblPeriodoEmissaoNFe.setText(this.lblPeriodoEmissaoNFe.getText() + "/SLAVE");
            }
        }
    }

    static {
        style = new Style();
    }
}

