/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.venda;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.components.autocomplete.AutoCompleteLazyLoad;
import com.touchcomp.touchnfce.components.autocomplete.impl.AutoCompleteLazyLoadProduto;
import com.touchcomp.touchnfce.components.listener.FocusListener;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.consumidor.ConsumidorController;
import com.touchcomp.touchnfce.controller.dialogs.dialogconfirmasair.ActionsConfirmaSair;
import com.touchcomp.touchnfce.controller.dialogs.dialogoutrasopcoes.DialogOutrasOpcoes;
import com.touchcomp.touchnfce.controller.endereco.EnderecoEntregaNFCeController;
import com.touchcomp.touchnfce.controller.item.ConsultaItemController;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.controller.nfce.PesquisaNFCeController;
import com.touchcomp.touchnfce.controller.venda.PreVendaController;
import com.touchcomp.touchnfce.controller.venda.StyleChangingRowFactory;
import com.touchcomp.touchnfce.controller.venda.TempPesquisaProdutoConverter;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.controller.venda.auxparamtribcbsibs.AuxParamTribCbsIbs;
import com.touchcomp.touchnfce.controller.venda.balanca.ThreadBalanca;
import com.touchcomp.touchnfce.controller.venda.balanca.ThreadBalancaListener;
import com.touchcomp.touchnfce.controller.venda.helper.AuxProduto;
import com.touchcomp.touchnfce.controller.vendedor.VendedorController;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.helpers.preco.HelperPrecos;
import com.touchcomp.touchnfce.model.GradeCor;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.ParamTribCbsIbsClass;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.modeltemp.ControllerPath;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.service.impl.ServiceGradeCor;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeCalculos;
import com.touchcomp.touchnfce.utils.UtilNFCeCancelamento;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class VendaNFCeController
extends BaseController
implements AutoCompleteLazyLoad.ItemSelLazyFilter,
AutoCompleteLazyLoad.ItemLazyFilter,
ActionsConfirmaSair,
ThreadBalancaListener {
    @FXML
    private Label lblQuantidade;
    @FXML
    private Label lblProduto;
    @FXML
    private Label lblVlrUnitario;
    @FXML
    private Label lblVlrDesc;
    @FXML
    private Label lblVendedor;
    @FXML
    private Label lblSubTotalNFCe;
    @FXML
    private Label lblCliente;
    @FXML
    private TableColumn<NFCeItem, String> columnNmrItem;
    @FXML
    private TableColumn<NFCeItem, String> columnProduto;
    @FXML
    private TableColumn<NFCeItem, String> columnUM;
    @FXML
    private TableColumn<NFCeItem, String> columnVlrDesconto;
    @FXML
    private TableColumn<NFCeItem, String> columnVlrTot;
    @FXML
    private TableColumn<NFCeItem, String> columnVlrUnitario;
    @FXML
    private TableColumn<NFCeItem, String> columnQuantidade;
    @FXML
    private TableColumn<NFCeItem, String> columIdCodAux;
    @FXML
    private TableColumn<NFCeItem, String> columnCodBarras;
    @FXML
    private TableView<NFCeItem> tableItens;
    @FXML
    private Button btnCliente;
    @FXML
    private Button btnCamposProduto;
    @FXML
    private Button btnVendedor;
    @FXML
    private Button btnCancNFCe;
    @FXML
    private Button btnCancItem;
    @FXML
    private Button btnDadosTransp;
    @FXML
    private Button btnPreVenda;
    @FXML
    private Button btnConsultaItem;
    @FXML
    private Button btnFecharNFCe;
    @FXML
    private Button btnSair;
    @FXML
    private Button btnConsumidor;
    @FXML
    private Button btnEnderecoEntrega;
    @FXML
    private Button btnPesqNFCe;
    @FXML
    private Button btnDadosVeiculos;
    @FXML
    private TouchDoubleField tfVlrUnitario;
    @FXML
    private TouchDoubleField tfVlrDesc;
    @FXML
    private TouchDoubleField tfSubTotalNFCe;
    @FXML
    private TouchDoubleField tfQuantidade;
    @FXML
    private TouchTextField tfVendedor;
    @FXML
    private TouchTextField tfCliente;
    @FXML
    private AutoCompleteLazyLoadProduto tfProduto;
    @FXML
    private AnchorPane body;
    @FXML
    private GridPane gridVenda;
    @FXML
    private GridPane gridCliente;
    private ImageView image = new ImageView();
    private Image logo = null;
    private TreeSet<TempPesquisaProdutoConverter> produtos = new TreeSet();
    private int exibirProduto = 0;
    private NFCe nfcePesquisa;
    final StyleChangingRowFactory<NFCeItem> rowFactory = new StyleChangingRowFactory("table-row-cell-yellow");
    private String codigoBarrasTemp = "";
    private TLogger logger = TLogger.get(VendaNFCeController.class);
    private final ThreadBalanca threadBalanca = new ThreadBalanca(this);
    private TempPesquisaProduto tempPesquisaProduto;

    @Override
    protected void requestFocusOnOpen() {
        this.tfProduto.requestFocus();
    }

    @Override
    protected void initializeController(ResourceBundle rb) {
        StaticObjects.setVendasController(this);
        Main.get().getFooterController().atualizaStatusModeloNFCe();
        this.exibirProduto = this.getOpcoes().getUsarCodAuxiliar().shortValue();
        if (this.exibirProduto == 1) {
            this.columIdCodAux.setText("Cod. Aux.");
        } else {
            this.columIdCodAux.setText("Id");
        }
        if (!ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getUtilizarPreVenda(), (Object)1)) {
            this.btnPreVenda.setDisable(true);
        }
        if (!ToolMethods.isEquals((Object)StaticObjects.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo().shortValue(), (Object)6)) {
            this.btnDadosVeiculos.setDisable(true);
        }
        this.configureTable();
        this.setPropriedadesTextFields();
        this.configureButtons();
        this.tfProduto.setItemSelListener(this);
        this.tfProduto.setLazyLoading(this);
        this.tfVlrDesc.setEditable(false);
        this.tfVlrUnitario.setEditable(false);
        this.tfSubTotalNFCe.setEditable(false);
        this.tfVendedor.setEditable(false);
        this.tfCliente.setEditable(false);
        this.tfQuantidade.setNumberDecimalCases(3);
        this.tfQuantidade.setDouble(1.0);
        this.tfVendedor.setFocusTraversable(false);
        this.tfCliente.setFocusTraversable(false);
        Main.get().getPrimaryStage().setResizable(true);
        this.setLabelsTextField();
        this.clearDescricaoUltimoProduto();
        this.setFieldClienteAndRepresentante();
        if (ToolMethods.isWithData((Number)StaticObjects.getOpcoes().getNrCasasDecValor())) {
            this.tfVlrUnitario.setNumberDecimalCases(StaticObjects.getOpcoes().getNrCasasDecValor().shortValue());
            this.tfVlrUnitario.setDouble(0.0);
        }
    }

    private void setFieldClienteAndRepresentante() {
        Main.get().getFooterController().atualizaStatusModeloNFCe();
        if (this.getNFCe() == null) {
            this.visibleAndSetCliente(false);
            this.visibleAndSetRepresentante(false);
            return;
        }
        this.visibleAndSetCliente(this.getNFCe().getUnidadeFatCliente() != null);
        this.visibleAndSetRepresentante(this.getNFCe().getRepresentante() != null);
    }

    private void setLabelsTextField() {
        this.tfProduto.setLabel(this.lblProduto);
        this.tfQuantidade.setLabel(this.lblQuantidade);
    }

    @Override
    public void paramsData(Class<? extends BaseController> aClass, Map data) {
        if (PesquisaNFCeController.class.equals(aClass)) {
            this.nfcePesquisa = (NFCe)data.get("NFCe");
            if (this.nfcePesquisa != null) {
                this.setProdutosTable(this.nfcePesquisa);
                this.setaDadosCampos(this.nfcePesquisa);
            }
        } else if (ConsultaItemController.class.equals(aClass)) {
            if (data.get("qtd_pesquisa_prod") != null) {
                this.tfQuantidade.setDouble((Double)data.get("qtd_pesquisa_prod"));
            }
            this.setTempPesquisaProduto((TempPesquisaProduto)data.get("pesquisa_prod"), true);
            this.criaNFCeItem(false);
        }
        this.iniciaNFCe();
    }

    public void iniciaNFCe() {
        try {
            if (this.getNFCe() != null) {
                this.setProdutosTable(this.getNFCe());
                this.setaDadosCampos(this.getNFCe());
            } else {
                this.criaNFCe();
                if (StaticObjects.getOpcoes().getAbrirTelaClienteVenda() != null && StaticObjects.getOpcoes().getAbrirTelaClienteVenda().equals((short)1)) {
                    Main.get().showDialog(Controllers.PESQUISA_PESSOAS);
                }
                this.desabilitaTableHabilitaGIF();
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            Alerts.showAlertInfo(ex.getMessage());
        }
    }

    private void setPropriedadesTextFields() {
        this.lblVendedor.setVisible(false);
        this.tfVendedor.setVisible(false);
        this.tfProduto.setOnKeyReleased(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        if (!this.tfProduto.isFocused() || this.tfProduto.getText() == null || this.tfProduto.getText().isEmpty() || !ToolString.isAIntegerNumber((String)this.tfProduto.getText()) || !this.produtos.isEmpty()) break;
                        this.findProduto();
                        break;
                    }
                }
            }
        });
        this.tfQuantidade.setOnKeyPressed(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        this.criaNFCeItem(false);
                        this.tfProduto.requestFocus();
                        break;
                    }
                }
            }
        });
        this.tfQuantidade.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
                if (!VendaNFCeController.this.threadBalanca.isStartBalanca()) {
                    VendaNFCeController.this.threadBalanca.setStartBalanca(true);
                }
            }

            @Override
            public void onFocusLost() {
                VendaNFCeController.this.threadBalanca.setStartBalanca(false);
            }
        });
    }

    private void informaDadosTransporte() {
        this.criaNFCe();
        HashMap<String, Boolean> h = new HashMap<String, Boolean>();
        h.put("PEDIDO", false);
        DialogOutrasOpcoes consumidorController = (DialogOutrasOpcoes)Main.get().showDialog(Controllers.DIALOG_OUTRAS_OPCOES_CLIENTE, h);
    }

    private void fecharNFCe() {
        if (this.getNFCe() == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "N\u00e3o foi encontrada nenhuma NFCe v\u00e1lida aberta para pagamento", "");
        } else if (this.getNFCe().getItens().isEmpty()) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Para concluir uma venda \u00e9 preciso adicionar itens a nota!", "");
        } else if (this.getAllItensCancelados()) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Todos os itens da NFCe est\u00e3o cancelados, insira mais itens ou cancele a NFCe!", "");
        } else {
            try {
                if (this.obrigarInformarVendedor().booleanValue()) {
                    if (ToolMethods.isEquals((Object)this.getNFCe().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
                        UtilNFCeCalculos.calcularValoresBasicosSemCalcImp(this.getNFCe());
                    } else {
                        UtilNFCeCalculos.calcularValores(this.getNFCe());
                    }
                    StaticObjects.setNfceAberta(this.getNFCe());
                    this.clearDescricaoUltimoProduto();
                    this.closeConnectionBalanca();
                    this.mostrarAvisosFechamento();
                    Main.get().mudaTela(Controllers.FECHAMENTO_NFCE);
                }
            }
            catch (ExceptionImpostoPisCofins ex) {
                Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", "Ocorreu um erro ao calcular o Pis/Cofins dos produtos da nota");
            }
            catch (ExceptionImpostoIcms ex) {
                Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", "Ocorreu um erro ao calcular o ICMS dos produtos da nota");
            }
            catch (ExceptionImpostoIPI ex) {
                Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExceptionImpostoCbsIbs ex) {
                Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExceptionAvaliadorExpressoes ex) {
                Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExceptionInvalidData ex) {
                Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void mostrarAvisosFechamento() {
        Optional<NFCeItem> found = this.getNFCe().getItens().stream().filter(i -> ToolMethods.isEquals((Object)i.getProduto().getEmitirReceitaAgro(), (Object)1)).findFirst();
        if (found.isPresent()) {
            Alerts.showAlertInfo("Alguns produtos requerem que voc\u00ea emita receita agron\u00f4mica, por exemplo " + String.valueOf(found.get().getProduto()));
        }
    }

    private void atualizaStatusElementoTable(Usuario usuario) {
        this.rowFactory.getStyledRowIndices().removeAll((Object[])new Integer[0]);
        if (this.tableItens.getSelectionModel().getSelectedItem() != null) {
            this.inativaItem((NFCeItem)this.tableItens.getSelectionModel().getSelectedItem(), usuario);
            UtilNFCe.aplicarDescontoPromocionalPedido((NFCeItem)this.tableItens.getSelectionModel().getSelectedItem(), this.getNFCe());
            this.atualizaCampoSubTotal(true);
            this.rowFactory.getStyledRowIndices().add((Object)this.tableItens.getSelectionModel().getFocusedIndex());
            this.tableItens.setItems(FXCollections.observableArrayList(this.getNFCe().getItens()));
            this.tableItens.refresh();
        }
    }

    private void inativaItem(NFCeItem item, Usuario usuario) {
        boolean achou = false;
        for (NFCeItem iten : this.getNFCe().getItens()) {
            if (!iten.getNumeroItem().equals(item.getNumeroItem())) continue;
            iten.setStatus((short)0);
            iten.setStatusOriginal((short)0);
            if (item.getPreAbastecimento() != null) {
                UtilCentralAbastecimento.get().setItemNTAbastCanc(true);
            }
            if (usuario != null) {
                iten.setUsuarioCancelamento(usuario);
            }
            achou = true;
            break;
        }
        if (!achou) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel cancelar o item. Consulte suporte t\u00e9cnico.");
        }
        StaticObjects.refreshNFCe();
    }

    private void setProdutosTable(NFCe nfce) {
        this.columnUM.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeItem)cellData.getValue()).getProduto().getUnidadeMedida().getSigla()));
        this.columnCodBarras.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeItem)cellData.getValue()).getCodigoBarras()));
        this.columnCodBarras.setCellFactory((Callback)new Callback<TableColumn<NFCeItem, String>, TableCell<NFCeItem, String>>(){

            public TableCell<NFCeItem, String> call(TableColumn<NFCeItem, String> param) {
                TableCell<NFCeItem, String> cell = new TableCell<NFCeItem, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(VendaNFCeController.this.columnCodBarras.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnNmrItem.setCellValueFactory((Callback)new PropertyValueFactory("numeroItem"));
        this.columnProduto.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)((NFCeItem)param.getValue()).getProduto().getNome());
            }
        });
        this.columnProduto.setCellFactory((Callback)new Callback<TableColumn<NFCeItem, String>, TableCell<NFCeItem, String>>(){

            public TableCell<NFCeItem, String> call(TableColumn<NFCeItem, String> param) {
                TableCell<NFCeItem, String> cell = new TableCell<NFCeItem, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(VendaNFCeController.this.columnProduto.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnQuantidade.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)MaskField.double3Casas(((NFCeItem)param.getValue()).getQuantidadeComercial()));
            }
        });
        this.columnVlrDesconto.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeItem)param.getValue()).getValorDesconto()));
            }
        });
        this.columnVlrTot.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeItem)param.getValue()).getValorTotal()));
            }
        });
        this.columnVlrUnitario.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)MaskField.double3Casas(((NFCeItem)param.getValue()).getValorUnitarioComercial()));
            }
        });
        this.columIdCodAux.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)(VendaNFCeController.this.exibirProduto == 1 ? ((NFCeItem)param.getValue()).getProduto().getCodigoAuxiliar() : String.valueOf(((NFCeItem)param.getValue()).getProduto().getIdentificador())));
            }
        });
        this.columIdCodAux.setCellFactory((Callback)new Callback<TableColumn<NFCeItem, String>, TableCell<NFCeItem, String>>(){

            public TableCell<NFCeItem, String> call(TableColumn<NFCeItem, String> param) {
                TableCell<NFCeItem, String> cell = new TableCell<NFCeItem, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(VendaNFCeController.this.columIdCodAux.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.tableItens.setItems(FXCollections.observableArrayList(nfce.getItens()));
    }

    private void criaNFCe() {
        if (this.getNFCe() == null) {
            this.rowFactory.getStyledRowIndices().clear();
            StaticObjects.setNfceAberta(UtilNFCe.createNFCeModelo65(null));
            Main.get().getFooterController().atualizaStatusModeloNFCe();
        }
    }

    private void setaDadosCampos(NFCe nfce) {
        try {
            UtilNFCeCalculos.calcularValores(nfce);
            this.tableItens.setItems(FXCollections.observableArrayList(nfce.getItens()));
            this.setProdutosTable(nfce);
            this.tfSubTotalNFCe.setDouble(nfce.getTotalizadores().getValorTotalNFe());
            this.visibleAndSetRepresentante(nfce.getRepresentante() != null);
            this.visibleAndSetCliente(nfce.getUnidadeFatCliente() != null);
            for (NFCeItem item : this.tableItens.getItems()) {
                if (item.getStatus() != 0) continue;
                this.tableItens.getSelectionModel().select((Object)item);
                this.atualizaStatusElementoTable(null);
            }
            this.tableItens.getSelectionModel().select(null);
        }
        catch (ExceptionImpostoIcms | ExceptionImpostoIPI | ExceptionImpostoPisCofins | ExceptionImpostoCbsIbs ex) {
            Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    private NFCe getNFCe() {
        if (this.nfcePesquisa != null) {
            return this.nfcePesquisa;
        }
        return StaticObjects.getNfceAberta();
    }

    private void configureTable() {
        Platform.runLater(() -> {
            double totalWidth = this.tableItens.getWidth();
            this.columnProduto.setMinWidth(totalWidth * 31.0 / 100.0);
            this.columnProduto.setMaxWidth(totalWidth * 31.0 / 100.0);
            this.columnVlrTot.setMinWidth(totalWidth * 9.0 / 100.0);
            this.columnVlrTot.setMaxWidth(totalWidth * 9.0 / 100.0);
            this.columnVlrUnitario.setMinWidth(totalWidth * 9.0 / 100.0);
            this.columnVlrUnitario.setMaxWidth(totalWidth * 9.0 / 100.0);
            this.columnCodBarras.setMinWidth(totalWidth * 11.0 / 100.0);
            this.columnCodBarras.setMaxWidth(totalWidth * 11.0 / 100.0);
            this.columnQuantidade.setMinWidth(totalWidth * 7.0 / 100.0);
            this.columnQuantidade.setMaxWidth(totalWidth * 7.0 / 100.0);
            this.columnVlrDesconto.setMinWidth(totalWidth * 8.0 / 100.0);
            this.columnVlrDesconto.setMaxWidth(totalWidth * 8.0 / 100.0);
            this.columnUM.setMinWidth(totalWidth * 6.0 / 100.0);
            this.columnUM.setMaxWidth(totalWidth * 6.0 / 100.0);
            this.columIdCodAux.setMinWidth(totalWidth * 11.0 / 100.0);
            this.columIdCodAux.setMaxWidth(totalWidth * 11.0 / 100.0);
            this.columnNmrItem.setMinWidth(totalWidth * 5.0 / 100.0);
            this.columnNmrItem.setMaxWidth(totalWidth * 5.0 / 100.0);
        });
        this.columnVlrDesconto.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnVlrTot.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnVlrUnitario.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnQuantidade.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columIdCodAux.setStyle("-fx-alignment: TOP_CENTER;");
        this.columnCodBarras.setStyle("-fx-alignment: TOP_CENTER;");
        this.tableItens.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableItens.setStyle("-fx-table-cell-border-color: transparent;");
        this.tableItens.setRowFactory(this.rowFactory);
    }

    private void atualizaCampoSubTotal(Boolean calcularImpostos) {
        if (calcularImpostos.booleanValue()) {
            try {
                UtilNFCeCalculos.calcularValoresBasicosSemCalcImp(this.getNFCe());
            }
            catch (Exception ex) {
                Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", ex.getMessage());
            }
        }
        this.tfSubTotalNFCe.setDouble(this.getNFCe().getTotalizadores().getValorTotalNFe());
    }

    private void desabilitaTableHabilitaGIF() {
        Main.get().getFooterController().atualizaStatusModeloNFCe();
        this.clearDescricaoUltimoProduto();
        this.tableItens.setItems(FXCollections.observableArrayList(new LinkedList()));
        this.tableItens.setVisible(false);
        this.setFieldClienteAndRepresentante();
        try {
            if (StaticObjects.getOpcoes().getLogoNfce() != null) {
                this.logo = new Image((InputStream)new ByteArrayInputStream(StaticObjects.getOpcoes().getLogoNfce()));
            } else if (Main.class.getResource("/images/main_image.gif") != null) {
                this.logo = new Image(Main.class.getResource("/images/main_image.gif").toURI().toString());
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    VendaNFCeController.this.image.setVisible(true);
                    VendaNFCeController.this.image.setImage(VendaNFCeController.this.logo);
                    VendaNFCeController.this.image.setFitWidth(VendaNFCeController.this.tableItens.getWidth());
                    VendaNFCeController.this.image.setFitHeight(VendaNFCeController.this.tableItens.getHeight());
                    VendaNFCeController.this.gridVenda.add((Node)VendaNFCeController.this.image, 3, 0);
                }
            });
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError("Erro", ex.getMessage());
        }
    }

    public void habilitaTable() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                VendaNFCeController.this.image.setVisible(false);
                VendaNFCeController.this.gridVenda.getChildren().remove((Object)VendaNFCeController.this.image);
                VendaNFCeController.this.tableItens.setVisible(true);
                VendaNFCeController.this.configureTable();
            }
        });
    }

    private void cancelarNFCe() throws ExceptionImpostoPisCofins, ExceptionImpostoIcms {
        try {
            NFCe selected = this.getNFCe();
            if (selected == null) {
                Alerts.showAlertError("Erro", "Selecione uma NFCe para continuar!");
                return;
            }
            UtilNFCeCancelamento.confirmaCancelamentoNFCe(selected);
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            Alerts.showAlertError("Houve um erro ao realizar o cancelamento. Tente Novamente mais tarde.");
            StaticObjects.getNfceAberta().setStatus(EnumConstNFeStatus.NFCE_CRIADA_ENVIADA_SEM_RET.getValue());
            StaticObjects.refreshNFCe();
            StaticObjects.clearNFCe();
            Main.get().mudaTela(Controllers.VENDA);
        }
        this.iniciaNFCeAndFindPessoa();
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent event) {
        switch (event.getCode()) {
            case F1: {
                if (this.tfQuantidade.isFocused()) {
                    this.tfProduto.requestFocus();
                    break;
                }
                if (this.tfProduto.isFocused()) {
                    this.tfQuantidade.requestFocus();
                    this.threadBalanca.setStartBalanca(true);
                    break;
                }
                this.tfProduto.requestFocus();
                break;
            }
            case F2: {
                this.informaVendedor();
                break;
            }
            case F3: {
                this.informaConsumidor();
                break;
            }
            case F4: {
                this.pesquisarCliente();
                break;
            }
            case F5: {
                this.cancelaItemNFCeFocusTabela();
                break;
            }
            case F6: {
                this.irTelaConsultaPreVenda();
                break;
            }
            case F7: {
                try {
                    this.cancelarNFCe();
                }
                catch (ExceptionImpostoIcms | ExceptionImpostoPisCofins ex) {
                    Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError("Erro", ex.getMessage());
                }
                break;
            }
            case F8: {
                this.consultaItem();
                break;
            }
            case F9: {
                this.informaEnderecoEntrega();
                break;
            }
            case F10: {
                this.informaDadosTransporte();
                break;
            }
            case F11: {
                this.clearDescricaoUltimoProduto();
                Main.get().mudaTela(Controllers.PESQUISA_NFCE);
                break;
            }
            case F12: {
                this.fecharNFCe();
                break;
            }
            case ESCAPE: {
                this.sairVoltar();
                break;
            }
            case DELETE: {
                if (!this.tableItens.isFocused() || this.tableItens.getSelectionModel().getSelectedItem() == null) break;
                this.cancelaItem();
                break;
            }
            case ENTER: {
                if (!this.tableItens.isFocused() || this.tableItens.getSelectionModel().getSelectedItem() == null) break;
                this.descontoAcrescimoItem();
                break;
            }
            case UP: {
                if (!this.tfQuantidade.isFocused()) break;
                this.tfProduto.requestFocus();
                break;
            }
            case DOWN: {
                break;
            }
            case RIGHT: {
                if (!this.tfQuantidade.isFocused() && !this.tfProduto.isFocused()) break;
                this.tableItens.requestFocus();
                break;
            }
            case LEFT: {
                if (!this.tableItens.isFocused()) break;
                this.tfProduto.requestFocus();
                break;
            }
        }
    }

    private void pesquisarCliente() {
        this.clearDescricaoUltimoProduto();
        Main.get().showDialog(Controllers.PESQUISA_PESSOAS);
        this.setFieldClienteAndRepresentante();
    }

    private void confirmaCancelamentoItem(Usuario usuario) {
        Optional<ButtonType> type = Alerts.showQuestion("Deseja realmente cancelar esse item?");
        if (type.get() == ButtonType.OK) {
            Main.get().getHeaderController().setTextHeader("ITEM CANCELADO");
            this.atualizaStatusElementoTable(usuario);
            this.tableItens.getSelectionModel().select(null);
            this.resetFields();
        }
    }

    private void cancelaItem() {
        NFCeItem item = (NFCeItem)this.tableItens.getSelectionModel().getSelectedItem();
        if (ToolMethods.isEquals((Object)item.getStatus(), (Object)0)) {
            Alerts.showAlertError("Este item ja esta cancelado!");
            return;
        }
        if (UtilPermissaoUsuario.isPermitidoCancelarNFCeItem()) {
            this.confirmaCancelamentoItem(StaticObjects.getUsuario());
            return;
        }
        Alerts.showAlertError("Voc\u00ea n\u00e3o possui permiss\u00e3o para cancelar um item!");
        HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
        h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_CANCELAMENTO_ITEM);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getUsuario() == null) {
            Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o");
        } else {
            UtilPermissaoUsuario.createLogPermissaoUser(loginController.getUsuario(), EnumConstNFCeTipoAutenticacao.AUTENTICACAO_CANCELAMENTO_ITEM, item.getNfce(), null);
            this.confirmaCancelamentoItem(loginController.getUsuario());
        }
    }

    private NFCeOpcoes getOpcoes() {
        return StaticObjects.getOpcoes();
    }

    private void informaEnderecoEntrega() {
        this.criaNFCe();
        HashMap<Boolean, Boolean> h = new HashMap<Boolean, Boolean>();
        h.put(EnderecoEntregaNFCeController.isPedido, false);
        EnderecoEntregaNFCeController endEntregaController = (EnderecoEntregaNFCeController)Main.get().showDialog(Controllers.ENDERECO_ENTREGA_NFCe, h);
    }

    private void informaVendedor() {
        this.criaNFCe();
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("representante", this.getNFCe().getRepresentante());
        h.put("lastPath", Controllers.VENDA);
        VendedorController vendedorController = (VendedorController)Main.get().showDialog(Controllers.VENDEDOR, h);
        this.getNFCe().setRepresentante(vendedorController.getRepresentanteNFCe());
        if (this.getNFCe() != null && this.getNFCe().getRepresentante() != null) {
            for (NFCeItem item : this.getNFCe().getItens()) {
                item.setRepresentante(vendedorController.getRepresentanteNFCe());
                TempPesquisaProduto comissao = this.getTempPesquisaProdutoComissao(item.getGradeCor());
                if (!ToolMethods.isNotNull((Object)comissao).booleanValue()) continue;
                item.setPercentualComissao(comissao.getPercComissao());
            }
        }
        this.visibleAndSetRepresentante(this.getNFCe().getRepresentante() != null);
        StaticObjects.refreshNFCe();
    }

    private void visibleAndSetRepresentante(Boolean visible) {
        this.lblVendedor.setVisible(visible.booleanValue());
        this.tfVendedor.setVisible(visible);
        if (visible.booleanValue()) {
            this.tfVendedor.setText(this.getNFCe().getRepresentante().toString());
        } else {
            this.tfVendedor.setText("");
        }
    }

    private void visibleAndSetCliente(Boolean visible) {
        this.gridCliente.setVisible(visible.booleanValue());
        if (visible.booleanValue()) {
            this.tfCliente.setText(this.getNFCe().getUnidadeFatCliente().getPessoa().getNome());
        } else {
            this.tfCliente.setText("");
        }
    }

    private void informaConsumidor() {
        this.criaNFCe();
        boolean infConsumidor = true;
        if (this.getNFCe().getUnidadeFatCliente() != null) {
            infConsumidor = false;
        }
        if (!ToolMethods.isEquals((Object)this.getNFCe().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            infConsumidor = false;
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("permite.inf.consumidor", infConsumidor);
        h.put("current_consumidor", this.getNFCe().getNfCeConsumidor());
        h.put("current_intermediador", this.getNFCe().getIntermediadorComercial());
        h.put("current_presenca", this.getNFCe().getIndicadorPresencaConsumidor());
        h.put("current_consumidor_final", this.getNFCe().getIndicadorConsumidorFinal());
        h.put("current_tipo_intermeadiador", this.getNFCe().getTipoIntermediadorComercial());
        ConsumidorController consumidorController = (ConsumidorController)Main.get().showDialog(Controllers.INFORMAR_CONSUMIDOR, h);
        this.getNFCe().setNfCeConsumidor(consumidorController.getConsumidor());
        StaticObjects.refreshNFCe();
    }

    private void cancelaItemNFCeFocusTabela() {
        this.tableItens.getSelectionModel().selectLast();
        this.tableItens.requestFocus();
    }

    private void configureButtons() {
        this.btnFecharNFCe.setOnAction(event -> {
            this.getNFCe();
            this.fecharNFCe();
        });
        this.btnCamposProduto.setOnAction(event -> this.focusCamposProdutoQtd());
        this.btnCancItem.setOnAction(event -> this.cancelaItemNFCeFocusTabela());
        this.btnCliente.setOnAction(event -> {
            StaticObjects.setUltimaPagina(Controllers.VENDA);
            this.clearDescricaoUltimoProduto();
            Main.get().showDialog(Controllers.PESQUISA_PESSOAS);
            this.setFieldClienteAndRepresentante();
        });
        this.btnConsultaItem.setOnAction(event -> this.consultaItem());
        this.btnSair.setOnAction(event -> this.sairVoltar());
        this.btnCancNFCe.setOnAction(event -> {
            try {
                this.cancelarNFCe();
            }
            catch (ExceptionImpostoIcms | ExceptionImpostoPisCofins ex) {
                Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", ex.getMessage());
            }
        });
        this.btnVendedor.setOnAction(event -> this.informaVendedor());
        this.btnPreVenda.setOnAction(event -> this.irTelaConsultaPreVenda());
        this.btnDadosTransp.setOnAction(event -> this.informaDadosTransporte());
        this.btnEnderecoEntrega.setOnAction(event -> this.informaEnderecoEntrega());
        this.btnConsumidor.setOnAction(event -> this.informaConsumidor());
        this.btnPesqNFCe.setOnAction(event -> {
            this.clearDescricaoUltimoProduto();
            Main.get().mudaTela(Controllers.PESQUISA_NFCE);
        });
        this.btnDadosVeiculos.setOnAction(event -> {
            if (this.isValidShowDadosVeiculos()) {
                Main.get().showDialog(Controllers.DADOS_VEICULO);
            }
        });
        this.tfQuantidade.setOnAction(event -> this.tfQuantidade.selectAll());
        this.tableItens.setOnMouseClicked(event -> {
            NFCeItem item = (NFCeItem)this.tableItens.getSelectionModel().getSelectedItem();
            if (item != null) {
                this.tfVlrUnitario.setDouble(item.getValorUnitarioComercial());
                this.tfVlrDesc.setDouble(item.getValorDesconto());
            }
        });
        this.tableItens.setOnKeyReleased(event -> {
            NFCeItem item = (NFCeItem)this.tableItens.getSelectionModel().getSelectedItem();
            if (item != null) {
                this.tfVlrUnitario.setDouble(item.getValorUnitarioComercial());
                this.tfVlrDesc.setDouble(item.getValorDescontoInf());
            }
        });
    }

    private void sairVoltar() {
        if (StaticObjects.getNfceAberta() == null) {
            this.confirma();
            return;
        }
        StaticObjects.checaExcluiNFCeTemp();
        if (StaticObjects.getNfceAberta() == null) {
            try {
                this.confirma();
                return;
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex);
                Alerts.showAlertInfo("N\u00e3o foi poss\u00edvel cancelar automaticamente a NFCe: " + ex.getMessage());
            }
        }
        this.showDialogConfirmaSair();
    }

    private void showDialogConfirmaSair() {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("label", "Existe uma NFCe aberta, deseja realmente sair?");
        h.put("controller", this);
        Main.get().showDialog(Controllers.DIALOG_CONFIRMA_SAIR_VENDA, h);
    }

    private void focusCamposProdutoQtd() {
        this.resetFields();
        if (this.tfProduto.isFocused()) {
            this.tfQuantidade.requestFocus();
        } else {
            this.tfProduto.requestFocus();
        }
    }

    private void resetFields() {
        this.tfVlrUnitario.clear();
        this.tfProduto.clear();
        this.tfQuantidade.setDouble(1.0);
        this.tfVlrDesc.clear();
        this.produtos = new TreeSet();
    }

    public void onItemListener(Object data) {
        try {
            TempPesquisaProdutoConverter obj = (TempPesquisaProdutoConverter)data;
            this.setTempPesquisaProduto(obj.getTempPesqProd(), true);
            this.tfProduto.setText(obj.getTempPesqProd().getNomeProduto());
            this.criaNFCeItem(false);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            Alerts.showAlertError("Ocorreu um erro: " + ex.getMessage());
        }
    }

    private void criaNFCeItem(boolean codigoPesavel) {
        this.criaNFCeItem(codigoPesavel, 0.0);
    }

    private void criaNFCeItem(boolean codigoPesavel, Double valorTotalBruto) {
        if (this.getTempPesquisaProduto() == null) {
            return;
        }
        Main.get().getHeaderController().setVisible(true);
        Main.get().getHeaderController().setTextHeader(this.getTempPesquisaProduto().getNomeProduto());
        if (this.getTempPesquisaProduto().getValorUnitario() <= 0.0) {
            Alerts.showAlertError("Produto sem pre\u00e7o ou tabela expirada. Confira o per\u00edodo de vig\u00eancia da tabela e se o item est\u00e1 na mesma e ativo.");
            this.clearDescricaoUltimoProduto();
            this.setTempPesquisaProduto(null, false);
            return;
        }
        if (!codigoPesavel && ToolMethods.isEquals((Object)this.getTempPesquisaProduto().getQtdNaoFracionada(), (Object)0) && !this.threadBalanca.isStartBalanca()) {
            this.tfQuantidade.requestFocus();
            this.threadBalanca.setStartBalanca(true);
            return;
        }
        if (!this.tableItens.isVisible()) {
            this.habilitaTable();
        }
        if (this.tfQuantidade.getDouble() > 1000000.0) {
            Alerts.showAlertInfo("Quantidade invalida.");
            return;
        }
        this.criaNFCe();
        this.tfVlrUnitario.setDouble(this.getTempPesquisaProduto().getValorUnitario());
        this.tfVlrDesc.setDouble(this.tfVlrDesc.getDouble() + this.getTempPesquisaProduto().getVlrDescontoPromocional());
        if (this.tfQuantidade.getDouble() == 0.0) {
            this.tfQuantidade.setDouble(this.getTempPesquisaProduto().getQtdMinVenda());
        }
        if (this.tfQuantidade.getDouble() == 0.0) {
            this.tfQuantidade.setDouble(1.0);
        }
        this.threadBalanca.setStartBalanca(false);
        Double qtd = this.tfQuantidade.getDouble();
        if (qtd <= 0.0) {
            Alerts.showAlertInfo("Quantidade informada \u00e9 inv\u00e1lida. Quantidade deve ser maior que 0.");
            return;
        }
        if (this.getTempPesquisaProduto().getQtdMinVenda() != null && this.getTempPesquisaProduto().getQtdMinVenda() > 0.0 && qtd < this.getTempPesquisaProduto().getQtdMinVenda()) {
            Alerts.showAlertInfo("Quantidade informada \u00e9 menor que a quantidade minima comercializada. Quantidade m\u00ednima: " + MaskField.monetaryField(this.getTempPesquisaProduto().getQtdMinVenda()));
            return;
        }
        if (this.getTempPesquisaProduto().getQtdMaxVenda() != null && this.getTempPesquisaProduto().getQtdMaxVenda() > 0.0 && this.tfQuantidade.getDouble() > this.getTempPesquisaProduto().getQtdMaxVenda()) {
            Alerts.showAlertInfo("Quantidade informada \u00e9 maior que a quantidade m\u00e1xima comercializada. Quantidade m\u00e1xima: " + MaskField.monetaryField(this.getTempPesquisaProduto().getQtdMaxVenda()));
            return;
        }
        if (this.getTempPesquisaProduto().getQtdNaoFracionada() != null && this.getTempPesquisaProduto().getQtdNaoFracionada() == 1 && qtd % 1.0 != 0.0) {
            Alerts.showAlertInfo("Quantidade informada n\u00e3o pode ser fracionada. ");
            return;
        }
        ServiceGradeCor service = Main.getBean(ServiceGradeCor.class);
        GradeCor gradeCor = (GradeCor)service.get(this.getTempPesquisaProduto().getIdGradeCor());
        Produto produto = gradeCor.getProdutoGrade().getProduto();
        if (ToolMethods.isEquals((Object)produto.getPermitirVendaSomenteAutomacao(), (Object)1)) {
            Alerts.showAlertInfo("A venda deste produto esta liberada somente pela automa\u00e7\u00e3o!");
            return;
        }
        if (!this.obrigarInformarVendedor().booleanValue()) {
            return;
        }
        ModeloFiscal modeloFiscal = new AuxModeloFiscal().getModeloFiscalNFCe(produto, this.getNFCe().getUnidadeFatCliente(), this.getNFCe().getNfcePessoa(), this.getNFCe().getEnderecoEntrega(), this.getNFCe().getNaturezaOperacao(), this.getNFCe().getEmpresa(), true);
        if (modeloFiscal == null) {
            return;
        }
        Representante old = this.getNFCe().getRepresentante();
        try {
            TempPesquisaProduto comissao;
            if (!ToolMethods.isEquals((Object)old, (Object)this.getNFCe().getRepresentante()) && ToolMethods.isNotNull((Object)(comissao = this.getTempPesquisaProdutoComissao(gradeCor))).booleanValue()) {
                this.getTempPesquisaProduto().setPercComissao(comissao.getPercComissao());
                this.getTempPesquisaProduto().setPercComissaoMin(comissao.getPercComissaoMin());
                this.getTempPesquisaProduto().setPercComissaoMax(comissao.getPercComissaoMax());
                this.getTempPesquisaProduto().setAvaliadorExpressoesComissao(comissao.getAvaliadorExpressoesComissao());
            }
            ParamTribCbsIbsClass paramTrib = new AuxParamTribCbsIbs().getParametrizacaoNFe(this.getNFCe(), produto, modeloFiscal);
            NFCeItem item = new NFCeItem();
            UtilNFCe.getNewNFCeItem(item, this.getNFCe(), gradeCor, modeloFiscal, paramTrib, this.tfQuantidade.getDouble(), this.getTempPesquisaProduto().getPercComissao(), this.tfVlrUnitario.getDouble(), valorTotalBruto, this.getTempPesquisaProduto().getPrecoCusto(), StaticObjects.getOpcoes().getCentroEstoque(), this.codigoBarrasTemp, codigoPesavel);
            Boolean validar = this.informarTipoMedicamento(item);
            if (!validar.booleanValue()) {
                Alerts.showAlertError("Item n\u00e3o registrado, pois n\u00e3o foi informado as informa\u00e7\u00f5es do lote de fabrica\u00e7\u00e3o para um produto de medicamento!");
                this.resetFields();
                this.tfProduto.requestFocus();
                this.tfQuantidade.setDouble(1.0);
                this.setTempPesquisaProduto(null, true);
                return;
            }
            this.getNFCe().getItens().add(item);
            UtilNFCe.aplicarDescontoPromocionalPedido(item, this.getNFCe());
            if (ToolMethods.isEquals((Object)this.getNFCe().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
                UtilNFCeCalculos.calcularValoresBasicosSemCalcImp(this.getNFCe());
            } else {
                UtilNFCeCalculos.calcularValores(this.getNFCe());
            }
            StaticObjects.refreshNFCe();
            this.codigoBarrasTemp = "";
            Platform.runLater(() -> {
                this.atualizaCampoSubTotal(false);
                this.setProdutosTable(this.getNFCe());
                this.tableItens.refresh();
                if (this.tableItens.getItems() != null && !this.tableItens.getItems().isEmpty()) {
                    this.tableItens.scrollTo(this.tableItens.getItems().size());
                }
            });
        }
        catch (ExceptionAvaliadorExpressoes | ExceptionImpostoIcms | ExceptionImpostoIPI | ExceptionImpostoPisCofins | ExceptionInvalidData | ExceptionImpostoCbsIbs ex) {
            Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.resetFields();
        this.setTempPesquisaProduto(null, true);
        this.tfQuantidade.setDouble(1.0);
        this.tfProduto.requestFocus();
    }

    private boolean getAllItensCancelados() {
        for (NFCeItem i : this.getNFCe().getItens()) {
            if (!i.getStatus().equals((short)1)) continue;
            return false;
        }
        return true;
    }

    private void irTelaConsultaPreVenda() {
        StaticObjects.checaExcluiNFCeTemp();
        if (StaticObjects.getNfceAberta() == null || StaticObjects.getNfceAberta().getItens().isEmpty()) {
            HashMap<String, ControllerPath> h = new HashMap<String, ControllerPath>();
            h.put("lastPath", Controllers.PRE_VENDA);
            this.clearDescricaoUltimoProduto();
            Main.get().mudaTela(Controllers.CONSULTA_PRE_VENDA);
        } else {
            Alerts.showAlertError("Existe uma nota em aberto, primeiro finalize a mesma!");
        }
    }

    private Boolean obrigarInformarVendedor() {
        if (this.getNFCe().getRepresentante() != null) {
            this.visibleAndSetRepresentante(true);
            return true;
        }
        HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
        h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_REPRESENTANTE);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getRepresentante() == null) {
            Alerts.showAlertError("O Usuario n\u00e3o informado ou o mesmo n\u00e3o \u00e9 um representante. Informe um usu\u00e1rio valido para finalizar o processo!");
            return false;
        }
        this.getNFCe().setRepresentante(loginController.getRepresentante());
        this.visibleAndSetRepresentante(true);
        return true;
    }

    private void descontoAcrescimoItem() {
        NFCeItem item = (NFCeItem)this.tableItens.getSelectionModel().getSelectedItem();
        HashMap<String, Serializable> h = new HashMap<String, Serializable>();
        h.put("item", item);
        h.put("doc", StaticObjects.getNfceAberta());
        Main.get().showDialog(Controllers.DIALOG_DESCONTO_ACRESC_ITEM_VENDA, h);
        this.tfSubTotalNFCe.setDouble(this.getNFCe().getTotalizadores().getValorTotalNFe());
        this.tableItens.getItems().clear();
        this.tableItens.setItems(FXCollections.observableArrayList(this.getNFCe().getItens()));
        this.tableItens.refresh();
        this.tableItens.getSelectionModel().clearSelection();
        this.tfProduto.requestFocus();
        this.tfQuantidade.setDouble(1.0);
    }

    private void iniciaNFCeAndFindPessoa() {
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAbrirTelaClienteVenda(), (Object)1) && StaticObjects.getNfceAberta() == null) {
            this.clearDescricaoUltimoProduto();
            this.criaNFCe();
            Main.get().getFooterController().atualizaStatusModeloNFCe();
            Main.get().showDialog(Controllers.PESQUISA_PESSOAS);
            this.setFieldClienteAndRepresentante();
        }
        if (this.getNFCe() != null) {
            this.setProdutosTable(this.getNFCe());
            this.setaDadosCampos(this.getNFCe());
        } else {
            this.clearDescricaoUltimoProduto();
            this.tfSubTotalNFCe.setDouble(0.0);
            this.desabilitaTableHabilitaGIF();
        }
    }

    private void closeConnectionBalanca() {
        if (StaticObjects.getPesoLib() != null) {
            Platform.runLater(() -> StaticObjects.getPesoLib().fecha());
        }
    }

    private void clearDescricaoUltimoProduto() {
        Main.get().getHeaderController().setVisible(false);
        Main.get().getHeaderController().setTextHeader("");
    }

    private List<TempPesquisaProduto> getProdutosPrecos(Integer page, Integer registrosPorCarregamento) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        HelperPrecos helper = Main.getBean(HelperPrecos.class);
        List<TempPesquisaProduto> prod = null;
        prod = this.getNFCe() != null ? helper.getProdutos(this.tfProduto.getText(), StaticObjects.getEmpresa(), this.getNFCe().getUnidadeFatCliente(), StaticObjects.getOpcoes(), this.getNFCe().getRepresentante(), StaticObjects.getUsuario(), StaticObjects.getGrupo(), this.getNFCe().getDadosTransporte().getTipoFrete(), this.getNFCe().getNaturezaOperacao(), this.getNFCe().getCondicoesPagamento(), registrosPorCarregamento, page) : helper.getProdutos(this.tfProduto.getText(), StaticObjects.getEmpresa(), null, StaticObjects.getOpcoes(), null, StaticObjects.getUsuario(), StaticObjects.getGrupo(), null, null, null, registrosPorCarregamento, page);
        return prod;
    }

    private void findProduto() {
        try {
            TempPesquisaProduto.TextProduto found = new AuxProduto().getProdutosPrecos(this.tfProduto.getText(), this.getNFCe());
            if (found == null) {
                return;
            }
            List<TempPesquisaProduto> prod = found.getTempPesquisaProduto();
            if (prod == null || prod.isEmpty()) {
                Alerts.showAlertInfo("Produto n\u00e3o encontrado ou sem pre\u00e7o ou tabela expirada. Confira o per\u00edodo de vig\u00eancia da tabela e se o item est\u00e1 na mesma e ativo. Ou ainda verifique se o produto cont\u00e9m grade ou se o c\u00f3digo de barras est\u00e1 inativo!");
            } else {
                if (found.isCodigoPesavel()) {
                    this.tfQuantidade.setDouble(found.getQuantidade());
                }
                this.setTempPesquisaProduto(prod.get(0), false);
                this.criaNFCeItem(found.isCodigoPesavel(), found.getValor());
                this.tfProduto.clear();
            }
        }
        catch (ExceptionTabelaPrecosDinamica ex) {
            this.logger.error((Throwable)ex);
            Alerts.showAlertInfo("Erro ao carregar os produtos/pre\u00e7os: " + ex.getMessage());
        }
        catch (ExceptionAvaliadorExpressoes ex) {
            this.logger.error((Throwable)ex);
            Alerts.showAlertInfo("Erro ao carregar os produtos/pre\u00e7os: " + ex.getMessage());
        }
    }

    @Override
    public void confirma() {
        StaticObjects.setVendasController(null);
        this.clearDescricaoUltimoProduto();
        if (Main.get().getLastControllerPath().equals(Controllers.ABASTECIMENTO)) {
            Main.get().mudaTela(Controllers.ABASTECIMENTO);
        } else {
            Main.get().mudaTela(Controllers.MENU_PRINCIPAL);
        }
    }

    @Override
    public void cancela() {
    }

    @Override
    public void pesoLido(Double peso) {
        this.tfQuantidade.setDouble(peso);
    }

    @Override
    public void error(Throwable t) {
        t.printStackTrace();
        this.tfQuantidade.setDouble(1.0);
    }

    public TempPesquisaProduto getTempPesquisaProduto() {
        return this.tempPesquisaProduto;
    }

    public void setTempPesquisaProduto(TempPesquisaProduto tempPesquisaProduto, boolean showDesc) {
        this.tempPesquisaProduto = tempPesquisaProduto;
        if (tempPesquisaProduto != null && showDesc) {
            this.tfProduto.setText(tempPesquisaProduto.getNomeProduto());
        }
    }

    public void setTfProduto(AutoCompleteLazyLoadProduto tfProduto) {
        this.tfProduto = tfProduto;
    }

    public AutoCompleteLazyLoadProduto getTfProduto() {
        return this.tfProduto;
    }

    private boolean isValidShowDadosVeiculos() {
        if (this.getNFCe() == null) {
            Alerts.showAlertError("Primeiro crie uma NFC-e/NF-e!");
            return false;
        }
        return true;
    }

    private void consultaItem() {
        this.clearDescricaoUltimoProduto();
        this.closeConnectionBalanca();
        HashMap<String, Serializable> h = new HashMap<String, Serializable>();
        h.put("qtd_pesquisa_prod", this.tfQuantidade.getDouble());
        if (StaticObjects.getNfceAberta() != null) {
            h.put("unidade_fat_cliente_inf_nfce", StaticObjects.getNfceAberta().getUnidadeFatCliente());
        }
        Main.get().mudaTela(Controllers.CONSULTA_ITEM, h);
    }

    @Override
    public SortedSet loadingMoreItems(String text, int page, int registrosPorCarregamento) {
        this.produtos = new TreeSet();
        if (!text.isEmpty() && text.length() >= 3 && !ToolString.isAIntegerNumber((String)text)) {
            try {
                List<TempPesquisaProduto> prod = this.getProdutosPrecos(page, registrosPorCarregamento);
                this.produtos = TempPesquisaProdutoConverter.converterList(prod);
            }
            catch (ExceptionTabelaPrecosDinamica ex) {
                this.logger.error((Throwable)ex);
                Alerts.showAlertInfo("Erro ao carregar os produtos/pre\u00e7os: " + ex.getMessage());
            }
            catch (ExceptionAvaliadorExpressoes ex) {
                this.logger.error((Throwable)ex);
                Alerts.showAlertInfo("Erro ao carregar os produtos/pre\u00e7os: " + ex.getMessage());
            }
        }
        return this.produtos;
    }

    private boolean informarTipoMedicamento(NFCeItem item) {
        if (!ToolMethods.isStrWithData((String)item.getProduto().getCodAnvisa())) {
            return true;
        }
        if (this.getNFCe() == null || ToolMethods.isEquals((Object)this.getNFCe().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return true;
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoInformacaoRastreabilidade(), (Object)1)) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            Produto p = item.getProduto();
            params.put("produto", p);
            params.put("itemNFCe", item);
            Main.get().showDialog(Controllers.DIALOG_INFORMA_LOTE_MEDICAMENTO, params);
            if (!ToolMethods.isStrWithData((String)item.getNrLoteFabricacao()) || ToolMethods.isNull((Object)item.getDataFabricacao()).booleanValue() || ToolMethods.isNull((Object)item.getDataValidade()).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    private TempPesquisaProduto getTempPesquisaProdutoComissao(GradeCor gradeCor) {
        try {
            HelperPrecos helper = Main.getBean(HelperPrecos.class);
            TempPesquisaProduto comissao = helper.getComissao(gradeCor.getProdutoGrade().getProduto(), StaticObjects.getNfceAberta().getEmpresa(), StaticObjects.getNfceAberta().getUnidadeFatCliente(), StaticObjects.getOpcoes(), StaticObjects.getNfceAberta().getRepresentante(), StaticObjects.getUsuario(), StaticObjects.getGrupo(), StaticObjects.getNfceAberta().getDadosTransporte().getTipoFrete(), StaticObjects.getNfceAberta().getNaturezaOperacao(), StaticObjects.getNfceAberta().getCondicoesPagamento());
            return comissao;
        }
        catch (ExceptionAvaliadorExpressoes | ExceptionTabelaPrecosDinamica ex) {
            Logger.getLogger(PreVendaController.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

