/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.venda.auxmodelofiscal;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.cfop.EnumConstCfop;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementorrules.cfop.CompCfop;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.exceptions.ExceptionModeloFiscalNotFound;
import com.touchcomp.touchnfce.model.CategoriaPessoa;
import com.touchcomp.touchnfce.model.Cfop;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.EnderecoEntregaPedido;
import com.touchcomp.touchnfce.model.ModeloDocFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscalCatPessoa;
import com.touchcomp.touchnfce.model.ModeloFiscalEmpresa;
import com.touchcomp.touchnfce.model.ModeloFiscalNaturezaOperacao;
import com.touchcomp.touchnfce.model.ModeloFiscalProdutos;
import com.touchcomp.touchnfce.model.ModeloFiscalUF;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeEnderecoEntrega;
import com.touchcomp.touchnfce.model.NFCePessoa;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.model.UnidadeFederativa;
import com.touchcomp.touchnfce.service.impl.ServiceCfop;
import com.touchcomp.touchnfce.service.impl.ServiceModeloFiscal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;

public class AuxModeloFiscal {
    public ModeloFiscal getModeloFiscalPedido(Produto produto, UnidadeFatCliente unidade, EnderecoEntregaPedido endEntrega, NaturezaOperacao naturezaOperacao, Empresa empresa, boolean debug) {
        UnidadeFederativa uf = this.getUFPrestServico(endEntrega, unidade, empresa);
        return this.getModeloFiscalNFCe(produto, unidade, uf, naturezaOperacao, empresa, debug);
    }

    public ModeloFiscal getModeloFiscalNFCe(Produto produto, UnidadeFatCliente unidade, NFCePessoa nfCePessoa, NFCeEnderecoEntrega endEntrega, NaturezaOperacao naturezaOperacao, Empresa empresa, boolean debug) {
        UnidadeFederativa uf = this.getUFPrestServico(nfCePessoa, unidade, empresa);
        return this.getModeloFiscalNFCe(produto, unidade, uf, naturezaOperacao, empresa, debug);
    }

    private ModeloFiscal getModeloFiscalNFCe(Produto produto, UnidadeFatCliente unidade, UnidadeFederativa ufPrestServico, NaturezaOperacao naturezaOperacao, Empresa empresa, boolean debug) {
        Date in = new Date();
        ModeloFiscal modelo = null;
        ServiceModeloFiscal serviceNFCeModeloFiscal = Main.getBean(ServiceModeloFiscal.class);
        CategoriaPessoa categoriaPessoa = null;
        if (naturezaOperacao.getModeloDocFiscal() != null && ToolMethods.isEquals((Object)naturezaOperacao.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            if (unidade == null) {
                Platform.runLater((Runnable)new Runnable(this){

                    @Override
                    public void run() {
                        Alerts.showAlertError("Para NFe \u00e9 necess\u00e1rio informar o cliente.");
                    }
                });
                return null;
            }
            categoriaPessoa = unidade.getCategoriaPessoa();
            if (categoriaPessoa == null && unidade != null && unidade.getCliente() != null && unidade.getCliente().getFaturamento() != null) {
                categoriaPessoa = unidade.getCliente().getFaturamento().getCategoriaPessoa();
            }
            if ((modelo = serviceNFCeModeloFiscal.getFirst(produto, categoriaPessoa, ufPrestServico, naturezaOperacao, unidade.getPessoa().getComplemento().getCnpj(), unidade.getPessoa().getComplemento().getContribuinteEstado(), unidade.getPessoa().getComplemento().getHabilitarSuframa(), empresa)) == null && debug) {
                Alerts.showAlertError("Modelo Fiscal n\u00e3o encontrado para:\n\n\nEmpresa: " + String.valueOf(empresa) + "\nCliente(ID Cliente- Id Unidade:Descri\u00e7\u00e3o): " + (unidade != null ? unidade.getCliente().getIdentificador() + " - " + unidade.getIdentificador() + ": " + unidade.toString() : null) + "\nNatureza Operacao: " + String.valueOf(naturezaOperacao) + "\nProduto: " + String.valueOf(produto) + "\nNCM: " + String.valueOf(produto.getNcm()) + "\nUF Cliente: " + String.valueOf(unidade.getPessoa().getEndereco().getCidade().getUf()) + "\nCategoria Pessoa: " + String.valueOf(categoriaPessoa != null ? categoriaPessoa : "N\u00e3o informado") + "\nCNPJ: " + unidade.getPessoa().getComplemento().getCnpj() + "\nSuframa: " + (ToolMethods.isEquals((Object)unidade.getPessoa().getComplemento().getHabilitarSuframa(), (Object)1) ? "Sim" : "Nao") + "\nInscrito Estado: " + this.getTextInscEst(unidade));
                try {
                    this.depurarModeloFiscalNFe(produto, categoriaPessoa, unidade.getPessoa().getEndereco().getCidade().getUf(), unidade, naturezaOperacao, unidade.getPessoa().getComplemento().getCnpj(), unidade.getPessoa().getComplemento().getContribuinteEstado(), unidade.getPessoa().getComplemento().getHabilitarSuframa(), empresa, this.getModeloFiscalAlvo(naturezaOperacao.getModeloDocFiscal()));
                }
                catch (ExceptionModeloFiscalNotFound ex) {
                    Logger.getLogger(AuxModeloFiscal.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError(ex.getMessage());
                    return null;
                }
            }
        } else {
            if (unidade != null) {
                categoriaPessoa = unidade.getCategoriaPessoa();
            }
            if (categoriaPessoa == null && unidade != null && unidade.getCliente() != null && unidade.getCliente().getFaturamento() != null) {
                categoriaPessoa = unidade.getCliente().getFaturamento().getCategoriaPessoa();
            }
            if ((modelo = serviceNFCeModeloFiscal.getFirst(produto, naturezaOperacao, empresa, categoriaPessoa, StaticObjects.getOpcoes().getUsarPesqCategoria(), StaticObjects.getOpcoes().getUsarPesqNcm(), StaticObjects.getOpcoes().getUsarPesqProduto())) == null && debug) {
                String msg = "Modelo Fiscal n\u00e3o encontrado para:\n\n\nEmpresa: " + String.valueOf(empresa) + "\nProduto: " + String.valueOf(produto) + "\nUF Empresa: " + String.valueOf(empresa.getPessoa().getEndereco().getCidade().getUf()) + "\nNatureza Operacao: " + String.valueOf(naturezaOperacao) + "\nNCM: " + String.valueOf(produto.getNcm());
                if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getUsarPesqCategoria(), (Object)1)) {
                    msg = msg + "\nCategoria Pessoa: " + String.valueOf(categoriaPessoa != null ? categoriaPessoa : "N\u00e3o informado");
                }
                msg = msg + "\n\n";
                msg = msg + "\nUsar Categoria:" + (ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getUsarPesqCategoria()) ? "Sim" : "N\u00e3o");
                msg = msg + "\nUsar NCM: " + (ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getUsarPesqNcm()) ? "Sim" : "N\u00e3o");
                msg = msg + "\nUsar Produto: " + (ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getUsarPesqProduto()) ? "Sim" : "N\u00e3o");
                Alerts.showAlertError(msg);
                try {
                    this.depurarModeloFiscalNFCe(produto, naturezaOperacao, empresa, this.getModeloFiscalAlvo(naturezaOperacao.getModeloDocFiscal()));
                }
                catch (ExceptionModeloFiscalNotFound ex) {
                    Logger.getLogger(AuxModeloFiscal.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError(ex.getMessage());
                    return null;
                }
            }
        }
        Date end = new Date();
        System.out.println("Tempo Pesquisa Modelo: " + ToolDate.difBetweenDatesInMiliseconds((Date)in, (Date)end));
        return modelo;
    }

    private String getTextInscEst(UnidadeFatCliente unidade) {
        if (ToolMethods.isEquals((Object)unidade.getPessoa().getComplemento().getContribuinteEstado(), (Object)EnumConstContrEstadoIcms.ISENTO.getEnumId()) || ToolMethods.isEquals((Object)unidade.getPessoa().getComplemento().getContribuinteEstado(), (Object)EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId())) {
            return "Isento/N\u00e3o Contribuinte";
        }
        return "Contribuinte/Inscrito";
    }

    public ModeloFiscal getModeloFiscalAlvo(ModeloDocFiscal modelo) {
        List<ModeloFiscal> modelos;
        ModeloFiscal selected;
        Optional<ButtonType> type = Alerts.showQuestion("Deseja depurar algum modelo para verificar o problema?");
        if (type.get() == ButtonType.OK && (selected = Alerts.showQuestion("", (modelos = Main.getBean(ServiceModeloFiscal.class).getModelosSaida(modelo)).toArray(), ModeloFiscal.class)) != null) {
            return selected;
        }
        return null;
    }

    public void depurarModeloFiscalNFe(Produto produto, CategoriaPessoa categoria, UnidadeFederativa uf, UnidadeFatCliente unidade, NaturezaOperacao naturezaOperacao, String cnpjCFF, Short contribEstComp, Short habilitarSuframa, Empresa empresa, ModeloFiscal modeloFiscal) throws ExceptionModeloFiscalNotFound {
        NaturezaOperacao natureza = naturezaOperacao;
        String cnpjCpf = unidade != null ? unidade.getPessoa().getComplemento().getCnpj() : null;
        Short contribuinteEstado = this.buildTipoInscEstadual(contribEstComp);
        boolean flagNatOpe = false;
        if (modeloFiscal != null) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            for (ModeloFiscalNaturezaOperacao modeloFiscalNaturezaOperacao : modeloFiscal.getNaturezaOperacao()) {
                if (!modeloFiscalNaturezaOperacao.getNaturezaOperacao().equals(natureza) || !modeloFiscalNaturezaOperacao.getAtivo().equals((short)1) || !modeloFiscalNaturezaOperacao.getNaturezaOperacao().getAtivo().equals((short)1)) continue;
                flagNatOpe = true;
                break;
            }
            if (!flagNatOpe) {
                throw new ExceptionModeloFiscalNotFound("A natureza de Opera\u00e7\u00e3o informada n\u00e3o confere com a(s) natureza(s) informada(s) no Modelo Fiscal ou est\u00e1 inativa.");
            }
            boolean flagCatPes = false;
            for (ModeloFiscalCatPessoa modeloFiscalCatPessoa : modeloFiscal.getCategoriaPessoa()) {
                if (!modeloFiscalCatPessoa.getCategoriaPessoa().equals(categoria) || !modeloFiscalCatPessoa.getAtivo().equals((short)1) || !modeloFiscalCatPessoa.getCategoriaPessoa().getAtivo().equals((short)1)) continue;
                flagCatPes = true;
                break;
            }
            if (!flagCatPes) {
                throw new ExceptionModeloFiscalNotFound("A Categoria de Pessoa informada n\u00e3o confere com a(s) categoria(s) informada(s) no Modelo Fiscal ou est\u00e1 inativa.");
            }
            boolean bl4 = false;
            for (ModeloFiscalUF modeloFiscalUF : modeloFiscal.getUnidadesFederativas()) {
                if (!modeloFiscalUF.getUnidadeFederativa().equals(modeloFiscalUF.getUnidadeFederativa()) || !modeloFiscalUF.getAtivo().equals((short)1)) continue;
                bl3 = true;
            }
            if (!bl3) {
                throw new ExceptionModeloFiscalNotFound("Dentre as UF's do Modelo Fiscal n\u00e3o existe a UF " + uf.toString() + " ou a UF est\u00e1 inativa dentro do Modelo Fiscal.");
            }
            boolean bl5 = false;
            for (ModeloFiscalEmpresa emp : modeloFiscal.getEmpresas()) {
                if (!emp.getEmpresa().equals(empresa) || !emp.getAtivo().equals((short)1)) continue;
                bl2 = true;
            }
            if (!bl2) {
                throw new ExceptionModeloFiscalNotFound("Dentre as Empresas do Modelo Fiscal n\u00e3o existe a Empresa " + empresa.toString() + " ou a empresa est\u00e1 inativa dentro do Modelo Fiscal.");
            }
            if (modeloFiscal.getTipoInscricaoEstadual() != 2) {
                if (modeloFiscal.getTipoInscricaoEstadual() == 0 && !contribuinteEstado.equals(EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId())) {
                    throw new ExceptionModeloFiscalNotFound("O Modelo Fiscal est\u00e1 definido apenas para pessoas que possuem inscri\u00e7\u00e3o estadual, e a pessoa informada n\u00e3o possui inscri\u00e7\u00e3o estadual.");
                }
                if (modeloFiscal.getTipoInscricaoEstadual() == 1 && contribuinteEstado.equals(EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId())) {
                    throw new ExceptionModeloFiscalNotFound("O Modelo Fiscal est\u00e1 definido apenas para pessoas isentas de inscri\u00e7\u00e3o estadual, e a pessoa informada possui inscri\u00e7\u00e3o estadual.");
                }
            }
            if (modeloFiscal.getTipoInscricaoFederal() != 2) {
                if (modeloFiscal.getTipoInscricaoFederal() == 0 && ToolString.refina((String)cnpjCpf).length() <= 11) {
                    throw new ExceptionModeloFiscalNotFound("O Modelo Fiscal est\u00e1 definido apenas para pessoas que possuem CNPJ, e a pessoa informada n\u00e3o possui CNPJ.");
                }
                if (modeloFiscal.getTipoInscricaoFederal() == 1 && ToolString.refina((String)cnpjCpf).length() > 11) {
                    throw new ExceptionModeloFiscalNotFound("O Modelo Fiscal est\u00e1 definido para apenas para pessoas que possuem CPF, e a pessoa informada n\u00e3o possui CPF.");
                }
            }
            if (!modeloFiscal.getSuframa().equals(habilitarSuframa)) {
                throw new ExceptionModeloFiscalNotFound("O Suframa do modelo fiscal n\u00e3o confere com a do cadastro de cliente!");
            }
            if (modeloFiscal.getAtivo() == null || modeloFiscal.getAtivo() != 1) {
                throw new ExceptionModeloFiscalNotFound("Modelo Fiscal inativo.");
            }
            boolean bl6 = false;
            for (ModeloFiscalProdutos mp : modeloFiscal.getModeloFiscalProduto().getProdutos()) {
                if (!mp.getProduto().equals(produto) || !mp.getAtivo().equals((short)1)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new ExceptionModeloFiscalNotFound("Dentre os produtos n\u00e3o existe o produto " + produto.toString() + " ou o produto est\u00e1 inativo dentro do Modelo Fiscal.");
            }
            throw new ExceptionModeloFiscalNotFound("Dentre os Produtos do Modelo Fiscal n\u00e3o existe o produto " + String.valueOf(produto) + ".");
        }
        throw new ExceptionModeloFiscalNotFound("Selecione um Modelo fiscal para depurar.");
    }

    private void depurarModeloFiscalNFCe(Produto produto, NaturezaOperacao naturezaOperacao, Empresa empresa, ModeloFiscal modeloFiscal) throws ExceptionModeloFiscalNotFound {
        NaturezaOperacao natureza = naturezaOperacao;
        boolean flagNatOpe = false;
        if (modeloFiscal != null) {
            for (ModeloFiscalNaturezaOperacao n : modeloFiscal.getNaturezaOperacao()) {
                if (!n.getNaturezaOperacao().equals(natureza)) continue;
                flagNatOpe = true;
            }
            if (!flagNatOpe) {
                throw new ExceptionModeloFiscalNotFound("A natureza de Opera\u00e7\u00e3o informada n\u00e3o confere com a(s) natureza(s) informada(s) no Modelo Fiscal.");
            }
            boolean flagEmpresa = false;
            for (ModeloFiscalEmpresa emp : modeloFiscal.getEmpresas()) {
                if (!emp.getEmpresa().equals(empresa) || !emp.getAtivo().equals((short)1)) continue;
                flagEmpresa = true;
            }
            if (!flagEmpresa) {
                throw new ExceptionModeloFiscalNotFound("Dentre as Empresas do Modelo Fiscal n\u00e3o existe a Empresa " + empresa.toString() + " ou a empresa est\u00e1 inativa dentro do Modelo Fiscal.");
            }
            if (modeloFiscal.getAtivo() == null || modeloFiscal.getAtivo() != 1) {
                throw new ExceptionModeloFiscalNotFound("Modelo Fiscal inativo.");
            }
            throw new ExceptionModeloFiscalNotFound("Dentre os Produtos do Modelo Fiscal n\u00e3o existe o produto " + String.valueOf(produto) + ".");
        }
        throw new ExceptionModeloFiscalNotFound("Selecione um Modelo fiscal para depurar.");
    }

    public Short buildTipoInscFederal(String cnpjCPF) {
        Short tipoInscFederal = ToolString.refina((String)cnpjCPF).length() > 11 ? (short)0 : 1;
        return tipoInscFederal;
    }

    public Short buildTipoInscEstadual(Short contribuinteEstado) {
        Short tipoInscEstadual = 1;
        tipoInscEstadual = contribuinteEstado == null || contribuinteEstado.equals(EnumConstContrEstadoIcms.ISENTO.getEnumId()) || contribuinteEstado.equals(EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId()) ? Short.valueOf((short)1) : Short.valueOf((short)0);
        return tipoInscEstadual;
    }

    public Cfop getCFOP(NFCe nfce, ModeloFiscal modFiscalItem) {
        return this.getCFOP(nfce, nfce.getEmpresa(), nfce.getModeloDocFiscal(), modFiscalItem);
    }

    public UnidadeFederativa getUFPrestServico(NFCe nfce) {
        return this.getUFPrestServico(nfce.getEnderecoEntrega(), nfce.getNfcePessoa(), nfce.getUnidadeFatCliente(), nfce.getEmpresa());
    }

    public UnidadeFederativa getUFPrestServico(Pedido pedido) {
        return this.getUFPrestServico(pedido.getUnidadeFatCliente(), pedido.getEmpresa());
    }

    public UnidadeFederativa getUFCliente(NFCePessoa nfcePessoa, UnidadeFatCliente unid) {
        if (unid != null && unid.getPessoa() != null) {
            return unid.getPessoa().getEndereco().getCidade().getUf();
        }
        if (nfcePessoa != null && nfcePessoa.getCidade() != null) {
            return nfcePessoa.getCidade().getUf();
        }
        return null;
    }

    public UnidadeFederativa getUFPrestServico(EnderecoEntregaPedido endEntrega, UnidadeFatCliente unid, Empresa emp) {
        if (endEntrega != null && endEntrega.getCidade() != null) {
            return endEntrega.getCidade().getUf();
        }
        return this.getUFPrestServico(unid, emp);
    }

    public UnidadeFederativa getUFPrestServico(NFCeEnderecoEntrega endEntrega, NFCePessoa nfcePessoa, UnidadeFatCliente unid, Empresa emp) {
        if (endEntrega != null && endEntrega.getCidade() != null) {
            return endEntrega.getCidade().getUf();
        }
        return this.getUFPrestServico(nfcePessoa, unid, emp);
    }

    public UnidadeFederativa getUFPrestServico(NFCePessoa nfcePessoa, UnidadeFatCliente unid, Empresa emp) {
        if (nfcePessoa != null && nfcePessoa.getCidade() != null) {
            return nfcePessoa.getCidade().getUf();
        }
        return this.getUFPrestServico(unid, emp);
    }

    public UnidadeFederativa getUFPrestServico(UnidadeFatCliente unid, Empresa emp) {
        if (unid != null && unid.getPessoa() != null) {
            return unid.getPessoa().getEndereco().getCidade().getUf();
        }
        return emp.getPessoa().getEndereco().getCidade().getUf();
    }

    private Cfop getCFOP(NFCe nfce, Empresa emp, ModeloDocFiscal modeloDocFiscal, ModeloFiscal modFiscal) {
        UnidadeFederativa uf;
        EnumConstUF ufEmpresa;
        UnidadeFederativa ufEmp = emp.getPessoa().getEndereco().getCidade().getUf();
        EnumConstUF ufParceiro = ufEmpresa = EnumConstUF.valueOfCodigoIbge((String)ufEmp.getCodIbge());
        if (!ToolMethods.isEquals((Object)modeloDocFiscal.getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo()) && (uf = this.getUFPrestServico(nfce)) != null) {
            ufParceiro = EnumConstUF.valueOfCodigoIbge((String)uf.getCodIbge());
        }
        String codCfop = CompCfop.getCodigoCFOP((EnumConstantsMentorEntSaida)EnumConstantsMentorEntSaida.SAIDA, (EnumConstUF)ufEmpresa, (EnumConstUF)ufParceiro, (EnumConstCfop)EnumConstCfop.CFOP_INTERNO, (String)modFiscal.getCfop());
        ServiceCfop serviceCfop = Main.getBean(ServiceCfop.class);
        return serviceCfop.findCfopByCodigo(codCfop);
    }

    public Cfop getCFOP(Pedido pedido, ModeloFiscal modFiscal) {
        EnumConstUF ufEmpresa;
        UnidadeFederativa ufEmp = pedido.getEmpresa().getPessoa().getEndereco().getCidade().getUf();
        EnumConstUF ufParceiro = ufEmpresa = EnumConstUF.valueOfCodigoIbge((String)ufEmp.getCodIbge());
        UnidadeFederativa uf = this.getUFPrestServico(pedido);
        if (uf != null) {
            ufParceiro = EnumConstUF.valueOfCodigoIbge((String)uf.getCodIbge());
        }
        String codCfop = CompCfop.getCodigoCFOP((EnumConstantsMentorEntSaida)EnumConstantsMentorEntSaida.SAIDA, (EnumConstUF)ufEmpresa, (EnumConstUF)ufParceiro, (EnumConstCfop)EnumConstCfop.CFOP_INTERNO, (String)modFiscal.getCfop());
        ServiceCfop serviceCfop = Main.getBean(ServiceCfop.class);
        return serviceCfop.findCfopByCodigo(codCfop);
    }
}

