/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.venda.auxparamtribcbsibs;

import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.model.CategoriaCbsIbs;
import com.touchcomp.touchnfce.model.Cfop;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.ParamTribCbsIbsClass;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.TipoContribuinteCbsIbs;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.service.impl.ServiceParamTribCbsIbs;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class AuxParamTribCbsIbs {
    public List<ParamTribCbsIbsClass> getParametrizacoesNFe(NFCe nfce, Produto produto, ModeloFiscal modeloFiscal, EnumConstModDocFiscal mod, int qtdReg) {
        if (ToolMethods.isNull((Object)modeloFiscal).booleanValue()) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        Cfop cfop = new AuxModeloFiscal().getCFOP(nfce, modeloFiscal);
        return this.getParametrizacoes(nfce.getDataEmissao(), nfce.getEmpresa(), nfce.getUnidadeFatCliente(), produto, mod, cfop, qtdReg, nfce.getInformarDadosReformaTributaria());
    }

    public List<ParamTribCbsIbsClass> getParametrizacoesNFe(Pedido pedido, Produto produto, ModeloFiscal modeloFiscal, EnumConstModDocFiscal mod, int qtdReg) {
        if (ToolMethods.isAnyNull((Object[])new Object[]{pedido.getEmpresa(), pedido.getUnidadeFatCliente(), modeloFiscal})) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        Cfop cfop = new AuxModeloFiscal().getCFOP(pedido, modeloFiscal);
        return this.getParametrizacoes(pedido.getDataEmissao(), pedido.getEmpresa(), pedido.getUnidadeFatCliente(), produto, mod, cfop, qtdReg, StaticObjects.getOpcoes().getInformarDadosReformaTributaria());
    }

    public ParamTribCbsIbsClass getParametrizacaoNFe(NFCe nfce, Produto produto, ModeloFiscal modeloFiscal) {
        List<ParamTribCbsIbsClass> found = this.getParametrizacoesNFe(nfce, produto, modeloFiscal, EnumConstModDocFiscal.get((Object)nfce.getModeloDocFiscal().getCodigo()), -1);
        return found.isEmpty() ? null : found.get(0);
    }

    public ParamTribCbsIbsClass getParametrizacaoNFe(Pedido pedido, Produto produto, ModeloFiscal modeloFiscal) {
        List<ParamTribCbsIbsClass> found = this.getParametrizacoesNFe(pedido, produto, modeloFiscal, EnumConstModDocFiscal.NFE, -1);
        return found.isEmpty() ? null : found.get(0);
    }

    private List<ParamTribCbsIbsClass> getParametrizacoes(Date dataEmissao, Empresa empresa, UnidadeFatCliente unidadeFatCliente, Produto produto, EnumConstModDocFiscal modeloDocFiscal, Cfop cfop, Integer qtdReg, Short informarDadosReformaTributaria) {
        if (!ToolMethods.isAffirmative((Number)informarDadosReformaTributaria)) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        if (ToolMethods.isNull((Object)empresa).booleanValue()) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        ServiceParamTribCbsIbs serviceParamTribCbsIbs = Main.getBean(ServiceParamTribCbsIbs.class);
        List<ParamTribCbsIbsClass> found = serviceParamTribCbsIbs.getParametrizacaoGeral();
        if (ToolMethods.isWithData(found)) {
            return found;
        }
        TipoContribuinteCbsIbs tipo = null;
        CategoriaCbsIbs categoria = null;
        if (ToolMethods.isNull((Object)unidadeFatCliente).booleanValue()) {
            tipo = StaticObjects.getOpcoes().getTipoContribuinteCbsIbs();
            categoria = StaticObjects.getOpcoes().getCategoriaCbsIbs();
        } else {
            tipo = unidadeFatCliente.getTipoContribuinteCbsIbs();
            categoria = unidadeFatCliente.getCategoriaCbsIbs();
            if (tipo == null) {
                tipo = unidadeFatCliente.getCliente().getFaturamento().getTipoContribuinteCbsIbs();
            }
            if (categoria == null) {
                categoria = unidadeFatCliente.getCliente().getFaturamento().getCategoriaCbsIbs();
            }
        }
        if (ToolMethods.isAnyNull((Object[])new Object[]{dataEmissao, empresa, produto.getNcm(), modeloDocFiscal, cfop, categoria, tipo})) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        found = serviceParamTribCbsIbs.getParametrizacao(dataEmissao, empresa, produto.getNcm(), produto.getRegraExcecaoCbsIbs(), modeloDocFiscal, cfop, categoria, tipo, qtdReg);
        return found;
    }
}

