/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.venda.helper;

import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.helpers.preco.HelperPrecos;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.util.List;

public class AuxProduto {
    public TempPesquisaProduto.TextProduto getProdutosPrecos(String texto, NFCe nfce) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        if (texto == null) {
            return null;
        }
        HelperPrecos helper = Main.getBean(HelperPrecos.class);
        List<TempPesquisaProduto> prod = null;
        TempPesquisaProduto.TextProduto textProduto = this.processaTexto(texto);
        prod = nfce != null ? helper.getProdutos(textProduto.getCodigoProduto(), StaticObjects.getEmpresa(), nfce.getUnidadeFatCliente(), StaticObjects.getOpcoes(), nfce.getRepresentante(), StaticObjects.getUsuario(), StaticObjects.getGrupo(), nfce.getDadosTransporte().getTipoFrete(), nfce.getNaturezaOperacao(), nfce.getCondicoesPagamento(), null, null) : helper.getProdutos(textProduto.getCodigoProduto(), StaticObjects.getEmpresa(), null, StaticObjects.getOpcoes(), null, StaticObjects.getUsuario(), StaticObjects.getGrupo(), null, null, null, null, null);
        if (textProduto.getValor() > 0.0 && !prod.isEmpty()) {
            TempPesquisaProduto temp = prod.get(0);
            Double valorTabelaPreco = temp.getValorUnitarioTabPreco();
            textProduto.setQuantidade(ToolFormatter.arrredondarNumero((Double)(textProduto.getValor() / valorTabelaPreco), (int)3));
            temp.setValorTotalFixo(textProduto.getValor());
            temp.setUsaValorTotalFixo(true);
            textProduto.setCodigoPesavel(true);
        }
        textProduto.setTempPesquisaProduto(prod);
        return textProduto;
    }

    private TempPesquisaProduto.TextProduto processaTexto(String texto) {
        TempPesquisaProduto.TextProduto t = new TempPesquisaProduto.TextProduto();
        if (UtilNFCe.isCodigoPesavel(texto)) {
            String codigo = texto.substring(1, 7);
            String valor = texto.substring(7, 12);
            String prefixo = valor.substring(0, 3);
            String sufixo = valor.substring(3, 5);
            Double valorConv = new Double(prefixo + "." + sufixo);
            t.setCodigoProduto(ToolString.removerZerosAEsquerda((String)codigo));
            t.setValor(valorConv);
        } else {
            t.setCodigoProduto(texto);
        }
        return t;
    }
}

