/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.vendedor;

import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.modeltemp.ControllerPath;
import com.touchcomp.touchnfce.service.impl.ServiceRepresentante;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class VendedorFechamentoController
extends BaseDialog
implements AutoCompleteTextField.ItemSelListener,
AutoCompleteTextField.ItemSourceFilter {
    public static final String REPRESENTANTE = "representante";
    public static final String lastPath = "lastPath";
    @FXML
    private AnchorPane body;
    @FXML
    private Label lblVendedor;
    @FXML
    private AutoCompleteTextField<Representante> tfVendedor;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    private Representante representante;
    private ControllerPath controllerLastPath;
    private final ServiceRepresentante serviceRepresentante = Main.getBean(ServiceRepresentante.class);

    @Override
    public void initializeController(ResourceBundle rb) {
        this.btnConfirmar.setOnAction(evt -> this.setRepresentante());
        this.btnCancelar.setOnAction(evt -> this.closeDialog());
        this.tfVendedor.setLabel(this.lblVendedor);
        this.tfVendedor.setItemSelListener(this);
        this.tfVendedor.setItemSourceFilter(this);
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfVendedor.requestFocus();
    }

    private void currentToScreen() {
        if (this.controllerLastPath.equals(Controllers.VENDA)) {
            if (StaticObjects.getNfceAberta().getRepresentante() != null) {
                this.tfVendedor.selectValue(StaticObjects.getNfceAberta().getRepresentante());
            }
        } else if (this.controllerLastPath.equals(Controllers.PRE_VENDA) && StaticObjects.getPedidoAberto().getRepresentante() != null) {
            this.tfVendedor.selectValue(StaticObjects.getPedidoAberto().getRepresentante());
        }
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.setRepresentante();
                    break;
                }
                case ESCAPE: {
                    this.closeDialog();
                }
            }
        }
    }

    @Override
    public void posInitialize() {
        this.controllerLastPath = (ControllerPath)this.getParams().get(lastPath);
        this.currentToScreen();
    }

    public Representante getRepresentanteNFCe() {
        return StaticObjects.getNfceAberta().getRepresentante();
    }

    public Representante getRepresentantePedido() {
        return StaticObjects.getPedidoAberto().getRepresentante();
    }

    private void setRepresentante() {
        this.representante = this.tfVendedor.getSelectedValue();
        if (this.representante != null) {
            if (this.controllerLastPath.equals(Controllers.VENDA)) {
                StaticObjects.getNfceAberta().setRepresentante(this.representante);
                for (NFCeItem item : StaticObjects.getNfceAberta().getItens()) {
                    item.setRepresentante(this.representante);
                }
                this.closeDialog();
            } else if (this.controllerLastPath.equals(Controllers.PRE_VENDA)) {
                StaticObjects.getPedidoAberto().setRepresentante(this.representante);
                this.closeDialog();
            }
        } else {
            Alerts.showAlertError("Selecione um representante v\u00e1lido para continuar!");
        }
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }

    public void onItemListener(Object data) {
    }

    @Override
    public SortedSet onTextChange(String text) {
        TreeSet<Representante> representantes = new TreeSet<Representante>();
        representantes.addAll(this.serviceRepresentante.getRepresentantesAtivos(text, StaticObjects.getEmpresa()));
        return representantes;
    }
}

