/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos;

import com.touchcomp.basementor.constants.enums.impostos.EnumConstantsTipoImp;
import com.touchcomp.basementor.constants.enums.impostos.cbsibs.EnumConstantsTipoAliqCBSIBS;
import com.touchcomp.basementor.constants.enums.impostos.cbsibs.EnumConstantsTpAplicacaoIBSCBS;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.model.AliquotaPadraoImposto;
import com.touchcomp.touchnfce.model.AliquotaReferenciaImposto;
import com.touchcomp.touchnfce.model.Cidade;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.ModeloFiscalCbsIbs;
import com.touchcomp.touchnfce.service.impl.ServiceAliquotaPadraoImposto;
import com.touchcomp.touchnfce.service.impl.ServiceAliquotaReferenciaImposto;
import java.util.Date;

public class AuxSetParamsCbsIbs {
    public Double getAliquota(Date dataEmissao, Cidade cidade, EnumConstantsTipoAliqCBSIBS tipoAliq, EnumConstantsTipoImp tipoImposto, Double aliqInformada) throws ExceptionInvalidData {
        if (ToolMethods.isEqualsNumber((Number)tipoAliq.getEnumId(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            return aliqInformada;
        }
        ServiceAliquotaReferenciaImposto serviceAliquotaReferenciaImpostoImpl = Main.getBean(ServiceAliquotaReferenciaImposto.class);
        AliquotaReferenciaImposto aliquotaReferencia = serviceAliquotaReferenciaImpostoImpl.getAliquotaReferenciaImposto(tipoImposto, dataEmissao);
        if (aliquotaReferencia == null) {
            throw new ExceptionInvalidData("E.ERP.2022.001", new Object[]{tipoImposto.getDescricao(), dataEmissao});
        }
        Double aliquota = aliquotaReferencia.getValor();
        AliquotaPadraoImposto aliquotaPadrao = null;
        ServiceAliquotaPadraoImposto serviceAliquotaPadraoImpostoImpl = Main.getBean(ServiceAliquotaPadraoImposto.class);
        switch (tipoImposto) {
            case IBS_MUN: {
                aliquotaPadrao = serviceAliquotaPadraoImpostoImpl.getAliquota(aliquotaReferencia, cidade, dataEmissao);
                break;
            }
            case IBS_UF: {
                aliquotaPadrao = serviceAliquotaPadraoImpostoImpl.getAliquota(aliquotaReferencia, cidade.getUf(), dataEmissao);
                break;
            }
        }
        if (aliquotaPadrao != null) {
            EnumConstantsTpAplicacaoIBSCBS formaApp = EnumConstantsTpAplicacaoIBSCBS.get((Object)aliquotaPadrao.getTipoAplicacao());
            switch (formaApp) {
                case SOMAR: {
                    aliquota = aliquota + aliquotaPadrao.getValor();
                    break;
                }
                case SUBTRAIR: {
                    aliquota = aliquota - aliquotaPadrao.getValor();
                    if (!(aliquota < 0.0)) break;
                    aliquota = 0.0;
                    break;
                }
                default: {
                    aliquota = aliquotaPadrao.getValor();
                }
            }
        }
        return aliquota;
    }

    public Double getRedBC(ClassificacaoTributariaCbsIbs codClassTrib, ModeloFiscalCbsIbs modelo) {
        Double percRedBC = codClassTrib.getPercRedBaseCalculo();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedBC = modelo.getPercRedBC();
        }
        return percRedBC;
    }
}

